/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.jpox.util.Localiser;

public class SchemaToolTask
extends Java {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private int runMode = 1;
    Vector filesets = new Vector();

    public SchemaToolTask() {
        this.setClassname("org.jpox.SchemaTool");
        this.setFork(true);
    }

    public void execute() throws BuildException {
        if (this.runMode == 1) {
            this.createArg().setValue("-create");
        } else if (this.runMode == 2) {
            this.createArg().setValue("-delete");
        } else if (this.runMode == 3) {
            this.createArg().setValue("-validate");
        } else if (this.runMode == 4) {
            this.createArg().setValue("-dbinfo");
        } else if (this.runMode == 5) {
            this.createArg().setValue("-schemainfo");
        }
        for (int i = 0; i < this.getFiles().length; ++i) {
            this.createArg().setFile(this.getFiles()[i]);
        }
        this.setFork(true);
        super.execute();
    }

    public void addFileSet(FileSet fs) {
        this.filesets.addElement(fs);
    }

    protected File[] getFiles() {
        Vector<File> v = new Vector<File>();
        int size = this.filesets.size();
        for (int i = 0; i < size; ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] f = ds.getIncludedFiles();
            for (int j = 0; j < f.length; ++j) {
                String pathname = f[j];
                File file = new File(ds.getBasedir(), pathname);
                file = this.getProject().resolveFile(file.getPath());
                v.addElement(file);
            }
        }
        Object[] files = new File[v.size()];
        v.copyInto(files);
        return files;
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.createArg().setValue("-v");
            this.log("JPOX SchemaTool verbose: " + verbose, 3);
        }
    }

    public void setProps(String propsFileName) {
        if (propsFileName != null && propsFileName.length() > 0) {
            this.createArg().setLine("-props " + propsFileName);
            this.log("JPOX SchemaTool props: " + propsFileName, 3);
        }
    }

    public void setDumpDdl(String ddlFileName) {
        if (ddlFileName != null && ddlFileName.length() > 0) {
            this.createArg().setLine("-dumpDdl " + ddlFileName);
            this.log("JPOX SchemaTool dumpDdl: " + ddlFileName, 3);
        }
    }

    public void setTypes(String userTypesFile) {
        if (userTypesFile != null && userTypesFile.length() > 0) {
            this.createArg().setLine("-types " + userTypesFile);
            this.log("SchemaTool types: " + userTypesFile, 3);
        }
    }

    public void setMode(String mode) {
        if (mode == null) {
            return;
        }
        if (mode.equalsIgnoreCase("create")) {
            this.runMode = 1;
        } else if (mode.equalsIgnoreCase("delete")) {
            this.runMode = 2;
        } else if (mode.equalsIgnoreCase("validate")) {
            this.runMode = 3;
        } else if (mode.equalsIgnoreCase("dbinfo")) {
            this.runMode = 4;
        } else if (mode.equalsIgnoreCase("schemainfo")) {
            this.runMode = 5;
        } else {
            System.err.println(LOCALISER.msg("SchemaTool.ModeInvalid"));
        }
    }
}

