/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jpox.AbstractPersistenceManagerFactory;
import org.jpox.ClassNameConstants;
import org.jpox.LifecycleListenerForClass;
import org.jpox.PersistenceManagerImpl;
import org.jpox.util.JPOXLogger;

public class PersistenceManagerFactoryImpl
extends AbstractPersistenceManagerFactory
implements PersistenceManagerFactory,
ObjectFactory,
Referenceable {
    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Properties props) {
        PersistenceManagerFactoryImpl pmf = new PersistenceManagerFactoryImpl();
        pmf.setOptions(props);
        pmf.freezeConfiguration();
        return pmf;
    }

    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Map props) {
        PersistenceManagerFactoryImpl pmf = new PersistenceManagerFactoryImpl();
        pmf.setOptions(props);
        pmf.freezeConfiguration();
        return pmf;
    }

    public PersistenceManagerFactoryImpl() {
        String tip = null;
        try {
            tip = System.getProperty("org.jpox.transactionIsolation");
        }
        catch (SecurityException e) {
            JPOXLogger.GENERAL.warn(e.getMessage(), e);
        }
        if (tip != null) {
            try {
                this.setTransactionIsolation(tip);
            }
            catch (IllegalArgumentException e) {
                JPOXLogger.TRANSACTION.warn(LOCALISER.msg("PMF.TransactionIsolationInvalid", "org.jpox.transactionIsolation", tip));
            }
        }
        this.setTransactionType("ResourceLocal");
    }

    public synchronized PersistenceManager getPersistenceManager() {
        this.assertIsOpen();
        this.freezeConfiguration();
        return this.getPersistenceManager(this.getPMFConfiguration().getConnectionUserName(), this.getPMFConfiguration().getConnectionPassword());
    }

    public synchronized PersistenceManager getPersistenceManager(String userName, String password) {
        this.assertIsOpen();
        this.freezeConfiguration();
        PersistenceManagerImpl pm = new PersistenceManagerImpl(this, userName, password);
        if (this.lifecycleListeners != null) {
            Iterator listenerIter = this.lifecycleListeners.iterator();
            while (listenerIter.hasNext()) {
                LifecycleListenerForClass listener = (LifecycleListenerForClass)listenerIter.next();
                pm.addInstanceLifecycleListener(listener.getListener(), listener.getClasses());
            }
        }
        this.getPmCache().add(pm);
        return pm;
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PersistenceManagerFactoryImpl)) {
            return false;
        }
        return super.equals(obj);
    }

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        Reference ref;
        PersistenceManagerFactoryImpl rc = null;
        if (obj instanceof Reference && (ref = (Reference)obj).getClassName().equals(ClassNameConstants.PersistenceManagerFactoryImpl)) {
            Properties p = new Properties();
            Enumeration<RefAddr> e = ref.getAll();
            while (e.hasMoreElements()) {
                StringRefAddr sra = (StringRefAddr)e.nextElement();
                p.setProperty(sra.getType(), (String)sra.getContent());
            }
            rc = new PersistenceManagerFactoryImpl();
            rc.setOptions(p);
        }
        return rc;
    }

    public Reference getReference() {
        Reference rc = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            rc = new Reference(ClassNameConstants.PersistenceManagerFactoryImpl, ClassNameConstants.PersistenceManagerFactoryImpl, null);
            Map p = this.getOptions();
            Iterator i = p.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (!(p.get(key) instanceof String)) continue;
                String value = (String)p.get(key);
                rc.add(new StringRefAddr(key, value));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rc;
    }
}

