/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.Extent;
import javax.jdo.FetchPlan;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.datastore.Sequence;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.AbstractPersistenceManagerFactory;
import org.jpox.ClassLoaderResolver;
import org.jpox.FetchPlanImpl;
import org.jpox.PMFContext;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.cache.CachedPC;
import org.jpox.cache.Level1Cache;
import org.jpox.cache.Level2Cache;
import org.jpox.exceptions.ClassNotDetachableException;
import org.jpox.exceptions.ClassNotPersistenceCapableException;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.CommitStateTransitionException;
import org.jpox.exceptions.MetaDataForPersistenceCapableClassNotReachableException;
import org.jpox.exceptions.ObjectDetachedException;
import org.jpox.exceptions.RollbackStateTransitionException;
import org.jpox.exceptions.TransactionActiveException;
import org.jpox.exceptions.TransactionNotActiveException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.QueryLanguage;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.Extension;
import org.jpox.state.CallbackHandler;
import org.jpox.state.DetachState;
import org.jpox.state.FetchPlanState;
import org.jpox.state.StateManagerFactory;
import org.jpox.store.FieldValues;
import org.jpox.store.OID;
import org.jpox.store.OIDFactory;
import org.jpox.store.StoreManager;
import org.jpox.store.StoreManagerFactory;
import org.jpox.store.query.QueryResult;
import org.jpox.store.rdbms.query.JPOXSQLQuery;
import org.jpox.store.rdbms.query.SQLQuery;
import org.jpox.util.AIDUtils;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.SoftValueMap;
import org.jpox.util.WeakValueMap;

public abstract class AbstractPersistenceManager
implements PersistenceManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    protected final AbstractPersistenceManagerFactory apmf;
    private StoreManager srm;
    private Map userObjectMap;
    private Object userObject;
    private boolean closed;
    private Level1Cache cache;
    private Set txKnownPersists = new HashSet();
    private Set txFlushedNew = new HashSet();
    private PersistenceCapable lookingForStateManagerFor = null;
    private StateManager foundStateManager = null;
    protected Transaction tx;
    private Map enlistedSMCache = new WeakValueMap();
    private Set enlistedIds = new HashSet();
    private List dirtySMs = new ArrayList(10);
    private boolean ignoreCache;
    private boolean detachOnClose;
    private boolean detachAllOnCommit;
    private boolean multithreaded;
    private FetchPlan fetchPlan;
    protected ClassLoaderResolver clr = null;
    private Map queryResults = new SoftValueMap();
    private Map queriesRun = new SoftValueMap();
    private CallbackHandler callbacks;
    private boolean runningPBRAtCommit = false;
    private StateManager[] smsToDetachAtCommit = null;
    private int queryResultNumber = 0;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jpox$store$OID;
    static /* synthetic */ Class class$org$jpox$store$SCOID;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    public AbstractPersistenceManager(AbstractPersistenceManagerFactory apmf, String userName, String password) {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        this.clr = apmf.getPMFContext().getClassLoaderResolver(contextLoader);
        try {
            this.clr.registerClassLoader(apmf.getPMFContext().getImplementationCreator().getClassLoader());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.apmf = apmf;
        this.closed = false;
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("PM.Opened", this, this.srm));
        }
        this.srm = this.getStoreManager(apmf, userName, password);
        this.setIgnoreCache(apmf.getPMFConfiguration().getIgnoreCache());
        this.setDetachOnClose(apmf.getPMFConfiguration().getDetachOnClose());
        this.setDetachAllOnCommit(apmf.getPMFConfiguration().getDetachAllOnCommit());
        this.setMultithreaded(apmf.getPMFConfiguration().getMultithreaded());
        this.fetchPlan = new FetchPlanImpl().setMaxFetchDepth(apmf.getMaxFetchDepth());
        this.userObject = null;
        this.userObjectMap = null;
        this.initialiseLevel1Cache();
    }

    protected void initialiseLevel1Cache() {
        String level1Type = this.apmf.getPMFConfiguration().getJdoCacheLevel1Type();
        String level1ClassName = this.apmf.getPMFContext().getPluginManager().getAttributeValueForExtension("org.jpox.cache_level1", "name", level1Type, "class-name");
        if (level1ClassName == null) {
            throw new JDOFatalUserException(LOCALISER.msg("Cache.Level1.PluginNotFound", level1Type));
        }
        try {
            Class<?> level1CacheClass = Class.forName(level1ClassName);
            this.cache = (Level1Cache)level1CacheClass.newInstance();
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.Initialised", level1Type));
            }
        }
        catch (Exception e) {
            throw new JDOFatalUserException(LOCALISER.msg("Cache.Level1.PluginClassNotFound", level1Type, level1ClassName), (Throwable)e);
        }
    }

    private StoreManager getStoreManager(AbstractPersistenceManagerFactory apmf, String userName, String password) {
        int idx;
        Extension[] exts = apmf.getPMFContext().getPluginManager().getExtensionPoint("org.jpox.store_manager").getExtensions();
        String url = apmf.getConnectionURL();
        if (url != null && (idx = url.indexOf(58)) > -1) {
            url = url.substring(0, idx);
        }
        StoreManager srm = null;
        for (int e = 0; srm == null && e < exts.length; ++e) {
            ConfigurationElement[] confElm = exts[e].getConfigurationElements();
            for (int c = 0; srm == null && c < confElm.length; ++c) {
                String storeMgrClassName = confElm[c].getAttribute("class-name");
                String key = confElm[c].getAttribute("key");
                if (url != null && !key.equalsIgnoreCase(url)) continue;
                srm = StoreManagerFactory.getStoreManager(storeMgrClassName, this.clr, apmf, userName, password);
            }
        }
        if (srm == null) {
            srm = StoreManagerFactory.getStoreManager(exts[0].getConfigurationElements()[0].getAttribute("class-name"), this.clr, apmf, userName, password);
        }
        return srm;
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    public StoreManager getStoreManager() {
        return this.srm;
    }

    public FetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public AbstractPersistenceManagerFactory getAbstractPersistenceManagerFactory() {
        return this.apmf;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        throw new JDOException(LOCALISER.msg("PM.GetPersistenceManagerFactoryNotImplemented"));
    }

    public PMFContext getPMFContext() {
        return this.apmf.getPMFContext();
    }

    public MetaDataManager getMetaDataManager() {
        return this.apmf.getPMFContext().getMetaDataManager();
    }

    public abstract PersistenceManager getPMHandle();

    public boolean isDelayDatastoreOperationsEnabled() {
        if (this.tx.isCommitting()) {
            return false;
        }
        if (this.tx.getOptimistic()) {
            return true;
        }
        return this.getPMFContext().getPmfConfiguration().getDatastoreDelayOperationsEnabled();
    }

    public javax.jdo.Transaction currentTransaction() {
        this.assertIsOpen();
        return this.tx;
    }

    public synchronized void enlistInTransaction(StateManager sm) {
        this.assertActiveTransaction();
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.ObjectEnlistedInCache", sm.getInternalObjectId().toString()));
        }
        if (this.apmf.getPersistenceByReachabilityAtCommit()) {
            if (sm.getObject().jdoIsNew()) {
                this.txFlushedNew.add(sm.getInternalObjectId());
            } else if (sm.getObject().jdoIsPersistent() && !sm.getObject().jdoIsDeleted() && !this.txFlushedNew.contains(sm.getInternalObjectId())) {
                this.txKnownPersists.add(sm.getInternalObjectId());
            }
        }
        if (this.apmf.getPersistenceByReachabilityAtCommit() && !this.runningPBRAtCommit) {
            this.enlistedIds.add(sm.getInternalObjectId());
        }
        this.enlistedSMCache.put(sm.getInternalObjectId(), sm);
    }

    public synchronized void evictFromTransaction(StateManager sm) {
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.ObjectEvictedFromCache", sm.getInternalObjectId().toString()));
        }
        if (this.enlistedSMCache.remove(sm.getInternalObjectId()) == null && JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("PM.ObjectNotTransactional", sm.getInternalObjectId()));
        }
    }

    public boolean isEnlistedInTransaction(Object id) {
        if (id == null) {
            return false;
        }
        return this.enlistedIds.contains(id);
    }

    public synchronized void addStateManager(StateManager sm) {
        this.putObjectIntoCache(sm, true, true);
    }

    public synchronized void removeStateManager(StateManager sm) {
        PersistenceCapable pc = sm.getObject();
        this.removeObjectFromCache(pc, sm.getInternalObjectId(), true, false);
        this.enlistedSMCache.remove(sm.getInternalObjectId());
    }

    public synchronized StateManager getStateManagerById(Object id) {
        this.assertIsOpen();
        PersistenceCapable pc = this.getObjectFromCache(id);
        return this.findStateManager(pc);
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.closed) {
            throw new JDOUserException(LOCALISER.msg("PM.IsClosed"));
        }
        if (this.tx.isActive()) {
            throw new TransactionActiveException(this);
        }
        this.userObject = null;
        this.userObjectMap = null;
        if (this.detachOnClose) {
            JPOXLogger.JDO.debug(LOCALISER.msg("PM.DetachOnCloseStart"));
            try {
                this.tx.begin();
                ArrayList toDetach = new ArrayList();
                toDetach.addAll(this.cache.values());
                Iterator iter = toDetach.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    StateManager sm = (StateManager)obj;
                    if (sm == null || sm == null || sm.getObject() == null || sm.isDeleted(sm.getObject())) continue;
                    try {
                        sm.detach(new DetachState());
                    }
                    catch (JDOObjectNotFoundException onfe) {}
                }
                this.tx.commit();
            }
            finally {
                if (this.tx.isActive()) {
                    this.tx.rollback();
                }
            }
            JPOXLogger.JDO.debug(LOCALISER.msg("PM.DetachOnCloseEnd"));
        }
        this.disconnectSMCache();
        this.disconnectQueryCache();
        this.disconnectLifecycleListener();
        this.reset();
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("PM.Closed", this));
        }
    }

    protected void disconnectSMCache() {
        HashSet cachedSMsClone = new HashSet(this.cache.values());
        Iterator iter = cachedSMsClone.iterator();
        while (iter.hasNext()) {
            StateManager sm = (StateManager)iter.next();
            if (sm == null) continue;
            sm.disconnect();
        }
        this.cache.clear();
        if (JPOXLogger.CACHE.isDebugEnabled()) {
            JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.Cleared"));
        }
    }

    protected void reset() {
        this.getFetchPlan().clearGroups().addGroup("default");
        this.apmf.releasePersistenceManager(this);
        this.closed = true;
        this.srm = null;
        this.tx = null;
    }

    protected void disconnectQueryCache() {
        if (this.queryResults.size() > 0) {
            Object[] results = this.queryResults.values().toArray();
            for (int i = 0; i < results.length; ++i) {
                QueryResult qr = (QueryResult)results[i];
                qr.close();
            }
            this.queryResults.clear();
        }
        this.queriesRun.clear();
    }

    protected void disconnectLifecycleListener() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalEvict(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertPersistenceCapable(obj);
            this.assertNotDetached(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            StateManager sm = this.findStateManager(pc);
            if (sm == null) {
                throw new JDOUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
            }
            sm.evict();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized void evict(Object pc) {
        this.assertIsOpen();
        this.internalEvict(pc);
    }

    public synchronized void evictAll(Object[] pcs) {
        this.evictAll(Arrays.asList(pcs));
    }

    public synchronized void evictAll(Collection pcs) {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.internalEvict(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.EvictError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void evictAll() {
        this.assertIsOpen();
        ArrayList stateManagersToEvict = new ArrayList();
        stateManagersToEvict.addAll(this.cache.values());
        Iterator smIter = stateManagersToEvict.iterator();
        while (smIter.hasNext()) {
            StateManager sm = (StateManager)smIter.next();
            PersistenceCapable pc = sm.getObject();
            sm.evict();
            this.removeObjectFromCache(pc, pc.jdoGetObjectId(), true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRefresh(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertPersistenceCapable(obj);
            this.assertNotDetached(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            StateManager sm = this.findStateManager(pc);
            if (sm == null) {
                throw new JDOUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
            }
            sm.refresh();
            this.putObjectIntoCache(sm, false, true);
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized void refresh(Object pc) {
        this.assertIsOpen();
        this.internalRefresh(pc);
    }

    public synchronized void refreshAll(Object[] pcs) {
        this.refreshAll(Arrays.asList(pcs));
    }

    public synchronized void refreshAll(Collection pcs) {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator iter = pcs.iterator();
        while (iter.hasNext()) {
            try {
                this.internalRefresh(iter.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.RefreshError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void refreshAll() {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        HashSet toRefresh = new HashSet();
        toRefresh.addAll(this.enlistedSMCache.values());
        toRefresh.addAll(this.dirtySMs);
        if (!this.tx.isActive()) {
            toRefresh.addAll(this.cache.values());
        }
        Iterator iter = toRefresh.iterator();
        while (iter.hasNext()) {
            try {
                StateManager sm;
                Object obj = iter.next();
                if (obj instanceof PersistenceCapable) {
                    PersistenceCapable pc = (PersistenceCapable)obj;
                    sm = this.findStateManager(pc);
                } else {
                    sm = (StateManager)obj;
                }
                sm.refresh();
                this.putObjectIntoCache(sm, false, true);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.RefreshError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void refreshAll(JDOException exc) {
        Throwable[] nested_excs;
        Object obj = exc.getFailedObject();
        if (obj != null) {
            this.refresh(obj);
        }
        if ((nested_excs = exc.getNestedExceptions()) != null) {
            for (int i = 0; i < nested_excs.length; ++i) {
                if (!(nested_excs[i] instanceof JDOException)) continue;
                this.refreshAll((JDOException)nested_excs[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRetrieve(Object obj, boolean fgOnly) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertPersistenceCapable(obj);
            this.assertNotDetached(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            StateManager sm = this.findStateManager(pc);
            if (sm == null) {
                throw new JDOUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
            }
            sm.retrieve(fgOnly);
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void internalRetrieve(Object obj, FetchPlan fetchPlan) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertPersistenceCapable(obj);
            this.assertNotDetached(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            StateManager sm = this.findStateManager(pc);
            if (sm == null) {
                throw new JDOUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
            }
            sm.retrieve(fetchPlan);
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized void retrieve(Object pc, boolean fgOnly) {
        this.assertIsOpen();
        this.internalRetrieve(pc, fgOnly);
    }

    public synchronized void retrieve(Object pc, FetchPlan fetchPlan) {
        this.assertIsOpen();
        this.internalRetrieve(pc, fetchPlan);
    }

    public synchronized void retrieve(Object pc) {
        this.retrieve(pc, false);
    }

    public synchronized void retrieveAll(Object[] pcs) {
        this.retrieveAll(Arrays.asList(pcs), false);
    }

    public void retrieveAll(Object[] pcs, boolean fgOnly) {
        this.retrieveAll(Arrays.asList(pcs), fgOnly);
    }

    public void retrieveAll(Collection pcs, boolean fgOnly) {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.internalRetrieve(i.next(), fgOnly);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.RetrieveError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void retrieveAll(Collection pcs) {
        this.retrieveAll(pcs.toArray(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internalMakePersistent(Object obj, FieldValues preInsertChanges) {
        if (obj == null) {
            return null;
        }
        try {
            StateManager sm;
            javax.jdo.PersistenceManager pm;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertPersistenceCapable(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            if (!pc.jdoIsDetached() && JPOXLogger.JDO.isDebugEnabled()) {
                try {
                    JPOXLogger.JDO.debug(LOCALISER.msg("PM.MakePersistent", pc));
                }
                catch (Exception e) {
                    JPOXLogger.JDO.debug(LOCALISER.msg("PM.MakePersistent", pc.getClass().getName()));
                }
            }
            if (!((pm = pc.jdoGetPersistenceManager()) == null || pm instanceof PersistenceManager && ((PersistenceManager)pm).getPMHandle() == this.getPMHandle())) {
                throw new JDOUserException(LOCALISER.msg("PM.DifferentOwner", obj));
            }
            Object persistedPc = pc;
            if (pc.jdoIsDetached()) {
                this.assertDetachable(obj);
                persistedPc = this.attachCopy(pc, false);
            } else if (pc.jdoIsTransactional() && !pc.jdoIsPersistent()) {
                sm = this.findStateManager(pc);
                if (sm == null) {
                    throw new JDOUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
                }
                sm.makePersistentTransactionalTransient();
            } else if (!pc.jdoIsPersistent()) {
                if (this.multithreaded) {
                    sm = pc;
                    synchronized (sm) {
                        StateManager sm2 = this.findStateManager(pc);
                        if (sm2 == null) {
                            sm2 = StateManagerFactory.newStateManager((PersistenceManager)this, pc, preInsertChanges);
                            sm2.makePersistent();
                        } else if (sm2.getAttachedPC() == null) {
                            sm2.makePersistent();
                        } else {
                            persistedPc = sm2.getAttachedPC();
                        }
                    }
                } else {
                    sm = this.findStateManager(pc);
                    if (sm == null) {
                        sm = StateManagerFactory.newStateManager((PersistenceManager)this, pc, preInsertChanges);
                        sm.makePersistent();
                    } else if (sm.getAttachedPC() == null) {
                        sm.makePersistent();
                    } else {
                        persistedPc = sm.getAttachedPC();
                    }
                }
            } else if (pc.jdoIsPersistent() && pc.jdoGetObjectId() == null) {
                if (this.multithreaded) {
                    sm = pc;
                    synchronized (sm) {
                        StateManager sm3 = this.findStateManager(pc);
                        sm3.makePersistent();
                    }
                } else {
                    sm = this.findStateManager(pc);
                    sm.makePersistent();
                }
            }
            Object object = persistedPc;
            return object;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized Object makePersistentInternal(Object obj, FieldValues preInsertChanges) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        return this.internalMakePersistent(obj, preInsertChanges);
    }

    public synchronized Object makePersistent(Object obj) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        if (obj == null) {
            return null;
        }
        boolean detached = JDOHelper.isDetached((Object)obj);
        Object persistedPc = this.internalMakePersistent(obj, null);
        StateManager sm = this.findStateManager((PersistenceCapable)persistedPc);
        if (this.apmf.getPersistenceByReachabilityAtCommit() && sm != null && (detached || sm.isNew((PersistenceCapable)persistedPc))) {
            this.txKnownPersists.add(sm.getInternalObjectId());
        }
        return persistedPc;
    }

    public synchronized Object[] makePersistentAll(Object[] pcs) {
        return this.makePersistentAll(Arrays.asList(pcs)).toArray();
    }

    public synchronized Collection makePersistentAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        ArrayList<Object> persistedPcs = new ArrayList<Object>();
        while (i.hasNext()) {
            try {
                Object persistedPc = this.makePersistent(i.next());
                persistedPcs.add(persistedPc);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.MakePersistentError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
        return persistedPcs;
    }

    public boolean isInserting(PersistenceCapable pc) {
        StateManager sm = this.findStateManager(pc);
        if (sm == null) {
            return false;
        }
        return sm.isInserting();
    }

    public boolean isInserted(PersistenceCapable pc, int fieldNumber) {
        StateManager sm = this.findStateManager(pc);
        if (sm == null) {
            return false;
        }
        return sm.isInserted(fieldNumber);
    }

    public synchronized Object attachCopy(Object pc, boolean embedded) {
        this.assertIsOpen();
        this.assertPersistenceCapable(pc);
        this.assertDetachable(pc);
        Object id = ((PersistenceCapable)pc).jdoGetObjectId();
        if (id != null && this.isInserting((PersistenceCapable)pc)) {
            return pc;
        }
        if (id == null && !embedded) {
            return this.makePersistentInternal(pc, null);
        }
        if (((PersistenceCapable)pc).jdoIsPersistent()) {
            return pc;
        }
        if (JPOXLogger.JDO.isDebugEnabled()) {
            try {
                JPOXLogger.JDO.debug(LOCALISER.msg("PM.MakePersistentAttach", pc));
            }
            catch (Exception e) {
                JPOXLogger.JDO.debug(LOCALISER.msg("PM.MakePersistentAttach", pc.getClass().getName()));
            }
        }
        PersistenceCapable pcTarget = null;
        if (embedded) {
            boolean detached = false;
            if (JDOHelper.isDetached((Object)pc)) {
                detached = true;
            }
            StateManager smTarget = StateManagerFactory.newStateManager((PersistenceCapable)pc, this, true);
            pcTarget = smTarget.getObject();
            if (detached) {
                smTarget.attachCopy((PersistenceCapable)pc, embedded);
            }
        } else {
            pcTarget = (PersistenceCapable)this.getObjectById(id, false, false, pc.getClass().getName());
            this.findStateManager(pcTarget).attachCopy((PersistenceCapable)pc, embedded);
        }
        return pcTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDeletePersistent(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertPersistenceCapable(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            if (pc.jdoIsDetached()) {
                pc = (PersistenceCapable)this.getObjectById(pc.jdoGetObjectId());
            }
            if (JPOXLogger.JDO.isDebugEnabled()) {
                try {
                    JPOXLogger.JDO.debug(LOCALISER.msg("PM.DeletePersistent", pc));
                }
                catch (Exception e) {
                    JPOXLogger.JDO.debug(LOCALISER.msg("PM.DeletePersistent", pc.getClass().getName()));
                }
            }
            if (!pc.jdoIsPersistent() && !pc.jdoIsTransactional()) {
                throw new JDOUserException(LOCALISER.msg("PM.DeletePersistentOnTransientInstances"));
            }
            if (!pc.jdoIsPersistent() && pc.jdoIsTransactional()) {
                throw new JDOUserException(LOCALISER.msg("PM.DeletePersistentOnTransactionalInstances"));
            }
            StateManager sm = this.findStateManager(pc);
            if (sm == null) {
                throw new JDOUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
            }
            sm.deletePersistent();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized void deletePersistent(Object obj) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        this.internalDeletePersistent(obj);
    }

    public synchronized void deletePersistentAll(Object[] pcs) {
        this.deletePersistentAll(Arrays.asList(pcs));
    }

    public synchronized void deletePersistentAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.internalDeletePersistent(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.DeletePersistentError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void internalMakeTransient(Object obj, FetchPlanState state) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertPersistenceCapable(obj);
            this.assertNotDetached(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            if (JPOXLogger.JDO.isDebugEnabled()) {
                try {
                    JPOXLogger.JDO.debug(LOCALISER.msg("PM.MakeTransient", pc));
                }
                catch (Exception e) {
                    JPOXLogger.JDO.debug(LOCALISER.msg("PM.MakeTransient", pc.getClass().getName()));
                }
            }
            if (pc.jdoIsPersistent()) {
                StateManager sm = this.findStateManager(pc);
                sm.makeTransient(state);
            }
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized void makeTransient(Object pc, boolean useFetchPlan) {
        this.assertIsOpen();
        FetchPlanState state = null;
        if (useFetchPlan) {
            state = new FetchPlanState();
        }
        this.internalMakeTransient(pc, state);
    }

    public synchronized void makeTransient(Object pc) {
        this.makeTransient(pc, false);
    }

    public synchronized void makeTransientAll(Object[] pcs) {
        this.makeTransientAll(Arrays.asList(pcs));
    }

    public synchronized void makeTransientAll(Object[] pcs, boolean includeFetchPlan) {
        this.makeTransientAll(Arrays.asList(pcs), includeFetchPlan);
    }

    public synchronized void makeTransientAll(Collection pcs, boolean useFetchPlan) {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        FetchPlanState state = null;
        if (useFetchPlan) {
            state = new FetchPlanState();
        }
        while (i.hasNext()) {
            try {
                this.internalMakeTransient(i.next(), state);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.MakeTransientError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void makeTransientAll(Collection pcs) {
        this.makeTransientAll(pcs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalMakeTransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            StateManager sm;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertPersistenceCapable(obj);
            this.assertNotDetached(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            if (pc.jdoIsPersistent()) {
                this.assertActiveTransaction();
            }
            if ((sm = this.findStateManager(pc)) == null) {
                sm = StateManagerFactory.newStateManager(this, pc);
            }
            sm.makeTransactional();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized void makeTransactional(Object pc) {
        this.assertIsOpen();
        this.internalMakeTransactional(pc);
    }

    public synchronized void makeTransactionalAll(Object[] pcs) {
        this.makeTransactionalAll(Arrays.asList(pcs));
    }

    public synchronized void makeTransactionalAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.internalMakeTransactional(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.MakeTransactionalError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalMakeNontransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertPersistenceCapable(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            if (!pc.jdoIsPersistent() && pc.jdoIsTransactional() && pc.jdoIsDirty()) {
                throw new JDOUserException(LOCALISER.msg("PM.MakeNonTransactionalOnTransientDirtyInstances"));
            }
            StateManager sm = this.findStateManager(pc);
            sm.makeNontransactional();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized void makeNontransactional(Object pc) {
        this.assertIsOpen();
        if (pc == null) {
            return;
        }
        if (this.tx.isActive()) {
            this.assertActiveTransaction();
        }
        if (!((PersistenceCapable)pc).jdoIsTransactional() && !((PersistenceCapable)pc).jdoIsPersistent()) {
            throw new JDOUserException(LOCALISER.msg("PM.MakeNontransactionalOnNontransactionalTransientInstances"));
        }
        if (!((PersistenceCapable)pc).jdoIsTransactional() && ((PersistenceCapable)pc).jdoIsPersistent()) {
            return;
        }
        this.internalMakeNontransactional(pc);
    }

    public synchronized void makeNontransactionalAll(Object[] pcs) {
        this.makeNontransactionalAll(Arrays.asList(pcs));
    }

    public synchronized void makeNontransactionalAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.internalMakeNontransactional(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PM.MakeNonTransactionalError"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void detachInternal(Object pc, FetchPlanState state) {
        StateManager sm;
        this.assertIsOpen();
        this.assertPersistenceCapable(pc);
        this.assertDetachable(pc);
        if (JDOHelper.isDetached((Object)pc)) {
            return;
        }
        if (!JDOHelper.isPersistent((Object)pc) && this.tx.isActive()) {
            this.internalMakePersistent(pc, null);
        }
        if ((sm = this.findStateManager((PersistenceCapable)pc)) == null) {
            throw new JDOUserException(LOCALISER.msg("PM.DifferentOwner", ((PersistenceCapable)pc).jdoGetObjectId()));
        }
        sm.detach(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internalDetachCopy(Object pc, FetchPlanState state) {
        Object thePC = pc;
        try {
            PersistenceCapable detached;
            this.clr.setPrimary(pc.getClass().getClassLoader());
            if (!JDOHelper.isPersistent((Object)pc) && !JDOHelper.isDetached((Object)pc)) {
                if (this.tx.isActive()) {
                    thePC = this.internalMakePersistent(pc, null);
                } else {
                    throw new JDOUserException(LOCALISER.msg("PM.Detach.TransientOutsideTransaction"));
                }
            }
            if (((PersistenceCapable)thePC).jdoIsDetached()) {
                thePC = this.getObjectById(JDOHelper.getObjectId((Object)thePC), false);
            }
            if ((detached = ((DetachState)state).getDetachedCopyObject(thePC)) == null) {
                StateManager sm = this.findStateManager((PersistenceCapable)thePC);
                if (sm == null) {
                    throw new JDOUserException(LOCALISER.msg("PM.DifferentOwner", ((PersistenceCapable)thePC).jdoGetObjectId()));
                }
                detached = (PersistenceCapable)sm.detachCopy(state);
                ((DetachState)state).setDetachedCopyObject(detached, sm.getExternalObjectId(sm.getObject()));
            }
            PersistenceCapable persistenceCapable = detached;
            return persistenceCapable;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized Object detachCopyInternal(Object pc, FetchPlanState state) {
        this.assertIsOpen();
        this.assertPersistenceCapable(pc);
        return this.internalDetachCopy(pc, state);
    }

    public synchronized Object detachCopy(Object pc) {
        this.assertIsOpen();
        if (pc == null) {
            return null;
        }
        this.assertPersistenceCapable(pc);
        this.assertActiveTransactionOrNontransactionRead("detachCopy");
        return this.internalDetachCopy(pc, new DetachState());
    }

    public synchronized Object[] detachCopyAll(Object[] pcs) {
        return this.detachCopyAll(Arrays.asList(pcs)).toArray();
    }

    public synchronized Collection detachCopyAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransactionOrNontransactionRead("detachCopyAll");
        DetachState state = new DetachState();
        ArrayList<Object> detacheds = new ArrayList<Object>();
        Iterator it = pcs.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj == null) {
                detacheds.add(null);
                continue;
            }
            detacheds.add(this.detachCopyInternal(obj, state));
        }
        return detacheds;
    }

    public synchronized Query newQuery() {
        return this.newQuery("javax.jdo.query.JDOQL", null);
    }

    public synchronized Query newQuery(Object obj) {
        if (obj instanceof SQLQuery) {
            return this.newQuery("javax.jdo.query.SQL", obj);
        }
        if (obj instanceof JPOXSQLQuery) {
            return this.newQuery("javax.jdo.query.JPOXSQL", obj);
        }
        return this.newQuery("javax.jdo.query.JDOQL", obj);
    }

    public synchronized Query newQuery(String query) {
        return this.newQuery("javax.jdo.query.JDOQL", (Object)query);
    }

    public synchronized Query newQuery(String language, Object query) {
        this.assertIsOpen();
        if (language == null) {
            language = "javax.jdo.query.JDOQL";
        }
        if (!this.srm.supportsQueryLanguage(language)) {
            throw new JDOUserException("PM.Query.LanguageNotSupportedByStore");
        }
        return this.srm.newQuery(language, this.getPMHandle(), query);
    }

    public synchronized Query newQuery(Class cls) {
        Query query = this.newQuery();
        query.setClass(cls);
        return query;
    }

    public synchronized Query newQuery(Extent cln) {
        Query query = this.newQuery();
        query.setClass(cln.getCandidateClass());
        query.setCandidates(cln);
        return query;
    }

    public synchronized Query newQuery(Class cls, Collection cln) {
        Query query = this.newQuery();
        query.setClass(cls);
        query.setCandidates(cln);
        return query;
    }

    public synchronized Query newQuery(Class cls, String filter) {
        Query query = this.newQuery();
        query.setClass(cls);
        query.setFilter(filter);
        return query;
    }

    public synchronized Query newQuery(Class cls, Collection cln, String filter) {
        Query query = this.newQuery();
        query.setClass(cls);
        query.setCandidates(cln);
        query.setFilter(filter);
        return query;
    }

    public synchronized Query newQuery(Extent cln, String filter) {
        Query query = this.newQuery();
        query.setClass(cln.getCandidateClass());
        query.setCandidates(cln);
        query.setFilter(filter);
        return query;
    }

    public synchronized Query newNamedQuery(Class cls, String queryName) {
        this.assertIsOpen();
        if (queryName == null) {
            throw new JDOUserException(LOCALISER.msg("PM.Query.NamedQueryNotFound", queryName, cls));
        }
        QueryMetaData qmd = this.getMetaDataManager().getMetaDataForQuery(cls, this.clr, queryName);
        if (qmd == null) {
            throw new JDOUserException(LOCALISER.msg("PM.Query.NamedQueryNotFound", queryName, cls));
        }
        Query query = this.newQuery(qmd.getLanguage().toString(), (Object)qmd.getQuery());
        if (cls != null) {
            query.setClass(cls);
            if (!this.srm.managesClass(cls.getName())) {
                this.srm.addClass(cls.getName(), this.clr);
            }
        }
        if (qmd.getLanguage() == QueryLanguage.JDOQL && (qmd.isUnique() || qmd.getResultClass() != null)) {
            throw new JDOUserException(LOCALISER.msg("PM.Query.NamedQueryJDOQLOnlySingleString", queryName));
        }
        if (qmd.isUnique()) {
            query.setUnique(true);
        }
        if (qmd.getResultClass() != null) {
            Class resultCls = null;
            try {
                resultCls = this.clr.classForName(qmd.getResultClass());
            }
            catch (ClassNotResolvedException cnre) {
                try {
                    String resultClassName = cls.getPackage().getName() + "." + qmd.getResultClass();
                    resultCls = this.clr.classForName(resultClassName);
                }
                catch (ClassNotResolvedException cnre2) {
                    throw new JDOUserException(LOCALISER.msg("PM.Query.NamedQueryResultClassNotFound", queryName, qmd.getResultClass()));
                }
            }
            query.setResultClass(resultCls);
        }
        if (qmd.getLanguage() == QueryLanguage.JPOXSQL) {
            if (qmd.hasExtension("imports")) {
                query.declareImports(qmd.getValueForExtension("imports"));
            }
            if (qmd.hasExtension("parameters")) {
                query.declareParameters(qmd.getValueForExtension("parameters"));
            }
        }
        if (qmd.isUnmodifiable()) {
            query.setUnmodifiable();
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Extent getExtent(Class pcClass, boolean subclasses) {
        this.assertIsOpen();
        try {
            this.clr.setPrimary(pcClass.getClassLoader());
            this.assertPersistenceCapableClass(pcClass);
            Extent extent = this.srm.getExtent(this.getPMHandle(), pcClass, subclasses);
            return extent;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized Extent getExtent(Class pcClass) {
        return this.getExtent(pcClass, true);
    }

    public Object newInstance(Class persistenceCapable) {
        this.assertIsOpen();
        return this.apmf.getImplementationCreator().newInstance(persistenceCapable, this.getMetaDataManager(), this.getClassLoaderResolver());
    }

    public Object newObjectIdInstance(Class pcClass, Object key) {
        this.assertIsOpen();
        if (pcClass == null) {
            throw new JDOUserException(LOCALISER.msg("PM.ObjectId.ClassIsNull"));
        }
        this.assertPersistenceCapableClass(pcClass);
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(pcClass, this.clr);
        if (cmd == null) {
            throw new JDOFatalInternalException(LOCALISER.msg("PM.ObjectId.ClassHasNoMetaData", pcClass.getName()));
        }
        if (!this.srm.managesClass(cmd.getFullClassName())) {
            this.srm.addClass(cmd.getFullClassName(), this.getClassLoaderResolver());
        }
        Object id = null;
        if (cmd.usesSingleFieldIdentityClass()) {
            Class idType = this.clr.classForName(cmd.getObjectidClass());
            id = AIDUtils.getNewSingleFieldIdentity(idType, pcClass, key);
        } else if (key instanceof String) {
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                if (Modifier.isAbstract(pcClass.getModifiers()) && cmd.getObjectidClass() != null) {
                    try {
                        Constructor c = this.clr.classForName(cmd.getObjectidClass()).getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManager.class$("java.lang.String")) : class$java$lang$String);
                        id = c.newInstance((String)key);
                    }
                    catch (Exception e) {
                        String msg = LOCALISER.msg("PM.NewObjectIdInstance.ConstructionError", cmd.getObjectidClass(), cmd.getFullClassName());
                        JPOXLogger.JDO.error(msg);
                        JPOXLogger.JDO.error(e);
                        throw new JDOUserException(msg);
                    }
                } else {
                    this.getClassLoaderResolver().classForName(pcClass.getName(), true);
                    id = JDOImplHelper.getInstance().newObjectIdInstance(pcClass, key);
                }
            } else {
                id = new OID((String)key);
            }
        } else {
            throw new JDOUserException(LOCALISER.msg("PM.ObjectId.KeyValueNotSupported", pcClass.getName(), key.getClass().getName()));
        }
        return id;
    }

    public synchronized Object getObjectByAID(Class pcClass, FieldValues fv, boolean ignoreCache, boolean checkInheritance) {
        PersistenceCapable pc;
        Object oid;
        this.assertIsOpen();
        StateManager sm = StateManagerFactory.newStateManager((PersistenceManager)this, pcClass, fv);
        if (!ignoreCache) {
            String[] subclasses;
            oid = sm.getInternalObjectId();
            pc = this.getObjectFromCache(oid);
            if (pc != null) {
                sm = this.findStateManager(pc);
                sm.loadFieldValues(fv);
                return pc;
            }
            if (checkInheritance && (oid instanceof OID || oid instanceof SingleFieldIdentity) && (subclasses = this.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true)) != null) {
                for (int i = 0; i < subclasses.length; ++i) {
                    if (oid instanceof OID) {
                        oid = OIDFactory.getInstance(subclasses[i], ((OID)oid).keyValue());
                    } else if (oid instanceof SingleFieldIdentity) {
                        oid = AIDUtils.getNewSingleFieldIdentity(oid.getClass(), this.clr.classForName(subclasses[i]), ((SingleFieldIdentity)oid).getKeyAsObject());
                    }
                    pc = this.getObjectFromCache(oid);
                    if (pc == null) continue;
                    sm = this.findStateManager(pc);
                    sm.loadFieldValues(fv);
                    return pc;
                }
            }
        }
        if (checkInheritance) {
            sm.checkInheritance(fv);
            if (!ignoreCache && (pc = this.getObjectFromCache(oid = sm.getInternalObjectId())) != null) {
                sm = this.findStateManager(pc);
                sm.loadFieldValues(fv);
                return pc;
            }
        }
        this.putObjectIntoCache(sm, true, true);
        return sm.getObject();
    }

    public synchronized Object getObjectById(Object id, FieldValues fv, Class cls, boolean ignoreCache) {
        this.assertIsOpen();
        PersistenceCapable pc = null;
        if (!ignoreCache) {
            pc = this.getObjectFromCache(id);
        }
        if (pc == null) {
            StateManager sm = StateManagerFactory.newStateManager((PersistenceManager)this, cls, id, fv);
            pc = sm.getObject();
            this.putObjectIntoCache(sm, true, true);
        } else {
            StateManager sm = this.findStateManager(pc);
            if (sm != null) {
                fv.fetchNonLoadedFields(sm);
            }
        }
        return pc;
    }

    public synchronized Object getObjectById(Object id) {
        return this.getObjectById(id, true);
    }

    public synchronized Object getObjectById(Object id, boolean validate) {
        this.assertIsOpen();
        if (id == null) {
            throw new JDOUserException(LOCALISER.msg("PM.GetObjectByIdNullId"));
        }
        return this.getObjectById(id, validate, true, null);
    }

    public synchronized Object getObjectById(Object id, boolean validate, boolean checkInheritance, String objectClassName) {
        this.assertIsOpen();
        if (id == null) {
            throw new JDOUserException(LOCALISER.msg("PM.GetObjectByIdNullId"));
        }
        PersistenceCapable pc = this.getObjectFromCache(id);
        StateManager sm = null;
        if (pc == null) {
            String className = null;
            String originalClassName = null;
            boolean checkedClassName = false;
            if (id instanceof OID) {
                originalClassName = this.srm.manageClassForIdentity((OID)id, this.getClassLoaderResolver());
            } else if (id instanceof SingleFieldIdentity) {
                originalClassName = this.srm.manageClassForIdentity((SingleFieldIdentity)id, this.getClassLoaderResolver());
            } else if (objectClassName != null) {
                originalClassName = objectClassName;
            } else {
                originalClassName = this.srm.getClassNameForObjectID(id, this.clr, this);
                checkedClassName = true;
            }
            if (checkInheritance) {
                className = !checkedClassName ? this.srm.getClassNameForObjectID(id, this.clr, this) : originalClassName;
                if (className == null) {
                    throw new JDOObjectNotFoundException(LOCALISER.msg("PM.ObjectDoesntExist"), id);
                }
                if (originalClassName != null && !originalClassName.equals(className)) {
                    if (id instanceof OID) {
                        id = OIDFactory.getInstance(className, ((OID)id).keyValue());
                        pc = this.getObjectFromCache(id);
                    } else if (id instanceof SingleFieldIdentity) {
                        id = AIDUtils.getNewSingleFieldIdentity(id.getClass(), this.getClassLoaderResolver().classForName(className), ((SingleFieldIdentity)id).getKeyAsObject());
                        pc = this.getObjectFromCache(id);
                    }
                }
            } else {
                className = originalClassName;
            }
            if (pc == null) {
                try {
                    Class pcClass = this.clr.classForName(className, id instanceof OID ? null : id.getClass().getClassLoader());
                    sm = StateManagerFactory.newStateManager((PersistenceManager)this, pcClass, id);
                    pc = sm.getObject();
                }
                catch (ClassNotResolvedException e) {
                    JPOXLogger.JDO.warn(LOCALISER.msg("PM.GetObjectByIdClassNotFound", id));
                    throw new JDOUserException(LOCALISER.msg("PM.GetObjectByIdClassNotFound", id), (Throwable)((Object)e));
                }
            }
        }
        if (validate) {
            if (sm == null) {
                sm = this.findStateManager(pc);
            }
            sm.validate();
        }
        if (sm != null) {
            this.putObjectIntoCache(sm, true, true);
        }
        return pc;
    }

    public Collection getObjectsById(Collection oids, boolean validate) {
        this.assertIsOpen();
        if (oids == null || oids.size() == 0) {
            throw new JDOUserException(LOCALISER.msg("PM.GetObjectsByIdNullId"));
        }
        ArrayList<Object> objects = new ArrayList<Object>(oids.size());
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            Object oid = iter.next();
            objects.add(this.getObjectById(oid, validate));
        }
        return objects;
    }

    public Object[] getObjectsById(Object[] oids, boolean validate) {
        this.assertIsOpen();
        if (oids == null) {
            throw new JDOUserException(LOCALISER.msg("PM.GetObjectsByIdNullId"));
        }
        Object[] objects = new Object[oids.length];
        for (int i = 0; i < oids.length; ++i) {
            objects[i] = this.getObjectById(oids[i], validate);
        }
        return objects;
    }

    public Collection getObjectsById(Collection oids) {
        return this.getObjectsById(oids, true);
    }

    public Object[] getObjectsById(Object[] oids) {
        return this.getObjectsById(oids, true);
    }

    public Object getObjectById(Class cls, Object key) {
        return this.getObjectById(this.newObjectIdInstance(cls, key), true);
    }

    public synchronized Object getObjectById(Object id, FieldValues fv) {
        this.assertIsOpen();
        PersistenceCapable pc = this.getObjectFromCache(id);
        if (pc == null) {
            String className = this.srm.getClassNameForObjectID(id, this.clr, this);
            if (className == null) {
                throw new JDOObjectNotFoundException(LOCALISER.msg("PM.ObjectDoesntExist"), id);
            }
            if (id instanceof OID) {
                id = OIDFactory.getInstance(className, ((OID)id).keyValue());
                pc = this.getObjectFromCache(id);
            }
            if (pc == null) {
                try {
                    Class pcClass = this.clr.classForName(className, id.getClass().getClassLoader());
                    StateManager sm = StateManagerFactory.newStateManager((PersistenceManager)this, pcClass, id, fv);
                    pc = sm.getObject();
                    this.putObjectIntoCache(sm, true, true);
                }
                catch (ClassNotResolvedException e) {
                    JPOXLogger.JDO.warn(LOCALISER.msg("PM.GetObjectByIdClassNotFound", id));
                    throw new JDOUserException(LOCALISER.msg("PM.GetObjectByIdClassNotFound", id), (Throwable)((Object)e));
                }
            }
        }
        return pc;
    }

    public Object getObjectId(Object pc) {
        PersistenceCapable p;
        this.assertIsOpen();
        if (pc != null && pc instanceof PersistenceCapable && ((p = (PersistenceCapable)pc).jdoIsPersistent() || p.jdoIsDetached())) {
            return p.jdoGetObjectId();
        }
        return null;
    }

    public Object getTransactionalObjectId(Object pc) {
        this.assertIsOpen();
        return ((PersistenceCapable)pc).jdoGetTransactionalObjectId();
    }

    public synchronized Object putUserObject(Object key, Object value) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            this.userObjectMap = new HashMap();
        }
        if (value == null) {
            return this.userObjectMap.remove(key);
        }
        return this.userObjectMap.put(key, value);
    }

    public synchronized Object getUserObject(Object key) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            return null;
        }
        return this.userObjectMap.get(key);
    }

    public synchronized Object removeUserObject(Object key) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            return null;
        }
        return this.userObjectMap.remove(key);
    }

    public synchronized void setUserObject(Object userObject) {
        this.assertIsOpen();
        this.userObject = userObject;
    }

    public synchronized Object getUserObject() {
        this.assertIsOpen();
        return this.userObject;
    }

    public Class getObjectIdClass(Class cls) {
        this.assertIsOpen();
        if (!ClassUtils.isPersistenceCapableClass(cls) || !this.hasMetaDataForPersistenceCapableClass(cls)) {
            return null;
        }
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(cls, this.clr);
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return class$org$jpox$store$OID == null ? (class$org$jpox$store$OID = AbstractPersistenceManager.class$("org.jpox.store.OID")) : class$org$jpox$store$OID;
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                return this.getClassLoaderResolver().classForName(this.getMetaDataManager().getMetaDataForClass(cls, this.clr).getObjectidClass(), null);
            }
            catch (ClassNotResolvedException e) {
                String msg = LOCALISER.msg("PM.ObjectIdClassNotFound", cls.getName());
                JPOXLogger.GENERAL.error(msg);
                throw new JDOException(msg);
            }
        }
        if (cmd.isRequiresExtent()) {
            return class$org$jpox$store$OID == null ? (class$org$jpox$store$OID = AbstractPersistenceManager.class$("org.jpox.store.OID")) : class$org$jpox$store$OID;
        }
        return class$org$jpox$store$SCOID == null ? (class$org$jpox$store$SCOID = AbstractPersistenceManager.class$("org.jpox.store.SCOID")) : class$org$jpox$store$SCOID;
    }

    public void setMultithreaded(boolean flag) {
        this.assertIsOpen();
        this.multithreaded = flag;
    }

    public boolean getMultithreaded() {
        this.assertIsOpen();
        return this.multithreaded;
    }

    public void setIgnoreCache(boolean flag) {
        this.assertIsOpen();
        this.ignoreCache = flag;
    }

    public boolean getIgnoreCache() {
        this.assertIsOpen();
        return this.ignoreCache;
    }

    public void setDetachOnClose(boolean flag) {
        this.assertIsOpen();
        this.detachOnClose = flag;
    }

    public boolean getDetachOnClose() {
        this.assertIsOpen();
        return this.detachOnClose;
    }

    public void setDetachAllOnCommit(boolean flag) {
        this.assertIsOpen();
        this.detachAllOnCommit = flag;
    }

    public boolean getDetachAllOnCommit() {
        this.assertIsOpen();
        return this.detachAllOnCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StateManager findStateManager(PersistenceCapable pc) {
        StateManager sm = null;
        PersistenceCapable previousLookingFor = this.lookingForStateManagerFor;
        StateManager previousFound = this.foundStateManager;
        try {
            this.lookingForStateManagerFor = pc;
            this.foundStateManager = null;
            PersistenceManager pm = (PersistenceManager)pc.jdoGetPersistenceManager();
            if (pm != null && this.getPMHandle() != pm.getPMHandle()) {
                throw new JDOUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
            }
            sm = this.foundStateManager;
        }
        finally {
            this.lookingForStateManagerFor = previousLookingFor;
            this.foundStateManager = previousFound;
        }
        return sm;
    }

    public synchronized void hereIsStateManager(StateManager sm, PersistenceCapable pc) {
        if (this.lookingForStateManagerFor == pc) {
            this.foundStateManager = sm;
        }
    }

    public synchronized void clearDirty(StateManager sm) {
        this.dirtySMs.remove(sm);
    }

    public synchronized void markDirty(StateManager sm) {
        if (!this.isDelayDatastoreOperationsEnabled() && this.dirtySMs.size() > 0 && !this.dirtySMs.contains(sm)) {
            this.flush();
        }
        if (!this.dirtySMs.contains(sm)) {
            this.dirtySMs.add(sm);
        }
    }

    public synchronized void clearDirty() {
        this.dirtySMs.clear();
    }

    public synchronized void flush() {
        this.assertIsOpen();
        if (this.tx.isActive()) {
            ArrayList<JDOOptimisticVerificationException> optimisticFailures = new ArrayList<JDOOptimisticVerificationException>();
            ArrayList toFlush = new ArrayList(this.dirtySMs);
            this.clearDirty();
            for (int i = 0; i < toFlush.size(); ++i) {
                StateManager sm = (StateManager)toFlush.get(i);
                try {
                    sm.flush();
                    continue;
                }
                catch (JDOOptimisticVerificationException ove) {
                    optimisticFailures.add(ove);
                }
            }
            toFlush.clear();
            if (optimisticFailures.size() > 0) {
                throw new JDOOptimisticVerificationException(LOCALISER.msg("PM.OptimisticVerificationError"), optimisticFailures.toArray(new Throwable[optimisticFailures.size()]));
            }
        }
    }

    public void checkConsistency() {
        this.assertIsOpen();
        if (!this.tx.isActive()) {
            return;
        }
        if (this.tx.getOptimistic()) {
            throw new JDOUserException("checkConsistency() not yet implemented for optimistic transactions");
        }
        this.flush();
    }

    public void detachAll() {
        Object[] sms = this.enlistedSMCache.values().toArray();
        FetchPlanState fps = new FetchPlanState();
        for (int i = 0; i < sms.length; ++i) {
            ((StateManager)sms[i]).detach(fps);
        }
    }

    public synchronized void preCommit() {
        this.notifyQueriesOfConnectionClose();
        this.flush();
        try {
            if (this.apmf.getPersistenceByReachabilityAtCommit()) {
                this.runningPBRAtCommit = true;
                if (JPOXLogger.JDO_REACHABILITY.isDebugEnabled()) {
                    JPOXLogger.JDO_REACHABILITY.debug(LOCALISER.msg("PM.PersistenceByReachability.RunningCommitCheck"));
                }
                if (this.txKnownPersists.size() > 0 && this.txFlushedNew.size() > 0) {
                    StateManager sm;
                    int i;
                    HashSet currentReachables = new HashSet();
                    Object[] ids = this.txKnownPersists.toArray();
                    HashSet<Object> objectNotFound = new HashSet<Object>();
                    for (int i2 = 0; i2 < ids.length; ++i2) {
                        if (JPOXLogger.JDO_REACHABILITY.isDebugEnabled()) {
                            JPOXLogger.JDO_REACHABILITY.debug("Performing reachability algorithm on object with id \"" + ids[i2] + "\"");
                        }
                        try {
                            StateManager sm2 = this.findStateManager((PersistenceCapable)this.getObjectById(ids[i2]));
                            sm2.runReachability(currentReachables);
                            if (i2 % 10000 != 0 && i2 != ids.length - 1) continue;
                            this.flush();
                            continue;
                        }
                        catch (JDOObjectNotFoundException ex) {
                            objectNotFound.add(ids[i2]);
                        }
                    }
                    this.txFlushedNew.removeAll(currentReachables);
                    Object[] nonReachableIds = this.txFlushedNew.toArray();
                    for (i = 0; i < nonReachableIds.length; ++i) {
                        if (JPOXLogger.JDO_REACHABILITY.isDebugEnabled()) {
                            JPOXLogger.JDO_REACHABILITY.debug(LOCALISER.msg("PM.PersistenceByReachability.ObjectNoLongerReachable", nonReachableIds[i]));
                        }
                        try {
                            if (objectNotFound.contains(nonReachableIds[i])) continue;
                            sm = this.findStateManager((PersistenceCapable)this.getObjectById(nonReachableIds[i]));
                            sm.nullifyFields();
                            if (i % 10000 != 0 && i != nonReachableIds.length - 1) continue;
                            this.flush();
                            continue;
                        }
                        catch (JDOObjectNotFoundException ex) {
                            // empty catch block
                        }
                    }
                    for (i = 0; i < nonReachableIds.length; ++i) {
                        try {
                            if (objectNotFound.contains(nonReachableIds[i])) continue;
                            sm = this.findStateManager((PersistenceCapable)this.getObjectById(nonReachableIds[i]));
                            sm.deletePersistent();
                            if (i % 10000 != 0 && i != nonReachableIds.length - 1) continue;
                            this.flush();
                            continue;
                        }
                        catch (JDOObjectNotFoundException ex) {
                            // empty catch block
                        }
                    }
                }
                if (JPOXLogger.JDO_REACHABILITY.isDebugEnabled()) {
                    JPOXLogger.JDO_REACHABILITY.debug(LOCALISER.msg("PM.PersistenceByReachability.CompletedCommitCheck"));
                }
            }
        }
        catch (Throwable t) {
            JPOXLogger.JDO.error(t);
            if (t instanceof JDOException) {
                throw (JDOException)t;
            }
            throw new JDOException("Unexpected error during precommit", t);
        }
        finally {
            this.runningPBRAtCommit = false;
        }
        this.flush();
        if (this.detachAllOnCommit) {
            this.smsToDetachAtCommit = this.getRootStateManagersForDetachAllOnCommit();
            for (int i = 0; i < this.smsToDetachAtCommit.length; ++i) {
                PersistenceCapable pc = this.smsToDetachAtCommit[i].getObject();
                if (pc == null || pc.jdoIsDetached() || pc.jdoIsDeleted()) continue;
                FetchPlanState state = new FetchPlanState();
                this.smsToDetachAtCommit[i].loadFieldsInFetchPlan(state);
            }
        }
    }

    private StateManager[] getRootStateManagersForDetachAllOnCommit() {
        StateManager[] sms = null;
        Collection roots = this.fetchPlan.getDetachmentRoots();
        Class[] rootClasses = this.fetchPlan.getDetachmentRootClasses();
        if (roots != null && roots.size() > 0) {
            sms = new StateManager[roots.size()];
            Iterator rootsIter = roots.iterator();
            int i = 0;
            while (rootsIter.hasNext()) {
                Object obj = rootsIter.next();
                sms[i++] = this.findStateManager((PersistenceCapable)obj);
            }
        } else if (rootClasses != null && rootClasses.length > 0) {
            ArrayList<StateManager> smList = new ArrayList<StateManager>();
            StateManager[] txSMs = this.enlistedSMCache.values().toArray(new StateManager[this.enlistedSMCache.size()]);
            block1: for (int i = 0; i < txSMs.length; ++i) {
                for (int j = 0; j < rootClasses.length; ++j) {
                    if (txSMs[i].getObject().getClass() != rootClasses[j]) continue;
                    smList.add(txSMs[i]);
                    continue block1;
                }
            }
            sms = smList.toArray(new StateManager[smList.size()]);
        } else {
            sms = this.cache.values().toArray(new StateManager[this.cache.values().size()]);
        }
        return sms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void postCommit() {
        int i;
        ArrayList<StateManager> smsToMakeTransient = null;
        if (this.detachAllOnCommit) {
            StateManager[] smsToDetach = this.smsToDetachAtCommit;
            DetachState state = new DetachState();
            for (i = 0; i < smsToDetach.length; ++i) {
                PersistenceCapable pc = smsToDetach[i].getObject();
                if (pc == null || pc.jdoIsDetached() || pc.jdoIsDeleted()) continue;
                if (pc instanceof Detachable) {
                    smsToDetach[i].detach(state);
                    continue;
                }
                if (smsToMakeTransient == null) {
                    smsToMakeTransient = new ArrayList<StateManager>();
                }
                smsToMakeTransient.add(smsToDetach[i]);
            }
            this.smsToDetachAtCommit = null;
        }
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        try {
            StateManager[] sms = this.enlistedSMCache.values().toArray(new StateManager[this.enlistedSMCache.size()]);
            for (i = 0; i < sms.length; ++i) {
                try {
                    if (sms[i] == null || sms[i].getObject() == null || !sms[i].getObject().jdoIsPersistent() && !sms[i].getObject().jdoIsTransactional()) continue;
                    sms[i].postCommit(this.currentTransaction());
                    if (!this.detachAllOnCommit || !(sms[i].getObject() instanceof Detachable)) continue;
                    this.removeStateManager(sms[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    failures.add(e);
                }
            }
            if (this.detachAllOnCommit && smsToMakeTransient != null) {
                Iterator makeTransientIter = smsToMakeTransient.iterator();
                while (makeTransientIter.hasNext()) {
                    ((StateManager)makeTransientIter.next()).makeTransient(null);
                }
            }
        }
        finally {
            this.enlistedSMCache.clear();
            this.enlistedIds.clear();
            this.txKnownPersists.clear();
            this.txFlushedNew.clear();
            ((FetchPlanImpl)this.fetchPlan).resetDetachmentRoots();
        }
        if (!failures.isEmpty()) {
            throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
        }
    }

    private void notifyQueriesOfConnectionClose() {
        Iterator queryResultIter = this.queryResults.values().iterator();
        while (queryResultIter.hasNext()) {
            QueryResult queryResult = (QueryResult)queryResultIter.next();
            queryResult.closingConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void preRollback() {
        this.notifyQueriesOfConnectionClose();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        try {
            Collection sms = this.enlistedSMCache.values();
            Iterator smsIter = sms.iterator();
            while (smsIter.hasNext()) {
                StateManager sm = (StateManager)smsIter.next();
                try {
                    sm.preRollback(this.currentTransaction());
                }
                catch (RuntimeException e) {
                    failures.add(e);
                }
            }
            this.clearDirty();
        }
        finally {
            this.enlistedSMCache.clear();
            this.enlistedIds.clear();
            this.txKnownPersists.clear();
            this.txFlushedNew.clear();
        }
        if (!failures.isEmpty()) {
            throw new RollbackStateTransitionException(failures.toArray(new Exception[failures.size()]));
        }
    }

    public void dump(Object obj, PrintWriter out) {
        this.findStateManager((PersistenceCapable)obj).dump(out);
    }

    public Sequence getSequence(String sequenceName) {
        this.assertIsOpen();
        SequenceMetaData seqmd = this.getMetaDataManager().getMetaDataForSequence(this.getClassLoaderResolver(), sequenceName);
        if (seqmd == null) {
            throw new JDOUserException(LOCALISER.msg("Sequence.SequenceNotFound", sequenceName));
        }
        Sequence seq = null;
        if (seqmd.getFactoryClass() != null) {
            seq = this.apmf.getSequenceForFactoryClass(seqmd.getFactoryClass());
            if (seq == null) {
                Class factory = this.clr.classForName(seqmd.getFactoryClass());
                if (factory == null) {
                    throw new JDOUserException(LOCALISER.msg("Sequence.FactoryClassNotFound", sequenceName, seqmd.getFactoryClass()));
                }
                Class[] argTypes = null;
                Object[] arguments = null;
                if (seqmd.getStrategy() != null) {
                    argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManager.class$("java.lang.String")) : class$java$lang$String};
                    arguments = new Object[]{seqmd.getName(), seqmd.getStrategy().toString()};
                } else {
                    argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManager.class$("java.lang.String")) : class$java$lang$String};
                    arguments = new Object[]{seqmd.getName()};
                }
                try {
                    Method newInstanceMethod = factory.getMethod("newInstance", argTypes);
                    seq = (Sequence)newInstanceMethod.invoke(null, arguments);
                }
                catch (Exception e) {
                    throw new JDOUserException(LOCALISER.msg("Sequence.FactoryClassInvocationError", seqmd.getFactoryClass(), e.getMessage()));
                }
                this.apmf.addSequenceForFactoryClass(seqmd.getFactoryClass(), seq);
            }
        } else {
            seq = this.srm.getSequence(this, seqmd);
        }
        return seq;
    }

    public synchronized void replaceObjectId(PersistenceCapable pc, Object oldID, Object newID) {
        Object o;
        if (pc == null || pc.jdoGetObjectId() == null) {
            JPOXLogger.CACHE.warn(LOCALISER.msg("Cache.Level1.AddingNullObjectError"));
            return;
        }
        if (JPOXLogger.CACHE.isDebugEnabled()) {
            JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.AddingObject", newID));
        }
        if ((o = this.cache.get(oldID)) != null) {
            this.cache.remove(oldID);
            this.cache.put(newID, o);
        }
        if (this.apmf.getJdoCacheLevel2()) {
            StateManager sm = this.findStateManager(pc);
            this.putObjectIntoCache(sm, false, true);
        }
        if (this.apmf.getPersistenceByReachabilityAtCommit()) {
            if (this.txFlushedNew.remove(oldID)) {
                this.txFlushedNew.add(newID);
            }
            if (this.txKnownPersists.remove(oldID)) {
                this.txKnownPersists.add(newID);
            }
        }
    }

    public synchronized void putObjectIntoCache(StateManager sm, boolean level1, boolean level2) {
        if (sm.getObject() == null) {
            JPOXLogger.CACHE.warn(LOCALISER.msg("Cache.Level1.AddingNullObjectError"));
            return;
        }
        Object id = sm.getObject().jdoGetObjectId();
        if (id == null) {
            JPOXLogger.CACHE.warn(LOCALISER.msg("Cache.Level1.AddingNullObjectError"));
            return;
        }
        if (level1) {
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.AddingObject", sm.getInternalObjectId()));
            }
            this.cache.put(sm.getInternalObjectId(), sm);
        }
        if (level2 && this.apmf.getJdoCacheLevel2()) {
            boolean storeInL2Cache = true;
            AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(sm.getObject().getClass(), this.clr);
            if (acmd != null && acmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFieldNumbers = acmd.getPrimaryKeyFieldNumbers();
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractPropertyMetaData fmd;
                    if (!(class$javax$jdo$spi$PersistenceCapable == null ? AbstractPersistenceManager.class$("javax.jdo.spi.PersistenceCapable") : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom((fmd = acmd.getManagedFieldAbsolute(pkFieldNumbers[i])).getType())) continue;
                    storeInL2Cache = false;
                }
            }
            if (storeInL2Cache) {
                if (JPOXLogger.CACHE.isDebugEnabled()) {
                    JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level2.AddingObject", id));
                }
                CachedPC pcCopy = sm.getL2CacheableObject();
                ((Level2Cache)this.apmf.getDataStoreCache()).put(id, pcCopy);
            }
        }
    }

    public synchronized void removeObjectFromCache(PersistenceCapable pc, Object id, boolean level1, boolean level2) {
        if (level1 && id != null) {
            Object pcRemoved;
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.RemovingObject", id, String.valueOf(this.cache.size())));
            }
            if ((pcRemoved = this.cache.remove(id)) == null && JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.RemovalOfObjectFailed", id));
            }
        }
        if (level2 && this.apmf.getJdoCacheLevel2() && pc.jdoGetObjectId() != null) {
            Level2Cache l2Cache = (Level2Cache)this.apmf.getDataStoreCache();
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level2.RemovingObject", pc.jdoGetObjectId(), String.valueOf(l2Cache.getSize())));
            }
            l2Cache.evict(pc.jdoGetObjectId());
        }
    }

    public synchronized PersistenceCapable getObjectFromCache(Object id) {
        PersistenceCapable pc = null;
        StateManager sm = (StateManager)this.cache.get(id);
        if (sm != null) {
            pc = sm.getObject();
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.RetrievalOfObject", id, "" + this.cache.size()));
            }
            sm.resetDetachState();
            return pc;
        }
        if (JPOXLogger.CACHE.isDebugEnabled()) {
            JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.RetrievalFailed", id, "" + this.cache.size()));
        }
        if (this.apmf.getJdoCacheLevel2()) {
            Level2Cache l2Cache = (Level2Cache)this.apmf.getDataStoreCache();
            CachedPC cachedPC = l2Cache.get(id);
            if (cachedPC != null) {
                sm = StateManagerFactory.newStateManager((PersistenceManager)this, id, cachedPC.getPersistenceCapable(), cachedPC.getLoadedFields());
                pc = sm.getObject();
                if (JPOXLogger.CACHE.isDebugEnabled()) {
                    JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level2.RetrievalOfObject", id, "" + l2Cache.getSize()));
                }
                return pc;
            }
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level2.RetrievalFailed", id, "" + l2Cache.getSize()));
            }
        }
        return null;
    }

    public void removeAllInstanceLifecycleListeners() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    public void addInstanceLifecycleListener(InstanceLifecycleListener listener, Class[] classes) {
        this.assertIsOpen();
        if (listener == null) {
            return;
        }
        this.getCallbackHandler().addListener(listener, classes);
    }

    public CallbackHandler getCallbackHandler() {
        if (this.callbacks != null) {
            return this.callbacks;
        }
        String callbackHandlerClassName = this.getPMFContext().getPluginManager().getAttributeValueForExtension("org.jpox.callbackhandler", "name", this.getPMFContext().getApi(), "class-name");
        if (callbackHandlerClassName != null) {
            try {
                this.callbacks = (CallbackHandler)this.clr.classForName(callbackHandlerClassName).newInstance();
                return this.callbacks;
            }
            catch (InstantiationException e) {
                JPOXLogger.RDBMS.error(LOCALISER.msg("CallbackHandler.InstantiationError", callbackHandlerClassName, e));
            }
            catch (IllegalAccessException e) {
                JPOXLogger.RDBMS.error(LOCALISER.msg("CallbackHandler.InstantiationError", callbackHandlerClassName, e));
            }
        }
        return null;
    }

    public void removeInstanceLifecycleListener(InstanceLifecycleListener listener) {
        this.assertIsOpen();
        if (listener != null) {
            this.getCallbackHandler().removeListener(listener);
        }
    }

    public int addQueryResult(QueryResult queryResult) {
        int resultsNumber = this.queryResultNumber++;
        this.queryResults.put(new Integer(resultsNumber), queryResult);
        return resultsNumber;
    }

    public void removeQueryResult(int resultsNumber) {
        this.queryResults.remove(new Integer(resultsNumber));
    }

    public void addQueryRun(String singleStringQuery) {
        this.queriesRun.put(singleStringQuery, singleStringQuery);
    }

    public boolean hasQueryRun(String singleStringQuery) {
        return this.queriesRun.get(singleStringQuery) != null;
    }

    public void removeQueryRun(String singleStringQuery) {
        this.queriesRun.remove(singleStringQuery);
    }

    private void assertIsOpen() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(LOCALISER.msg("PM.IsClosed"));
        }
    }

    private boolean hasMetaDataForPersistenceCapableClass(Class cls) {
        boolean hasMetaData;
        boolean bl = hasMetaData = cls != null && this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null;
        if (!hasMetaData && cls != null && cls.isInterface()) {
            try {
                this.newInstance(cls);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            hasMetaData = this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null;
        }
        return hasMetaData;
    }

    private void assertPersistenceCapableClass(Class cls) {
        if (!ClassUtils.isPersistenceCapableClass(cls) && !cls.isInterface()) {
            throw new ClassNotPersistenceCapableException(cls.getName());
        }
        if (!this.hasMetaDataForPersistenceCapableClass(cls)) {
            throw new MetaDataForPersistenceCapableClassNotReachableException(cls.getName());
        }
    }

    private void assertPersistenceCapable(Object object) {
        if (!ClassUtils.isPersistenceCapable(object)) {
            throw new ClassNotPersistenceCapableException(object.getClass().getName());
        }
        if (!this.hasMetaDataForPersistenceCapableClass(object.getClass())) {
            throw new MetaDataForPersistenceCapableClassNotReachableException(object.getClass().getName());
        }
    }

    private void assertDetachable(Object object) {
        if (!ClassUtils.isDetachable(object)) {
            throw new ClassNotDetachableException(object.getClass().getName());
        }
    }

    private void assertNotDetached(Object object) {
        if (JDOHelper.isDetached((Object)object)) {
            throw new ObjectDetachedException(object.getClass().getName());
        }
    }

    private void assertActiveTransaction() {
        if (!this.tx.isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    private void assertActiveTransactionOrNontransactionRead(String operation) {
        if (!this.tx.isActive() && !this.tx.getNontransactionalRead()) {
            throw new JDOUserException(LOCALISER.msg("PM.NonTransactionalOperationInvalid", operation));
        }
    }

    public void unloadField(PersistenceCapable pc, String fieldName) {
        this.findStateManager(pc).unloadField(fieldName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

