/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.jcr;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.archiva.metadata.model.MetadataFacetFactory;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataResolver;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.metadata.repository.RepositorySessionFactoryBean;
import org.apache.archiva.metadata.repository.jcr.JcrMetadataRepository;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="repositorySessionFactory#jcr")
public class JcrRepositorySessionFactory
implements RepositorySessionFactory {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ApplicationContext applicationContext;
    private Map<String, MetadataFacetFactory> metadataFacetFactories;
    @Inject
    private Repository repository;
    @Inject
    private MetadataResolver metadataResolver;
    @Inject
    private RepositorySessionFactoryBean repositorySessionFactoryBean;

    public RepositorySession createSession() {
        try {
            JcrMetadataRepository metadataRepository = new JcrMetadataRepository(this.metadataFacetFactories, this.repository);
            return new RepositorySession((MetadataRepository)metadataRepository, this.metadataResolver);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @PostConstruct
    public void initialize() throws Exception {
        if (!StringUtils.equals((String)this.repositorySessionFactoryBean.getId(), (String)"jcr")) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.metadataFacetFactories = this.applicationContext.getBeansOfType(MetadataFacetFactory.class);
        HashMap<String, MetadataFacetFactory> cleanedMetadataFacetFactories = new HashMap<String, MetadataFacetFactory>(this.metadataFacetFactories.size());
        for (Map.Entry<String, MetadataFacetFactory> entry : this.metadataFacetFactories.entrySet()) {
            cleanedMetadataFacetFactories.put(StringUtils.substringAfterLast((String)entry.getKey(), (String)"#"), entry.getValue());
        }
        this.metadataFacetFactories = cleanedMetadataFacetFactories;
        try (JcrMetadataRepository metadataRepository = null;){
            metadataRepository = new JcrMetadataRepository(this.metadataFacetFactories, this.repository);
            JcrMetadataRepository.initialize(metadataRepository.getJcrSession());
        }
        stopWatch.stop();
        this.logger.info("time to initialize JcrRepositorySessionFactory: {}", (Object)stopWatch.getTime());
    }
}

