/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.core.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.archiva.common.utils.VersionComparator;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.consumers.core.repository.AbstractRepositoryPurge;
import org.apache.archiva.consumers.core.repository.RepositoryPurgeException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.VersionedReference;
import org.apache.archiva.repository.ContentNotFoundException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.events.RepositoryListener;
import org.apache.archiva.repository.layout.LayoutException;

public class RetentionCountRepositoryPurge
extends AbstractRepositoryPurge {
    private int retentionCount;

    public RetentionCountRepositoryPurge(ManagedRepositoryContent repository, int retentionCount, RepositorySession repositorySession, List<RepositoryListener> listeners) {
        super(repository, repositorySession, listeners);
        this.retentionCount = retentionCount;
    }

    @Override
    public void process(String path) throws RepositoryPurgeException {
        try {
            File artifactFile = new File(this.repository.getRepoRoot(), path);
            if (!artifactFile.exists()) {
                return;
            }
            ArtifactReference artifact = this.repository.toArtifactReference(path);
            if (VersionUtil.isSnapshot((String)artifact.getVersion())) {
                VersionedReference reference = new VersionedReference();
                reference.setGroupId(artifact.getGroupId());
                reference.setArtifactId(artifact.getArtifactId());
                reference.setVersion(artifact.getVersion());
                ArrayList versions = new ArrayList(this.repository.getVersions(reference));
                Collections.sort(versions, VersionComparator.getInstance());
                if (this.retentionCount > versions.size()) {
                    this.log.trace("No deletion, because retention count is higher than actual number of artifacts.");
                    return;
                }
                int countToPurge = versions.size() - this.retentionCount;
                HashSet<ArtifactReference> artifactsToDelete = new HashSet<ArtifactReference>();
                for (String version : versions) {
                    if (countToPurge-- <= 0) break;
                    artifactsToDelete.addAll(this.repository.getRelatedArtifacts(this.getNewArtifactReference(artifact, version)));
                }
                this.purge(artifactsToDelete);
            }
        }
        catch (LayoutException le) {
            throw new RepositoryPurgeException(le.getMessage(), le);
        }
        catch (ContentNotFoundException e) {
            this.log.error("Repostory artifact not found {}", (Object)path);
        }
    }

    private ArtifactReference getNewArtifactReference(ArtifactReference reference, String version) throws LayoutException {
        ArtifactReference artifact = new ArtifactReference();
        artifact.setGroupId(reference.getGroupId());
        artifact.setArtifactId(reference.getArtifactId());
        artifact.setVersion(version);
        artifact.setClassifier(reference.getClassifier());
        artifact.setType(reference.getType());
        return artifact;
    }
}

