/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.core.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationNames;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.archiva.consumers.core.repository.CleanupReleasedSnapshotsRepositoryPurge;
import org.apache.archiva.consumers.core.repository.DaysOldRepositoryPurge;
import org.apache.archiva.consumers.core.repository.RepositoryPurge;
import org.apache.archiva.consumers.core.repository.RepositoryPurgeException;
import org.apache.archiva.consumers.core.repository.RetentionCountRepositoryPurge;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RepositoryContentFactory;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.RepositoryNotFoundException;
import org.apache.archiva.repository.events.RepositoryListener;
import org.apache.archiva.repository.metadata.MetadataTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="knownRepositoryContentConsumer#repository-purge")
@Scope(value="prototype")
public class RepositoryPurgeConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer,
RegistryListener {
    private String id = "repository-purge";
    private String description = "Purge repository of old snapshots";
    @Inject
    @Named(value="archivaConfiguration#default")
    private ArchivaConfiguration configuration;
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    @Named(value="repositoryContentFactory#default")
    private RepositoryContentFactory repositoryContentFactory;
    @Inject
    private MetadataTools metadataTools;
    @Inject
    @Named(value="fileTypes")
    private FileTypes filetypes;
    private List<String> includes = new ArrayList<String>();
    private RepositoryPurge repoPurge;
    private RepositoryPurge cleanUp;
    private boolean deleteReleasedSnapshots;
    @Inject
    @Autowired(required=false)
    private List<RepositoryListener> listeners = Collections.emptyList();
    @Inject
    private RepositorySessionFactory repositorySessionFactory;
    private RepositorySession repositorySession;

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getExcludes() {
        return this.getDefaultArtifactExclusions();
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void beginScan(ManagedRepository repository, Date whenGathered) throws ConsumerException {
        ManagedRepositoryContent repositoryContent;
        try {
            repositoryContent = this.repositoryContentFactory.getManagedRepositoryContent(repository.getId());
        }
        catch (RepositoryNotFoundException e) {
            throw new ConsumerException("Can't run repository purge: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ConsumerException("Can't run repository purge: " + e.getMessage(), (Throwable)e);
        }
        this.repositorySession = this.repositorySessionFactory.createSession();
        this.repoPurge = repository.getDaysOlder() != 0 ? new DaysOldRepositoryPurge(repositoryContent, repository.getDaysOlder(), repository.getRetentionCount(), this.repositorySession, this.listeners) : new RetentionCountRepositoryPurge(repositoryContent, repository.getRetentionCount(), this.repositorySession, this.listeners);
        this.cleanUp = new CleanupReleasedSnapshotsRepositoryPurge(repositoryContent, this.metadataTools, this.managedRepositoryAdmin, this.repositoryContentFactory, this.repositorySession, this.listeners);
        this.deleteReleasedSnapshots = repository.isDeleteReleasedSnapshots();
    }

    public void beginScan(ManagedRepository repository, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        this.beginScan(repository, whenGathered);
    }

    public void processFile(String path) throws ConsumerException {
        try {
            if (this.deleteReleasedSnapshots) {
                this.cleanUp.process(path);
            }
            this.repoPurge.process(path);
        }
        catch (RepositoryPurgeException rpe) {
            throw new ConsumerException(rpe.getMessage(), (Throwable)rpe);
        }
    }

    public void processFile(String path, boolean executeOnEntireRepo) throws Exception {
        this.processFile(path);
    }

    public void completeScan() {
        this.repositorySession.close();
    }

    public void completeScan(boolean executeOnEntireRepo) {
        this.completeScan();
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isRepositoryScanning((String)propertyName)) {
            this.initIncludes();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    private void initIncludes() {
        this.includes = new ArrayList<String>(this.filetypes.getFileTypePatterns("artifacts"));
    }

    @PostConstruct
    public void initialize() {
        this.configuration.addChangeListener((RegistryListener)this);
        this.initIncludes();
    }

    public boolean isProcessUnmodified() {
        return true;
    }

    public ArchivaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ArchivaConfiguration configuration) {
        this.configuration = configuration;
    }

    public RepositoryContentFactory getRepositoryContentFactory() {
        return this.repositoryContentFactory;
    }

    public void setRepositoryContentFactory(RepositoryContentFactory repositoryContentFactory) {
        this.repositoryContentFactory = repositoryContentFactory;
    }

    public MetadataTools getMetadataTools() {
        return this.metadataTools;
    }

    public void setMetadataTools(MetadataTools metadataTools) {
        this.metadataTools = metadataTools;
    }

    public FileTypes getFiletypes() {
        return this.filetypes;
    }

    public void setFiletypes(FileTypes filetypes) {
        this.filetypes = filetypes;
    }

    public RepositoryPurge getRepoPurge() {
        return this.repoPurge;
    }

    public void setRepoPurge(RepositoryPurge repoPurge) {
        this.repoPurge = repoPurge;
    }

    public RepositoryPurge getCleanUp() {
        return this.cleanUp;
    }

    public void setCleanUp(RepositoryPurge cleanUp) {
        this.cleanUp = cleanUp;
    }

    public boolean isDeleteReleasedSnapshots() {
        return this.deleteReleasedSnapshots;
    }

    public void setDeleteReleasedSnapshots(boolean deleteReleasedSnapshots) {
        this.deleteReleasedSnapshots = deleteReleasedSnapshots;
    }

    public RepositorySessionFactory getRepositorySessionFactory() {
        return this.repositorySessionFactory;
    }

    public void setRepositorySessionFactory(RepositorySessionFactory repositorySessionFactory) {
        this.repositorySessionFactory = repositorySessionFactory;
    }

    public RepositorySession getRepositorySession() {
        return this.repositorySession;
    }

    public void setRepositorySession(RepositorySession repositorySession) {
        this.repositorySession = repositorySession;
    }
}

