/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.core.repository;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.archiva.common.utils.VersionComparator;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.consumers.core.repository.AbstractRepositoryPurge;
import org.apache.archiva.consumers.core.repository.RepositoryPurgeException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.VersionedReference;
import org.apache.archiva.repository.ContentNotFoundException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.events.RepositoryListener;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.commons.lang.time.DateUtils;

public class DaysOldRepositoryPurge
extends AbstractRepositoryPurge {
    private SimpleDateFormat timestampParser;
    private int daysOlder;
    private int retentionCount;

    public DaysOldRepositoryPurge(ManagedRepositoryContent repository, int daysOlder, int retentionCount, RepositorySession repositorySession, List<RepositoryListener> listeners) {
        super(repository, repositorySession, listeners);
        this.daysOlder = daysOlder;
        this.retentionCount = retentionCount;
        this.timestampParser = new SimpleDateFormat("yyyyMMdd.HHmmss");
        this.timestampParser.setTimeZone(DateUtils.UTC_TIME_ZONE);
    }

    @Override
    public void process(String path) throws RepositoryPurgeException {
        try {
            File artifactFile = new File(this.repository.getRepoRoot(), path);
            if (!artifactFile.exists()) {
                return;
            }
            ArtifactReference artifact = this.repository.toArtifactReference(path);
            Calendar olderThanThisDate = Calendar.getInstance(DateUtils.UTC_TIME_ZONE);
            olderThanThisDate.add(5, -this.daysOlder);
            VersionedReference reference = new VersionedReference();
            reference.setGroupId(artifact.getGroupId());
            reference.setArtifactId(artifact.getArtifactId());
            reference.setVersion(artifact.getVersion());
            ArrayList versions = new ArrayList(this.repository.getVersions(reference));
            Collections.sort(versions, VersionComparator.getInstance());
            if (this.retentionCount > versions.size()) {
                return;
            }
            int countToPurge = versions.size() - this.retentionCount;
            HashSet<ArtifactReference> artifactsToDelete = new HashSet<ArtifactReference>();
            for (String version : versions) {
                Calendar timestampCal;
                if (countToPurge-- <= 0) break;
                ArtifactReference newArtifactReference = this.repository.toArtifactReference(artifactFile.getAbsolutePath());
                newArtifactReference.setVersion(version);
                File newArtifactFile = this.repository.toFile(newArtifactReference);
                if (VersionUtil.isGenericSnapshot((String)newArtifactReference.getVersion())) {
                    if (newArtifactFile.lastModified() >= olderThanThisDate.getTimeInMillis()) continue;
                    artifactsToDelete.addAll(this.repository.getRelatedArtifacts(newArtifactReference));
                    continue;
                }
                if (!VersionUtil.isUniqueSnapshot((String)newArtifactReference.getVersion()) || (timestampCal = this.uniqueSnapshotToCalendar(newArtifactReference.getVersion())).getTimeInMillis() >= olderThanThisDate.getTimeInMillis()) continue;
                artifactsToDelete.addAll(this.repository.getRelatedArtifacts(newArtifactReference));
            }
            this.purge(artifactsToDelete);
        }
        catch (ContentNotFoundException e) {
            throw new RepositoryPurgeException(e.getMessage(), e);
        }
        catch (LayoutException e) {
            this.log.debug("Not processing file that is not an artifact: {}", (Object)e.getMessage());
        }
    }

    private Calendar uniqueSnapshotToCalendar(String version) {
        Matcher mtimestamp;
        Matcher m = VersionUtil.UNIQUE_SNAPSHOT_PATTERN.matcher(version);
        if (m.matches() && (mtimestamp = VersionUtil.TIMESTAMP_PATTERN.matcher(m.group(2))).matches()) {
            String tsDate = mtimestamp.group(1);
            String tsTime = mtimestamp.group(2);
            try {
                Date versionDate = this.timestampParser.parse(tsDate + "." + tsTime);
                Calendar cal = Calendar.getInstance(DateUtils.UTC_TIME_ZONE);
                cal.setTime(versionDate);
                return cal;
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }
}

