/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.core.repository;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.common.utils.VersionComparator;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.consumers.core.repository.AbstractRepositoryPurge;
import org.apache.archiva.consumers.core.repository.RepositoryPurgeException;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.ProjectReference;
import org.apache.archiva.model.VersionedReference;
import org.apache.archiva.repository.ContentNotFoundException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RepositoryContentFactory;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.RepositoryNotFoundException;
import org.apache.archiva.repository.events.RepositoryListener;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.archiva.repository.metadata.MetadataTools;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;

public class CleanupReleasedSnapshotsRepositoryPurge
extends AbstractRepositoryPurge {
    private MetadataTools metadataTools;
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    private RepositoryContentFactory repoContentFactory;

    public CleanupReleasedSnapshotsRepositoryPurge(ManagedRepositoryContent repository, MetadataTools metadataTools, ManagedRepositoryAdmin managedRepositoryAdmin, RepositoryContentFactory repoContentFactory, RepositorySession repositorySession, List<RepositoryListener> listeners) {
        super(repository, repositorySession, listeners);
        this.metadataTools = metadataTools;
        this.managedRepositoryAdmin = managedRepositoryAdmin;
        this.repoContentFactory = repoContentFactory;
    }

    @Override
    public void process(String path) throws RepositoryPurgeException {
        try {
            File artifactFile = new File(this.repository.getRepoRoot(), path);
            if (!artifactFile.exists()) {
                return;
            }
            ArtifactReference artifactRef = this.repository.toArtifactReference(path);
            if (!VersionUtil.isSnapshot((String)artifactRef.getVersion())) {
                return;
            }
            ProjectReference reference = new ProjectReference();
            reference.setGroupId(artifactRef.getGroupId());
            reference.setArtifactId(artifactRef.getArtifactId());
            ArrayList<String> releasedVersions = new ArrayList<String>();
            List repos = this.managedRepositoryAdmin.getManagedRepositories();
            for (ManagedRepository repo : repos) {
                if (!repo.isReleases()) continue;
                try {
                    ManagedRepositoryContent repoContent = this.repoContentFactory.getManagedRepositoryContent(repo.getId());
                    for (String version : repoContent.getVersions(reference)) {
                        if (VersionUtil.isSnapshot((String)version)) continue;
                        releasedVersions.add(version);
                    }
                }
                catch (RepositoryNotFoundException repoContent) {
                }
                catch (RepositoryException repoContent) {
                }
            }
            Collections.sort(releasedVersions, VersionComparator.getInstance());
            boolean needsMetadataUpdate = false;
            VersionedReference versionRef = new VersionedReference();
            versionRef.setGroupId(artifactRef.getGroupId());
            versionRef.setArtifactId(artifactRef.getArtifactId());
            MetadataRepository metadataRepository = this.repositorySession.getRepository();
            if (releasedVersions.contains(VersionUtil.getReleaseVersion((String)artifactRef.getVersion()))) {
                versionRef.setVersion(artifactRef.getVersion());
                this.repository.deleteVersion(versionRef);
                for (RepositoryListener listener : this.listeners) {
                    listener.deleteArtifact(metadataRepository, this.repository.getId(), artifactRef.getGroupId(), artifactRef.getArtifactId(), artifactRef.getVersion(), artifactFile.getName());
                }
                metadataRepository.removeProjectVersion(this.repository.getId(), artifactRef.getGroupId(), artifactRef.getArtifactId(), artifactRef.getVersion());
                needsMetadataUpdate = true;
            }
            if (needsMetadataUpdate) {
                this.updateMetadata(artifactRef);
            }
        }
        catch (RepositoryAdminException e) {
            throw new RepositoryPurgeException(e.getMessage(), e);
        }
        catch (LayoutException e) {
            this.log.debug("Not processing file that is not an artifact: {}", (Object)e.getMessage());
        }
        catch (ContentNotFoundException e) {
            throw new RepositoryPurgeException(e.getMessage(), e);
        }
        catch (MetadataRepositoryException e) {
            this.log.error("Could not remove metadata during cleanup of released snapshots of {}", (Object)path, (Object)e);
        }
    }

    private void updateMetadata(ArtifactReference artifact) {
        VersionedReference versionRef = new VersionedReference();
        versionRef.setGroupId(artifact.getGroupId());
        versionRef.setArtifactId(artifact.getArtifactId());
        versionRef.setVersion(artifact.getVersion());
        ProjectReference projectRef = new ProjectReference();
        projectRef.setGroupId(artifact.getGroupId());
        projectRef.setArtifactId(artifact.getArtifactId());
        try {
            this.metadataTools.updateMetadata(this.repository, versionRef);
        }
        catch (ContentNotFoundException contentNotFoundException) {
        }
        catch (RepositoryMetadataException repositoryMetadataException) {
        }
        catch (IOException iOException) {
        }
        catch (LayoutException layoutException) {
            // empty catch block
        }
        try {
            this.metadataTools.updateMetadata(this.repository, projectRef);
        }
        catch (ContentNotFoundException contentNotFoundException) {
        }
        catch (RepositoryMetadataException repositoryMetadataException) {
        }
        catch (IOException iOException) {
        }
        catch (LayoutException layoutException) {
            // empty catch block
        }
    }
}

