/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.core.repository;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.consumers.core.repository.RepositoryPurge;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.model.maven2.MavenArtifactFacet;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.MetadataResolutionException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.repository.ContentNotFoundException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.events.RepositoryListener;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepositoryPurge
implements RepositoryPurge {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ManagedRepositoryContent repository;
    protected final RepositorySession repositorySession;
    protected final List<RepositoryListener> listeners;
    private Logger logger = LoggerFactory.getLogger((String)"org.apache.archiva.AuditLog");
    private static final char DELIM = ' ';

    public AbstractRepositoryPurge(ManagedRepositoryContent repository, RepositorySession repositorySession, List<RepositoryListener> listeners) {
        this.repository = repository;
        this.repositorySession = repositorySession;
        this.listeners = listeners;
    }

    protected void purge(Set<ArtifactReference> references) {
        if (references != null && !references.isEmpty()) {
            MetadataRepository metadataRepository = this.repositorySession.getRepository();
            HashMap<ArtifactInfo, ArtifactMetadata> metaRemovalList = new HashMap<ArtifactInfo, ArtifactMetadata>();
            HashMap<String, Collection> metaResolved = new HashMap<String, Collection>();
            for (ArtifactReference reference : references) {
                String baseVersion = VersionUtil.getBaseVersion((String)reference.getVersion());
                String metaBaseId = reference.getGroupId() + "/" + reference.getArtifactId() + "/" + baseVersion;
                if (!metaResolved.containsKey(metaBaseId)) {
                    try {
                        metaResolved.put(metaBaseId, metadataRepository.getArtifacts(this.repository.getId(), reference.getGroupId(), reference.getArtifactId(), baseVersion));
                    }
                    catch (MetadataResolutionException e) {
                        this.log.error("Error during metadata retrieval {}: {}", (Object)metaBaseId, (Object)e.getMessage());
                    }
                }
                Path artifactFile = this.repository.toFile(reference).toPath();
                for (RepositoryListener listener : this.listeners) {
                    listener.deleteArtifact(metadataRepository, this.repository.getId(), reference.getGroupId(), reference.getArtifactId(), reference.getVersion(), artifactFile.getFileName().toString());
                }
                try {
                    Files.delete(artifactFile);
                    this.log.debug("File deleted: {}", (Object)artifactFile.toAbsolutePath());
                }
                catch (IOException e) {
                    this.log.error("Could not delete file {}: {}", new Object[]{artifactFile.toAbsolutePath(), e.getMessage(), e});
                    continue;
                }
                try {
                    this.repository.deleteArtifact(reference);
                }
                catch (ContentNotFoundException e) {
                    this.log.warn("skip error deleting artifact {}: {}", (Object)reference, (Object)e.getMessage());
                }
                boolean snapshotVersion = VersionUtil.isSnapshot((String)reference.getVersion());
                if (snapshotVersion) {
                    Collection artifacts = (Collection)metaResolved.get(metaBaseId);
                    if (artifacts != null) {
                        for (ArtifactMetadata artifactMetadata : artifacts) {
                            if (!artifactMetadata.getVersion().equals(reference.getVersion())) continue;
                            ArtifactInfo info = new ArtifactInfo(artifactMetadata.getNamespace(), artifactMetadata.getProject(), artifactMetadata.getProjectVersion(), artifactMetadata.getVersion());
                            if (StringUtils.isNotBlank((String)reference.getClassifier())) {
                                info.setClassifier(reference.getClassifier());
                            } else {
                                info.setClassifier("");
                            }
                            metaRemovalList.put(info, artifactMetadata);
                        }
                    }
                } else {
                    ArtifactInfo info = new ArtifactInfo(reference.getGroupId(), reference.getArtifactId(), baseVersion, reference.getVersion());
                    for (ArtifactMetadata metadata : (Collection)metaResolved.get(metaBaseId)) {
                        metaRemovalList.put(info, metadata);
                    }
                }
                this.triggerAuditEvent(this.repository.getRepository().getId(), ArtifactReference.toKey((ArtifactReference)reference), "Purged Artifact");
                this.purgeSupportFiles(artifactFile);
            }
            this.purgeMetadata(metadataRepository, metaRemovalList);
            this.repositorySession.save();
        }
    }

    private void purgeMetadata(MetadataRepository metadataRepository, Map<ArtifactInfo, ArtifactMetadata> dataList) {
        HashSet<ArtifactInfo> projectLevelMetadata = new HashSet<ArtifactInfo>();
        for (Map.Entry<ArtifactInfo, ArtifactMetadata> infoEntry : dataList.entrySet()) {
            ArtifactInfo info = infoEntry.getKey();
            try {
                this.removeArtifact(metadataRepository, info, infoEntry.getValue());
                this.log.debug("Removed artifact from MetadataRepository {}", (Object)info);
            }
            catch (MetadataRepositoryException e) {
                this.log.error("Could not remove artifact from MetadataRepository {}: {}", new Object[]{info, e.getMessage(), e});
            }
            projectLevelMetadata.add(info.projectVersionLevel());
        }
        metadataRepository.save();
        Collection artifacts = null;
        for (ArtifactInfo info : projectLevelMetadata) {
            try {
                artifacts = metadataRepository.getArtifacts(this.repository.getId(), info.getNamespace(), info.getName(), info.getProjectVersion());
                if (artifacts.size() != 0) continue;
                metadataRepository.removeProjectVersion(this.repository.getId(), info.getNamespace(), info.getName(), info.getProjectVersion());
                this.log.debug("Removed project version from MetadataRepository {}", (Object)info);
            }
            catch (MetadataRepositoryException | MetadataResolutionException e) {
                this.log.error("Could not remove project version from MetadataRepository {}: {}", new Object[]{info, e.getMessage(), e});
            }
        }
        metadataRepository.save();
    }

    private void removeArtifact(MetadataRepository metadataRepository, ArtifactInfo artifactInfo, ArtifactMetadata artifactMetadata) throws MetadataRepositoryException {
        if (artifactInfo.hasClassifier()) {
            MavenArtifactFacet mavenArtifactFacet = (MavenArtifactFacet)artifactMetadata.getFacet("org.apache.archiva.metadata.repository.storage.maven2.artifact");
            if (mavenArtifactFacet != null && StringUtils.equals((String)artifactInfo.classifier, (String)mavenArtifactFacet.getClassifier())) {
                artifactMetadata.removeFacet("org.apache.archiva.metadata.repository.storage.maven2.artifact");
                String groupId = artifactInfo.getNamespace();
                String artifactId = artifactInfo.getName();
                String version = artifactInfo.getProjectVersion();
                MavenArtifactFacet mavenArtifactFacetToCompare = new MavenArtifactFacet();
                mavenArtifactFacetToCompare.setClassifier(artifactInfo.getClassifier());
                metadataRepository.removeArtifact(this.repository.getId(), groupId, artifactId, version, (MetadataFacet)mavenArtifactFacetToCompare);
                metadataRepository.save();
            }
        } else {
            metadataRepository.removeArtifact(artifactMetadata, artifactInfo.getProjectVersion());
        }
    }

    private void deleteSilently(Path path) {
        try {
            Files.deleteIfExists(path);
            this.triggerAuditEvent(this.repository.getRepository().getId(), path.toString(), "Purged Support File");
        }
        catch (IOException e) {
            this.log.error("Error occured during file deletion {}: {} ", new Object[]{path, e.getMessage(), e});
        }
    }

    private void purgeSupportFiles(Path artifactFile) {
        Path parentDir = artifactFile.getParent();
        if (!Files.exists(parentDir, new LinkOption[0])) {
            return;
        }
        String artifactName = artifactFile.getFileName().toString();
        try {
            AbstractRepositoryPurge.deleteArtifactFiles(parentDir, 3, artifactName);
        }
        catch (IOException e) {
            this.log.error("Purge of support files failed {}: {}", new Object[]{artifactFile, e.getMessage(), e});
        }
    }

    public static void deleteArtifactFiles(Path directory, int maxDepth, final String artifactName) throws IOException {
        Files.walkFileTree(directory, new HashSet<FileVisitOption>(), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().startsWith(artifactName)) {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void triggerAuditEvent(String repoId, String resource, String action) {
        String msg = repoId + ' ' + "<system-purge>" + ' ' + "<system>" + ' ' + '\"' + resource + '\"' + ' ' + '\"' + action + '\"';
        this.logger.info(msg);
    }

    class ArtifactInfo {
        final String namespace;
        final String name;
        final String projectVersion;
        String version;
        String classifier;

        ArtifactInfo(String namespace, String name, String projectVersion, String version) {
            this.namespace = namespace;
            this.name = name;
            this.projectVersion = projectVersion;
            this.version = version;
        }

        ArtifactInfo(String namespace, String name, String projectVersion) {
            this.namespace = namespace;
            this.name = name;
            this.projectVersion = projectVersion;
        }

        ArtifactInfo projectVersionLevel() {
            return new ArtifactInfo(this.namespace, this.name, this.projectVersion);
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getProjectVersion() {
            return this.projectVersion;
        }

        public String getVersion() {
            return this.version;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public boolean hasClassifier() {
            return this.classifier != null && !"".equals(this.classifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactInfo that = (ArtifactInfo)o;
            if (!this.namespace.equals(that.namespace)) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (!this.projectVersion.equals(that.projectVersion)) {
                return false;
            }
            if (!(this.version == null ? that.version == null : this.version.equals(that.version))) {
                return false;
            }
            return this.classifier != null ? this.classifier.equals(that.classifier) : that.classifier == null;
        }

        public int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.projectVersion.hashCode();
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ArtifactInfo{");
            sb.append("namespace='").append(this.namespace).append('\'');
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", projectVersion='").append(this.projectVersion).append('\'');
            sb.append(", version='").append(this.version).append('\'');
            sb.append(", classifier='").append(this.classifier).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

