/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.plexusbridge.DigesterUtils;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.codehaus.plexus.digest.ChecksumFile;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="knownRepositoryContentConsumer#validate-checksums")
@Scope(value="prototype")
public class ValidateChecksumConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer {
    private Logger log = LoggerFactory.getLogger(ValidateChecksumConsumer.class);
    private static final String NOT_VALID_CHECKSUM = "checksum-not-valid";
    private static final String CHECKSUM_NOT_FOUND = "checksum-not-found";
    private static final String CHECKSUM_DIGESTER_FAILURE = "checksum-digester-failure";
    private static final String CHECKSUM_IO_ERROR = "checksum-io-error";
    private String id = "validate-checksums";
    private String description = "Validate checksums against file.";
    private ChecksumFile checksum;
    private List<Digester> allDigesters;
    @Inject
    private PlexusSisuBridge plexusSisuBridge;
    @Inject
    private DigesterUtils digesterUtils;
    private File repositoryDir;
    private List<String> includes;

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void beginScan(ManagedRepository repository, Date whenGathered) throws ConsumerException {
        this.repositoryDir = new File(repository.getLocation());
    }

    public void beginScan(ManagedRepository repository, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        this.beginScan(repository, whenGathered);
    }

    public void completeScan() {
    }

    public void completeScan(boolean executeOnEntireRepo) {
        this.completeScan();
    }

    public List<String> getExcludes() {
        return null;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void processFile(String path) throws ConsumerException {
        File checksumFile = new File(this.repositoryDir, path);
        try {
            if (!this.checksum.isValidChecksum(checksumFile)) {
                this.log.warn("The checksum for {} is invalid.", (Object)checksumFile);
                this.triggerConsumerWarning(NOT_VALID_CHECKSUM, "The checksum for " + checksumFile + " is invalid.");
            }
        }
        catch (FileNotFoundException e) {
            this.log.error("File not found during checksum validation: ", (Throwable)e);
            this.triggerConsumerError(CHECKSUM_NOT_FOUND, "File not found during checksum validation: " + e.getMessage());
        }
        catch (DigesterException e) {
            this.log.error("Digester failure during checksum validation on {}", (Object)checksumFile);
            this.triggerConsumerError(CHECKSUM_DIGESTER_FAILURE, "Digester failure during checksum validation on " + checksumFile);
        }
        catch (IOException e) {
            this.log.error("Checksum I/O error during validation on {}", (Object)checksumFile);
            this.triggerConsumerError(CHECKSUM_IO_ERROR, "Checksum I/O error during validation on " + checksumFile);
        }
    }

    public void processFile(String path, boolean executeOnEntireReDpo) throws Exception {
        this.processFile(path);
    }

    @PostConstruct
    public void initialize() throws PlexusSisuBridgeException {
        this.checksum = (ChecksumFile)this.plexusSisuBridge.lookup(ChecksumFile.class);
        ArrayList allDigesters = new ArrayList(this.digesterUtils.getAllDigesters());
        this.includes = new ArrayList<String>(allDigesters.size());
        for (Digester digester : allDigesters) {
            this.includes.add("**/*" + digester.getFilenameExtension());
        }
    }
}

