/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.ProjectReference;
import org.apache.archiva.model.VersionedReference;
import org.apache.archiva.repository.ContentNotFoundException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RepositoryContentFactory;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.RepositoryNotFoundException;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.archiva.repository.metadata.MetadataTools;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="knownRepositoryContentConsumer#metadata-updater")
@Scope(value="prototype")
public class MetadataUpdaterConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer {
    private Logger log = LoggerFactory.getLogger(MetadataUpdaterConsumer.class);
    private String id = "metadata-updater";
    private String description = "Update / Create maven-metadata.xml files";
    @Inject
    private RepositoryContentFactory repositoryFactory;
    @Inject
    private MetadataTools metadataTools;
    @Inject
    private ArchivaConfiguration configuration;
    @Inject
    private FileTypes filetypes;
    private static final String TYPE_METADATA_BAD_INTERNAL_REF = "metadata-bad-internal-ref";
    private static final String TYPE_METADATA_WRITE_FAILURE = "metadata-write-failure";
    private static final String TYPE_METADATA_IO = "metadata-io-warning";
    private ManagedRepositoryContent repository;
    private File repositoryDir;
    private List<String> includes = new ArrayList<String>(0);
    private long scanStartTimestamp = 0L;

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void beginScan(ManagedRepository repoConfig, Date whenGathered) throws ConsumerException {
        try {
            this.repository = this.repositoryFactory.getManagedRepositoryContent(repoConfig.getId());
            this.repositoryDir = new File(this.repository.getRepoRoot());
            this.scanStartTimestamp = System.currentTimeMillis();
        }
        catch (RepositoryNotFoundException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
    }

    public void beginScan(ManagedRepository repository, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        this.beginScan(repository, whenGathered);
    }

    public void completeScan() {
    }

    public void completeScan(boolean executeOnEntireRepo) {
        this.completeScan();
    }

    public List<String> getExcludes() {
        return this.getDefaultArtifactExclusions();
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void processFile(String path) throws ConsumerException {
        if (!path.startsWith(".")) {
            try {
                ArtifactReference artifact = this.repository.toArtifactReference(path);
                this.updateVersionMetadata(artifact, path);
                this.updateProjectMetadata(artifact, path);
            }
            catch (LayoutException e) {
                this.log.info("Not processing path that is not an artifact: {} ({})", (Object)path, (Object)e.getMessage());
            }
        }
    }

    public void processFile(String path, boolean executeOnEntireRepo) throws Exception {
        this.processFile(path);
    }

    private void updateProjectMetadata(ArtifactReference artifact, String path) {
        ProjectReference projectRef = new ProjectReference();
        projectRef.setGroupId(artifact.getGroupId());
        projectRef.setArtifactId(artifact.getArtifactId());
        try {
            String metadataPath = this.metadataTools.toPath(projectRef);
            File projectMetadata = new File(this.repositoryDir, metadataPath);
            if (projectMetadata.exists() && projectMetadata.lastModified() >= this.scanStartTimestamp) {
                this.log.debug("Skipping uptodate metadata: {}", (Object)this.metadataTools.toPath(projectRef));
                return;
            }
            this.metadataTools.updateMetadata(this.repository, projectRef);
            this.log.debug("Updated metadata: {}", (Object)this.metadataTools.toPath(projectRef));
        }
        catch (LayoutException e) {
            this.log.warn("Unable to convert path [{}] to an internal project reference: ", (Object)path, (Object)e);
            this.triggerConsumerWarning(TYPE_METADATA_BAD_INTERNAL_REF, "Unable to convert path [" + path + "] to an internal project reference: " + e.getMessage());
        }
        catch (RepositoryMetadataException e) {
            this.log.error("Unable to write project metadat for artifact [{}]:", (Object)path, (Object)e);
            this.triggerConsumerError(TYPE_METADATA_WRITE_FAILURE, "Unable to write project metadata for artifact [" + path + "]: " + e.getMessage());
        }
        catch (IOException e) {
            this.log.warn("Project metadata not written due to IO warning: ", (Throwable)e);
            this.triggerConsumerWarning(TYPE_METADATA_IO, "Project metadata not written due to IO warning: " + e.getMessage());
        }
        catch (ContentNotFoundException e) {
            this.log.warn("Project metadata not written because no versions were found to update: ", (Throwable)e);
            this.triggerConsumerWarning(TYPE_METADATA_IO, "Project metadata not written because no versions were found to update: " + e.getMessage());
        }
    }

    private void updateVersionMetadata(ArtifactReference artifact, String path) {
        VersionedReference versionRef = new VersionedReference();
        versionRef.setGroupId(artifact.getGroupId());
        versionRef.setArtifactId(artifact.getArtifactId());
        versionRef.setVersion(artifact.getVersion());
        try {
            String metadataPath = this.metadataTools.toPath(versionRef);
            File projectMetadata = new File(this.repositoryDir, metadataPath);
            if (projectMetadata.exists() && projectMetadata.lastModified() >= this.scanStartTimestamp) {
                this.log.debug("Skipping uptodate metadata: {}", (Object)this.metadataTools.toPath(versionRef));
                return;
            }
            this.metadataTools.updateMetadata(this.repository, versionRef);
            this.log.debug("Updated metadata: {}", (Object)this.metadataTools.toPath(versionRef));
        }
        catch (LayoutException e) {
            this.log.warn("Unable to convert path [{}] to an internal version reference: ", (Object)path, (Object)e);
            this.triggerConsumerWarning(TYPE_METADATA_BAD_INTERNAL_REF, "Unable to convert path [" + path + "] to an internal version reference: " + e.getMessage());
        }
        catch (RepositoryMetadataException e) {
            this.log.error("Unable to write version metadata for artifact [{}]: ", (Object)path, (Object)e);
            this.triggerConsumerError(TYPE_METADATA_WRITE_FAILURE, "Unable to write version metadata for artifact [" + path + "]: " + e.getMessage());
        }
        catch (IOException e) {
            this.log.warn("Version metadata not written due to IO warning: ", (Throwable)e);
            this.triggerConsumerWarning(TYPE_METADATA_IO, "Version metadata not written due to IO warning: " + e.getMessage());
        }
        catch (ContentNotFoundException e) {
            this.log.warn("Version metadata not written because no versions were found to update: ", (Throwable)e);
            this.triggerConsumerWarning(TYPE_METADATA_IO, "Version metadata not written because no versions were found to update: " + e.getMessage());
        }
    }

    private void initIncludes() {
        this.includes = new ArrayList<String>(this.filetypes.getFileTypePatterns("artifacts"));
    }

    @PostConstruct
    public void initialize() {
        this.initIncludes();
    }
}

