/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="knownRepositoryContentConsumer#auto-rename")
@Scope(value="prototype")
public class AutoRenameConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer {
    private Logger log = LoggerFactory.getLogger(AutoRenameConsumer.class);
    private String id = "auto-rename";
    private String description = "Automatically rename common artifact mistakes.";
    private static final String RENAME_FAILURE = "rename_failure";
    private File repositoryDir;
    private List<String> includes = new ArrayList<String>(3);
    private Map<String, String> extensionRenameMap = new HashMap<String, String>();

    public AutoRenameConsumer() {
        this.includes.add("**/*.distribution-tgz");
        this.includes.add("**/*.distribution-zip");
        this.includes.add("**/*.plugin");
        this.extensionRenameMap.put(".distribution-tgz", ".tar.gz");
        this.extensionRenameMap.put(".distribution-zip", ".zip");
        this.extensionRenameMap.put(".plugin", ".jar");
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void beginScan(ManagedRepository repository, Date whenGathered) throws ConsumerException {
        this.repositoryDir = new File(repository.getLocation());
    }

    public void beginScan(ManagedRepository repository, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        this.beginScan(repository, whenGathered);
    }

    public void completeScan() {
    }

    public void completeScan(boolean executeOnEntireRepo) {
        this.completeScan();
    }

    public List<String> getExcludes() {
        return null;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void processFile(String path) throws ConsumerException {
        File file = new File(this.repositoryDir, path);
        if (file.exists()) {
            for (String extension : this.extensionRenameMap.keySet()) {
                if (!path.endsWith(extension)) continue;
                String fixedExtension = this.extensionRenameMap.get(extension);
                String correctedPath = path.substring(0, path.length() - extension.length()) + fixedExtension;
                File to = new File(this.repositoryDir, correctedPath);
                try {
                    FileUtils.moveFile((File)file, (File)to);
                }
                catch (IOException e) {
                    this.log.warn("Unable to rename {} to {} :", new Object[]{path, correctedPath, e});
                    this.triggerConsumerWarning(RENAME_FAILURE, "Unable to rename " + path + " to " + correctedPath + ": " + e.getMessage());
                }
            }
            this.log.info("(Auto) Removing File: {} ", (Object)file.getAbsolutePath());
            this.triggerConsumerInfo("(Auto) Removing File: " + file.getAbsolutePath());
            file.delete();
        }
    }

    public void processFile(String path, boolean executeOnEntireRepo) throws ConsumerException {
        this.processFile(path);
    }
}

