/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationNames;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="knownRepositoryContentConsumer#auto-remove")
@Scope(value="prototype")
public class AutoRemoveConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer,
RegistryListener {
    private Logger log = LoggerFactory.getLogger(AutoRemoveConsumer.class);
    private String id = "auto-remove";
    private String description = "Automatically Remove File from Filesystem.";
    @Inject
    private ArchivaConfiguration configuration;
    @Inject
    private FileTypes filetypes;
    private File repositoryDir;
    private List<String> includes = new ArrayList<String>(0);

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void beginScan(ManagedRepository repository, Date whenGathered) throws ConsumerException {
        this.repositoryDir = new File(repository.getLocation());
    }

    public void beginScan(ManagedRepository repository, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        this.beginScan(repository, whenGathered);
    }

    public void completeScan() {
    }

    public void completeScan(boolean executeOnEntireRepo) {
        this.completeScan();
    }

    public List<String> getExcludes() {
        return null;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void processFile(String path) throws ConsumerException {
        File file = new File(this.repositoryDir, path);
        if (file.exists()) {
            this.log.info("(Auto) Removing File: {}", (Object)file.getAbsolutePath());
            this.triggerConsumerInfo("(Auto) Removing File: " + file.getAbsolutePath());
            file.delete();
        }
    }

    public void processFile(String path, boolean executeOnEntireRepo) throws ConsumerException {
        this.processFile(path);
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isRepositoryScanning((String)propertyName)) {
            this.initIncludes();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    private void initIncludes() {
        this.includes = new ArrayList<String>(this.filetypes.getFileTypePatterns("auto-remove"));
    }

    @PostConstruct
    public void initialize() {
        this.configuration.addChangeListener((RegistryListener)this);
        this.initIncludes();
    }
}

