/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.checksum.ChecksumAlgorithm;
import org.apache.archiva.checksum.ChecksummedFile;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="knownRepositoryContentConsumer#create-missing-checksums")
@Scope(value="prototype")
public class ArtifactMissingChecksumsConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer {
    private Logger log = LoggerFactory.getLogger(ArtifactMissingChecksumsConsumer.class);
    private String id = "create-missing-checksums";
    private String description = "Create Missing and/or Fix Invalid Checksums (.sha1, .md5)";
    private ArchivaConfiguration configuration;
    private FileTypes filetypes;
    private ChecksummedFile checksum;
    private static final String TYPE_CHECKSUM_NOT_FILE = "checksum-bad-not-file";
    private static final String TYPE_CHECKSUM_CANNOT_CALC = "checksum-calc-failure";
    private static final String TYPE_CHECKSUM_CANNOT_CREATE = "checksum-create-failure";
    private File repositoryDir;
    private List<String> includes = new ArrayList<String>(0);

    @Inject
    public ArtifactMissingChecksumsConsumer(ArchivaConfiguration configuration, FileTypes filetypes) {
        this.configuration = configuration;
        this.filetypes = filetypes;
        this.initIncludes();
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void beginScan(ManagedRepository repo, Date whenGathered) throws ConsumerException {
        this.repositoryDir = new File(repo.getLocation());
    }

    public void beginScan(ManagedRepository repo, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        this.beginScan(repo, whenGathered);
    }

    public void completeScan() {
    }

    public void completeScan(boolean executeOnEntireRepo) {
        this.completeScan();
    }

    public List<String> getExcludes() {
        return this.getDefaultArtifactExclusions();
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void processFile(String path) throws ConsumerException {
        this.createFixChecksum(path, ChecksumAlgorithm.SHA1);
        this.createFixChecksum(path, ChecksumAlgorithm.MD5);
    }

    public void processFile(String path, boolean executeOnEntireRepo) throws ConsumerException {
        this.processFile(path);
    }

    private void createFixChecksum(String path, ChecksumAlgorithm checksumAlgorithm) {
        File artifactFile = new File(this.repositoryDir, path);
        File checksumFile = new File(this.repositoryDir, path + "." + checksumAlgorithm.getExt());
        if (artifactFile.exists()) {
            if (checksumFile.exists()) {
                this.checksum = new ChecksummedFile(artifactFile);
                try {
                    if (!this.checksum.isValidChecksum(checksumAlgorithm)) {
                        this.checksum.fixChecksums(new ChecksumAlgorithm[]{checksumAlgorithm});
                        this.log.info("Fixed checksum file {}", (Object)checksumFile.getAbsolutePath());
                        this.triggerConsumerInfo("Fixed checksum file " + checksumFile.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    this.log.error("Cannot calculate checksum for file {} :", (Object)checksumFile, (Object)e);
                    this.triggerConsumerError(TYPE_CHECKSUM_CANNOT_CALC, "Cannot calculate checksum for file " + checksumFile + ": " + e.getMessage());
                }
            } else if (!checksumFile.exists()) {
                this.checksum = new ChecksummedFile(artifactFile);
                try {
                    this.checksum.createChecksum(checksumAlgorithm);
                    this.log.info("Created missing checksum file {}", (Object)checksumFile.getAbsolutePath());
                    this.triggerConsumerInfo("Created missing checksum file " + checksumFile.getAbsolutePath());
                }
                catch (IOException e) {
                    this.log.error("Cannot create {} checksum for file {} :", new Object[]{checksumAlgorithm, artifactFile, e});
                    this.triggerConsumerError(TYPE_CHECKSUM_CANNOT_CREATE, "Cannot create checksum for file " + checksumFile + ": " + e.getMessage());
                }
            } else {
                this.log.warn("Checksum file {} is not a file. ", (Object)checksumFile.getAbsolutePath());
                this.triggerConsumerWarning(TYPE_CHECKSUM_NOT_FILE, "Checksum file " + checksumFile.getAbsolutePath() + " is not a file.");
            }
        }
    }

    private void initIncludes() {
        this.includes = new ArrayList<String>(this.filetypes.getFileTypePatterns("artifacts"));
    }

    @PostConstruct
    public void initialize() {
        this.initIncludes();
    }
}

