/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.scanner.functors;

import java.util.Map;
import org.apache.archiva.common.utils.BaseFile;
import org.apache.archiva.consumers.RepositoryContentConsumer;
import org.apache.commons.collections.Closure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerProcessFileClosure
implements Closure {
    private Logger log = LoggerFactory.getLogger(ConsumerProcessFileClosure.class);
    private BaseFile basefile;
    private boolean executeOnEntireRepo;
    private Map<String, Long> consumerTimings;
    private Map<String, Long> consumerCounts;

    public void execute(Object input) {
        if (input instanceof RepositoryContentConsumer) {
            RepositoryContentConsumer consumer = (RepositoryContentConsumer)input;
            String id = consumer.getId();
            try {
                if (this.basefile.exists()) {
                    Long value;
                    this.log.debug("Sending to consumer: {}", (Object)id);
                    long startTime = System.currentTimeMillis();
                    consumer.processFile(this.basefile.getRelativePath(), this.executeOnEntireRepo);
                    long endTime = System.currentTimeMillis();
                    if (this.consumerTimings != null) {
                        value = this.consumerTimings.get(id);
                        this.consumerTimings.put(id, (value != null ? value : 0L) + endTime - startTime);
                    }
                    if (this.consumerCounts != null) {
                        value = this.consumerCounts.get(id);
                        this.consumerCounts.put(id, (value != null ? value : 0L) + 1L);
                    }
                }
            }
            catch (Exception e) {
                this.log.error("Consumer [" + id + "] had an error when processing file [" + this.basefile.getAbsolutePath() + "]: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public BaseFile getBasefile() {
        return this.basefile;
    }

    public void setBasefile(BaseFile basefile) {
        this.basefile = basefile;
    }

    public boolean isExecuteOnEntireRepo() {
        return this.executeOnEntireRepo;
    }

    public void setExecuteOnEntireRepo(boolean executeOnEntireRepo) {
        this.executeOnEntireRepo = executeOnEntireRepo;
    }

    public void setConsumerTimings(Map<String, Long> consumerTimings) {
        this.consumerTimings = consumerTimings;
    }

    public void setConsumerCounts(Map<String, Long> consumerCounts) {
        this.consumerCounts = consumerCounts;
    }

    public Logger getLogger() {
        return this.log;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }
}

