/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services.interceptors;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="auditInfoFilter#rest")
@Provider
public class AuditInfoFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuditInfoFilter.class);
    @Context
    private HttpServletRequest servletRequest;
    private static final AuditInfoThreadLocal auditInfoThreadLocal = new AuditInfoThreadLocal();

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Filter {}, {}", (Object)this.servletRequest.getRemoteAddr(), (Object)this.servletRequest.getRemoteHost());
        }
        AuditInfo auditInfo = (AuditInfo)auditInfoThreadLocal.get();
        auditInfo.setRemoteAddress(this.servletRequest.getRemoteAddr());
        auditInfo.setLocalAddress(this.servletRequest.getLocalAddr());
        auditInfo.setProtocol(this.servletRequest.getProtocol());
        auditInfo.setRemoteHost(this.servletRequest.getRemoteHost());
        auditInfo.setRemotePort(this.servletRequest.getRemotePort());
        auditInfo.setMethod(containerRequestContext.getMethod());
    }

    public static AuditInfo getAuditInfo() {
        return (AuditInfo)auditInfoThreadLocal.get();
    }

    public static class AuditInfo {
        private String remoteAddress = "0.0.0.0";
        private String localAddress = "0.0.0.0";
        private String remoteHost = "0.0.0.0";
        private String protocol = "";
        private int remotePort = 0;
        private String method = "";

        public String getRemoteAddress() {
            return this.remoteAddress;
        }

        public void setRemoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
        }

        public String getLocalAddress() {
            return this.localAddress;
        }

        public void setLocalAddress(String localAddress) {
            this.localAddress = localAddress;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public void setRemoteHost(String remoteHost) {
            this.remoteHost = remoteHost;
        }

        public int getRemotePort() {
            return this.remotePort;
        }

        public void setRemotePort(int remotePort) {
            this.remotePort = remotePort;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }
    }

    public static class AuditInfoThreadLocal
    extends ThreadLocal<AuditInfo> {
        @Override
        protected AuditInfo initialValue() {
            return new AuditInfo();
        }
    }
}

