/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.archiva.common.utils.VersionComparator;
import org.apache.archiva.indexer.search.RepositorySearch;
import org.apache.archiva.indexer.search.RepositorySearchException;
import org.apache.archiva.indexer.search.SearchFields;
import org.apache.archiva.indexer.search.SearchResultHit;
import org.apache.archiva.indexer.search.SearchResultLimits;
import org.apache.archiva.indexer.search.SearchResults;
import org.apache.archiva.maven2.model.Artifact;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.rest.api.model.ChecksumSearch;
import org.apache.archiva.rest.api.model.GroupIdList;
import org.apache.archiva.rest.api.model.SearchRequest;
import org.apache.archiva.rest.api.model.StringList;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.SearchService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="searchService#rest")
public class DefaultSearchService
extends AbstractRestService
implements SearchService {
    private static final String LATEST_KEYWORD = "LATEST";
    @Inject
    private RepositorySearch repositorySearch;
    @Inject
    private RepositorySessionFactory repositorySessionFactory;

    public List<Artifact> quickSearch(String queryString) throws ArchivaRestServiceException {
        if (StringUtils.isBlank((String)queryString)) {
            return Collections.emptyList();
        }
        SearchResultLimits limits = new SearchResultLimits(0);
        try {
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), this.getObservableRepos(), queryString, limits, Collections.emptyList());
            return this.getArtifacts(searchResults);
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Artifact> quickSearchWithRepositories(SearchRequest searchRequest) throws ArchivaRestServiceException {
        String queryString = searchRequest.getQueryTerms();
        if (StringUtils.isBlank((String)queryString)) {
            return Collections.emptyList();
        }
        List<String> repositories = searchRequest.getRepositories();
        if (repositories == null || repositories.isEmpty()) {
            repositories = this.getObservableRepos();
        }
        SearchResultLimits limits = new SearchResultLimits(searchRequest.getPageSize(), searchRequest.getSelectedPage());
        try {
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), repositories, queryString, limits, Collections.emptyList());
            return this.getArtifacts(searchResults);
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Artifact> getArtifactVersions(String groupId, String artifactId, String packaging) throws ArchivaRestServiceException {
        if (StringUtils.isBlank((String)groupId) || StringUtils.isBlank((String)artifactId)) {
            return Collections.emptyList();
        }
        SearchFields searchField = new SearchFields();
        searchField.setGroupId(groupId);
        searchField.setArtifactId(artifactId);
        searchField.setPackaging(StringUtils.isBlank((String)packaging) ? "jar" : packaging);
        searchField.setRepositories(this.getObservableRepos());
        try {
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), searchField, null);
            return this.getArtifacts(searchResults);
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Artifact> searchArtifacts(SearchRequest searchRequest) throws ArchivaRestServiceException {
        if (searchRequest == null) {
            return Collections.emptyList();
        }
        SearchFields searchField = (SearchFields)this.getModelMapper().map((Object)searchRequest, SearchFields.class);
        SearchResultLimits limits = new SearchResultLimits(0);
        limits.setPageSize(searchRequest.getPageSize());
        if (searchField.getRepositories() == null || searchField.getRepositories().isEmpty()) {
            searchField.setRepositories(this.getObservableRepos());
        }
        try {
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), searchField, limits);
            return this.getArtifacts(searchResults);
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public GroupIdList getAllGroupIds(List<String> selectedRepos) throws ArchivaRestServiceException {
        List<String> observableRepos = this.getObservableRepos();
        List repos = ListUtils.intersection(observableRepos, selectedRepos);
        if (repos == null || repos.isEmpty()) {
            return new GroupIdList(Collections.emptyList());
        }
        try {
            return new GroupIdList(new ArrayList(this.repositorySearch.getAllGroupIds(this.getPrincipal(), repos)));
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Artifact> getArtifactByChecksum(ChecksumSearch checksumSearch) throws ArchivaRestServiceException {
        if (checksumSearch.getRepositories() == null || checksumSearch.getRepositories().isEmpty()) {
            checksumSearch.setRepositories(this.getObservableRepos());
        }
        RepositorySession repositorySession = this.repositorySessionFactory.createSession();
        MetadataRepository metadataRepository = repositorySession.getRepository();
        HashSet<Artifact> artifactSet = new HashSet<Artifact>();
        try {
            for (String repoId : checksumSearch.getRepositories()) {
                Collection artifactMetadatas = metadataRepository.getArtifactsByChecksum(repoId, checksumSearch.getChecksum());
                artifactSet.addAll(this.buildArtifacts(artifactMetadatas, repoId));
            }
            ArrayList arrayList = new ArrayList(artifactSet);
            return arrayList;
        }
        catch (MetadataRepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
        finally {
            repositorySession.closeQuietly();
        }
    }

    public StringList getObservablesRepoIds() throws ArchivaRestServiceException {
        return new StringList(this.getObservableRepos());
    }

    public Response redirectToArtifactFile(String repositoryId, String groupId, String artifactId, String version, String packaging, String classifier, Boolean literalVersion) throws ArchivaRestServiceException {
        try {
            if (StringUtils.isEmpty((String)groupId)) {
                return Response.status((Response.StatusType)new Response.StatusType(){

                    public int getStatusCode() {
                        return Response.Status.BAD_REQUEST.getStatusCode();
                    }

                    public Response.Status.Family getFamily() {
                        return Response.Status.BAD_REQUEST.getFamily();
                    }

                    public String getReasonPhrase() {
                        return "groupId mandatory";
                    }
                }).build();
            }
            if (StringUtils.isEmpty((String)version)) {
                return Response.status((Response.StatusType)new Response.StatusType(){

                    public int getStatusCode() {
                        return Response.Status.BAD_REQUEST.getStatusCode();
                    }

                    public Response.Status.Family getFamily() {
                        return Response.Status.BAD_REQUEST.getFamily();
                    }

                    public String getReasonPhrase() {
                        return "version mandatory";
                    }
                }).build();
            }
            if (StringUtils.isEmpty((String)artifactId)) {
                return Response.status((Response.StatusType)new Response.StatusType(){

                    public int getStatusCode() {
                        return Response.Status.BAD_REQUEST.getStatusCode();
                    }

                    public Response.Status.Family getFamily() {
                        return Response.Status.BAD_REQUEST.getFamily();
                    }

                    public String getReasonPhrase() {
                        return "artifactId mandatory";
                    }
                }).build();
            }
            SearchFields searchField = new SearchFields();
            searchField.setGroupId(groupId);
            searchField.setArtifactId(artifactId);
            searchField.setPackaging(StringUtils.isBlank((String)packaging) ? "jar" : packaging);
            if (literalVersion.booleanValue() || !StringUtils.equals((String)version, (String)LATEST_KEYWORD)) {
                searchField.setVersion(version);
            }
            searchField.setClassifier(classifier);
            List<String> userRepos = this.getObservablesRepoIds().getStrings();
            searchField.setRepositories((List)(StringUtils.isEmpty((String)repositoryId) ? userRepos : Arrays.asList(repositoryId)));
            this.log.debug("Searching repository {}", (Object)repositoryId);
            searchField.setExactSearch(true);
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), searchField, null);
            List<Artifact> artifacts = this.getArtifacts(searchResults, repositoryId);
            if (artifacts.isEmpty()) {
                return Response.status((Response.StatusType)new Response.StatusType(){

                    public int getStatusCode() {
                        return Response.Status.NO_CONTENT.getStatusCode();
                    }

                    public Response.Status.Family getFamily() {
                        return Response.Status.NO_CONTENT.getFamily();
                    }

                    public String getReasonPhrase() {
                        return "your query doesn't return any artifact";
                    }
                }).build();
            }
            if (classifier == null) {
                ArrayList<Artifact> filteredArtifacts = new ArrayList<Artifact>(artifacts.size());
                for (Artifact artifact : artifacts) {
                    if (artifact.getClassifier() != null) continue;
                    filteredArtifacts.add(artifact);
                }
                artifacts = filteredArtifacts;
            }
            if (artifacts.size() > 1 && (literalVersion.booleanValue() || !StringUtils.equals((String)version, (String)LATEST_KEYWORD))) {
                return Response.status((Response.StatusType)new Response.StatusType(){

                    public int getStatusCode() {
                        return Response.Status.BAD_REQUEST.getStatusCode();
                    }

                    public Response.Status.Family getFamily() {
                        return Response.Status.BAD_REQUEST.getFamily();
                    }

                    public String getReasonPhrase() {
                        return "your query return more than one artifact";
                    }
                }).build();
            }
            if (!literalVersion.booleanValue() && artifacts.size() > 1 && StringUtils.equals((String)version, (String)LATEST_KEYWORD)) {
                TreeMap<String, Artifact> artifactPerVersion = new TreeMap<String, Artifact>(VersionComparator.getInstance());
                for (Artifact artifact : artifacts) {
                    artifactPerVersion.put(artifact.getVersion(), artifact);
                }
                return Response.temporaryRedirect((URI)new URI(((Artifact)artifactPerVersion.lastEntry().getValue()).getUrl())).build();
            }
            Artifact artifact = artifacts.get(0);
            this.log.debug("Returning artifact {}, {}", (Object)artifact.getUrl(), (Object)artifact.getRepositoryId());
            return Response.temporaryRedirect((URI)new URI(artifact.getUrl())).build();
        }
        catch (Exception e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    protected List<Artifact> getArtifacts(SearchResults searchResults) throws ArchivaRestServiceException {
        return this.getArtifacts(searchResults, null);
    }

    protected List<Artifact> getArtifacts(SearchResults searchResults, String repositoryId) throws ArchivaRestServiceException {
        if (searchResults == null || searchResults.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(searchResults.getReturnedHitsCount());
        for (SearchResultHit hit : searchResults.getHits()) {
            if (hit.getVersions().size() <= 0) continue;
            for (String version : hit.getVersions()) {
                Artifact versionned = (Artifact)this.getModelMapper().map((Object)hit, Artifact.class);
                if (!StringUtils.isNotBlank((String)version)) continue;
                versionned.setVersion(version);
                versionned.setUrl(this.getArtifactUrl(versionned, repositoryId));
                artifacts.add(versionned);
            }
        }
        return artifacts;
    }
}

