/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services.interceptors;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.archiva.redback.rest.api.model.RedbackRestError;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;
import org.springframework.stereotype.Service;

@Provider
@Service(value="redbackServiceExceptionMapper")
public class RedbackServiceExceptionMapper
implements ExceptionMapper<RedbackServiceException> {
    public Response toResponse(final RedbackServiceException e) {
        RedbackRestError restError = new RedbackRestError(e);
        Response.ResponseBuilder responseBuilder = Response.status((int)e.getHttpErrorCode()).entity((Object)restError);
        if (e.getMessage() != null) {
            responseBuilder = responseBuilder.status(new Response.StatusType(){

                public int getStatusCode() {
                    return e.getHttpErrorCode();
                }

                public Response.Status.Family getFamily() {
                    return Response.Status.Family.SERVER_ERROR;
                }

                public String getReasonPhrase() {
                    return e.getMessage();
                }
            });
        }
        return responseBuilder.build();
    }
}

