/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services.interceptors;

import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.redback.integration.filter.authentication.HttpAuthenticationException;
import org.apache.archiva.redback.integration.filter.authentication.basic.HttpBasicAuthentication;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.rest.services.RedbackAuthenticationThreadLocal;
import org.apache.archiva.redback.rest.services.RedbackRequestInformation;
import org.apache.archiva.redback.rest.services.interceptors.AbstractInterceptor;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="authenticationInterceptor#rest")
@Provider
public class AuthenticationInterceptor
extends AbstractInterceptor
implements ContainerRequestFilter {
    @Inject
    @Named(value="userManager#default")
    private UserManager userManager;
    @Inject
    @Named(value="httpAuthenticator#basic")
    private HttpBasicAuthentication httpAuthenticator;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void filter(ContainerRequestContext containerRequestContext) {
        Message message = JAXRSUtils.getCurrentMessage();
        RedbackAuthorization redbackAuthorization = this.getRedbackAuthorization(message);
        if (redbackAuthorization == null) {
            this.log.warn("http path {} doesn't contain any informations regarding permissions ", message.get((Object)"org.apache.cxf.request.uri"));
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            return;
        }
        HttpServletRequest request = this.getHttpServletRequest(message);
        HttpServletResponse response = this.getHttpServletResponse(message);
        if (redbackAuthorization.noRestriction()) {
            SecuritySession securitySession = this.httpAuthenticator.getSecuritySession(request.getSession(true));
            if (securitySession != null) {
                RedbackRequestInformation redbackRequestInformation = new RedbackRequestInformation(securitySession.getUser(), request.getRemoteAddr());
                RedbackAuthenticationThreadLocal.set(redbackRequestInformation);
            } else {
                try {
                    AuthenticationResult authenticationResult = this.httpAuthenticator.getAuthenticationResult(request, response);
                    if (authenticationResult == null || !authenticationResult.isAuthenticated()) {
                        return;
                    }
                    User user = authenticationResult.getUser() == null ? this.userManager.findUser(authenticationResult.getPrincipal()) : authenticationResult.getUser();
                    RedbackRequestInformation redbackRequestInformation = new RedbackRequestInformation(user, request.getRemoteAddr());
                    RedbackAuthenticationThreadLocal.set(redbackRequestInformation);
                    message.put(AuthenticationResult.class, (Object)authenticationResult);
                }
                catch (Exception authenticationResult) {
                    // empty catch block
                }
            }
            return;
        }
        try {
            AuthenticationResult authenticationResult = this.httpAuthenticator.getAuthenticationResult(request, response);
            if (authenticationResult == null || !authenticationResult.isAuthenticated()) {
                throw new HttpAuthenticationException("You are not authenticated.");
            }
            User user = authenticationResult.getUser() == null ? this.userManager.findUser(authenticationResult.getPrincipal()) : authenticationResult.getUser();
            RedbackRequestInformation redbackRequestInformation = new RedbackRequestInformation(user, request.getRemoteAddr());
            RedbackAuthenticationThreadLocal.set(redbackRequestInformation);
            message.put(AuthenticationResult.class, (Object)authenticationResult);
            return;
        }
        catch (UserNotFoundException e) {
            this.log.debug("UserNotFoundException for path {}", message.get((Object)"org.apache.cxf.request.uri"));
        }
        catch (AccountLockedException e) {
            this.log.debug("account locked for path {}", message.get((Object)"org.apache.cxf.request.uri"));
        }
        catch (MustChangePasswordException e) {
            this.log.debug("must change password for path {}", message.get((Object)"org.apache.cxf.request.uri"));
        }
        catch (AuthenticationException e) {
            this.log.debug("failed to authenticate for path {}", message.get((Object)"org.apache.cxf.request.uri"));
        }
        catch (UserManagerException e) {
            this.log.debug("UserManagerException: {} for path", (Object)e.getMessage(), message.get((Object)"org.apache.cxf.request.uri"));
        }
        containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
    }
}

