/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rss.processor;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.inject.Inject;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.rss.RssFeedEntry;
import org.apache.archiva.rss.RssFeedGenerator;
import org.apache.archiva.rss.processor.AbstractArtifactsRssFeedProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="rssFeedProcessor#new-artifacts")
public class NewArtifactsRssFeedProcessor
extends AbstractArtifactsRssFeedProcessor {
    private int numberOfDaysBeforeNow = 30;
    private static final String title = "New Artifacts in Repository ";
    private static final String desc = "These are the new artifacts found in the repository ";
    @Inject
    private RssFeedGenerator generator;
    private Logger log = LoggerFactory.getLogger(NewArtifactsRssFeedProcessor.class);
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");

    @Override
    public SyndFeed process(Map<String, String> reqParams, MetadataRepository metadataRepository) throws FeedException {
        this.log.debug("Process new artifacts into rss feeds.");
        String repoId = reqParams.get("repoId");
        if (repoId != null) {
            return this.processNewArtifactsInRepo(repoId, metadataRepository);
        }
        return null;
    }

    private SyndFeed processNewArtifactsInRepo(String repoId, MetadataRepository metadataRepository) throws FeedException {
        List artifacts;
        Calendar greaterThanThisDate = Calendar.getInstance(GMT_TIME_ZONE);
        greaterThanThisDate.add(5, -this.getNumberOfDaysBeforeNow());
        greaterThanThisDate.clear(14);
        try {
            artifacts = metadataRepository.getArtifactsByDateRange(repoId, greaterThanThisDate.getTime(), null);
        }
        catch (MetadataRepositoryException e) {
            throw new FeedException("Unable to construct feed, metadata could not be retrieved: " + e.getMessage(), (Throwable)e);
        }
        long tmp = 0L;
        RssFeedEntry entry = null;
        ArrayList<RssFeedEntry> entries = new ArrayList<RssFeedEntry>();
        String description = "";
        int idx = 0;
        for (ArtifactMetadata artifact : artifacts) {
            long whenGathered = artifact.getWhenGathered().getTime();
            String id = artifact.getNamespace() + "/" + artifact.getProject() + "/" + artifact.getId();
            if (tmp != whenGathered) {
                if (entry != null) {
                    entry.setDescription(description);
                    entries.add(entry);
                    entry = null;
                }
                String repoId1 = artifact.getRepositoryId();
                entry = new RssFeedEntry(this.getTitle() + "'" + repoId1 + "' as of " + new Date(whenGathered));
                entry.setPublishedDate(artifact.getWhenGathered());
                description = this.getDescription() + "'" + repoId1 + "': \n" + id + " | ";
            } else {
                description = description + id + " | ";
            }
            if (idx == artifacts.size() - 1) {
                entry.setDescription(description);
                entries.add(entry);
            }
            tmp = whenGathered;
            ++idx;
        }
        return this.generator.generateFeed(this.getTitle() + "'" + repoId + "'", "New artifacts found in repository '" + repoId + "' during repository scan.", entries);
    }

    @Override
    public String getTitle() {
        return title;
    }

    @Override
    public String getDescription() {
        return desc;
    }

    public RssFeedGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(RssFeedGenerator generator) {
        this.generator = generator;
    }

    public int getNumberOfDaysBeforeNow() {
        return this.numberOfDaysBeforeNow;
    }

    public void setNumberOfDaysBeforeNow(int numberOfDaysBeforeNow) {
        this.numberOfDaysBeforeNow = numberOfDaysBeforeNow;
    }
}

