/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.indexer.merger;

import org.apache.archiva.indexer.merger.IndexMerger;
import org.apache.archiva.indexer.merger.IndexMergerException;
import org.apache.archiva.indexer.merger.MergedRemoteIndexesTaskRequest;
import org.apache.archiva.indexer.merger.MergedRemoteIndexesTaskResult;
import org.apache.maven.index.context.IndexingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedRemoteIndexesTask
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private MergedRemoteIndexesTaskRequest mergedRemoteIndexesTaskRequest;

    public MergedRemoteIndexesTask(MergedRemoteIndexesTaskRequest mergedRemoteIndexesTaskRequest) {
        this.mergedRemoteIndexesTaskRequest = mergedRemoteIndexesTaskRequest;
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (IndexMergerException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public MergedRemoteIndexesTaskResult execute() throws IndexMergerException {
        IndexMerger indexMerger = this.mergedRemoteIndexesTaskRequest.getIndexMerger();
        IndexingContext indexingContext = indexMerger.buildMergedIndex(this.mergedRemoteIndexesTaskRequest.getIndexMergerRequest());
        return new MergedRemoteIndexesTaskResult(indexingContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MergedRemoteIndexesTask)) {
            return false;
        }
        MergedRemoteIndexesTask that = (MergedRemoteIndexesTask)o;
        return this.mergedRemoteIndexesTaskRequest.equals(that.mergedRemoteIndexesTaskRequest);
    }

    public int hashCode() {
        return this.mergedRemoteIndexesTaskRequest.hashCode();
    }
}

