/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.thrift;

import com.thinkaurelius.thrift.Message;
import com.thinkaurelius.thrift.TDisruptorServer;
import com.thinkaurelius.thrift.test.ArgType;
import com.thinkaurelius.thrift.test.OperationType;
import com.thinkaurelius.thrift.test.Request;
import com.thinkaurelius.thrift.test.Response;
import com.thinkaurelius.thrift.test.TestService;
import com.thinkaurelius.thrift.util.TBinaryProtocol;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.junit.AfterClass;
import org.junit.Assert;

public class AbstractDisruptorTest {
    private static TServer TEST_SERVICE;
    private static final Random RANDOM;
    protected static final String HOST;
    protected static final int SERVER_PORT = 9161;

    public static void prepareTest(boolean onHeapBuffers) throws Exception {
        TNonblockingServerSocket socket = new TNonblockingServerSocket(new InetSocketAddress(HOST, 9161));
        TBinaryProtocol.Factory protocol = new TBinaryProtocol.Factory();
        TDisruptorServer.Args args = ((TDisruptorServer.Args)((TDisruptorServer.Args)((TDisruptorServer.Args)((TDisruptorServer.Args)((TDisruptorServer.Args)new TDisruptorServer.Args((TNonblockingServerTransport)socket).inputTransportFactory((TTransportFactory)new TFramedTransport.Factory())).outputTransportFactory((TTransportFactory)new TFramedTransport.Factory())).inputProtocolFactory((TProtocolFactory)protocol)).outputProtocolFactory((TProtocolFactory)protocol)).processor(new TestService.Processor<Service>(new Service()))).useHeapBasedAllocation(onHeapBuffers);
        TEST_SERVICE = new CustomTDisruptorServer(args);
        new Thread(){

            @Override
            public void run() {
                TEST_SERVICE.serve();
            }
        }.start();
    }

    @AfterClass
    public static void shutdownTest() {
        TEST_SERVICE.stop();
    }

    protected TTransport getNewTransport() throws TTransportException {
        return new TFramedTransport((TTransport)new TSocket(HOST, 9161));
    }

    protected TestService.Client getNewClient(TTransport transport) throws TTransportException {
        if (!transport.isOpen()) {
            transport.open();
        }
        return new TestService.Client((TProtocol)new TBinaryProtocol(transport, true, true));
    }

    protected void invokeRequests(TestService.Client client, int startId, int arg1, int arg2) throws TException {
        Response responseAdd = client.invoke(AbstractDisruptorTest.getRequest(startId + 0, arg1, arg2, OperationType.ADD));
        Response responseSub = client.invoke(AbstractDisruptorTest.getRequest(startId + 1, arg1, arg2, OperationType.SUB));
        Response responseMul = client.invoke(AbstractDisruptorTest.getRequest(startId + 2, arg1, arg2, OperationType.MUL));
        Response responseDiv = client.invoke(AbstractDisruptorTest.getRequest(startId + 3, arg1, arg2, OperationType.DIV));
        int resultAdd = AbstractDisruptorTest.toInteger(responseAdd.bufferForResult());
        int resultSub = AbstractDisruptorTest.toInteger(responseSub.bufferForResult());
        int resultMul = AbstractDisruptorTest.toInteger(responseMul.bufferForResult());
        int resultDiv = AbstractDisruptorTest.toInteger(responseDiv.bufferForResult());
        Assert.assertEquals((long)responseAdd.getId(), (long)startId);
        Assert.assertEquals((long)responseSub.getId(), (long)(startId + 1));
        Assert.assertEquals((long)responseMul.getId(), (long)(startId + 2));
        Assert.assertEquals((long)responseDiv.getId(), (long)(startId + 3));
        Assert.assertEquals((long)(arg1 + arg2), (long)resultAdd);
        Assert.assertEquals((long)(arg1 - arg2), (long)resultSub);
        Assert.assertEquals((long)(arg1 * arg2), (long)resultMul);
        Assert.assertEquals((long)(arg1 / arg2), (long)resultDiv);
        Assert.assertEquals((Object)((Object)ArgType.INT), (Object)((Object)responseAdd.getResType()));
        Assert.assertEquals((Object)((Object)ArgType.INT), (Object)((Object)responseSub.getResType()));
        Assert.assertEquals((Object)((Object)ArgType.INT), (Object)((Object)responseMul.getResType()));
        Assert.assertEquals((Object)((Object)ArgType.INT), (Object)((Object)responseDiv.getResType()));
        Response responseEmpty = client.invoke(new Request().setId(startId + 4).setArg1(ByteBuffer.allocate(0)).setArg2(ByteBuffer.allocate(0)).setArgType(ArgType.LONG).setOperationType(OperationType.DIV));
        Assert.assertNull((Object)responseEmpty.getResult());
        Assert.assertNull((Object)((Object)responseEmpty.getResType()));
    }

    protected static ByteBuffer toByteBuffer(int integer) {
        ByteBuffer b = ByteBuffer.allocate(4).putInt(integer);
        b.clear();
        return b;
    }

    protected static int toInteger(ByteBuffer buffer) {
        return buffer.getInt();
    }

    protected static int getRandomArgument() {
        int n = RANDOM.nextInt(50000);
        return n == 0 ? 1 : n;
    }

    private static Request getRequest(int id, int arg1, int arg2, OperationType op) {
        return new Request().setId(id).setArg1(AbstractDisruptorTest.toByteBuffer(arg1)).setArg2(AbstractDisruptorTest.toByteBuffer(arg2)).setArgType(ArgType.INT).setOperationType(op);
    }

    static /* synthetic */ Request access$100(int x0, int x1, int x2, OperationType x3) {
        return AbstractDisruptorTest.getRequest(x0, x1, x2, x3);
    }

    static {
        RANDOM = new Random();
        try {
            HOST = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected class Work
    implements Callable<Request> {
        private final CountDownLatch latch;
        private final int id;
        private final int arg1;
        private final int arg2;
        private final OperationType op;

        public Work(CountDownLatch latch, int id, int arg1, int arg2, OperationType op) {
            this.latch = latch;
            this.id = id;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.op = op;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public Request call() throws Exception {
            transport = AbstractDisruptorTest.this.getNewTransport();
            try {
                client = AbstractDisruptorTest.this.getNewClient(transport);
                res = client.invoke(AbstractDisruptorTest.access$100(this.id, this.arg1, this.arg2, this.op));
                switch (2.$SwitchMap$com$thinkaurelius$thrift$test$OperationType[this.op.ordinal()]) {
                    case 1: {
                        Assert.assertEquals((long)this.id, (long)res.getId());
                        Assert.assertEquals((Object)ArgType.INT, (Object)res.getResType());
                        Assert.assertEquals((long)(this.arg1 + this.arg2), (long)AbstractDisruptorTest.toInteger(res.bufferForResult()));
                        ** break;
lbl11:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            finally {
                transport.close();
            }
            this.latch.countDown();
            return null;
        }
    }

    protected static class Service
    implements TestService.Iface {
        protected Service() {
        }

        @Override
        public Response invoke(Request req) throws TException {
            if (req.getArgType() == ArgType.INT) {
                int arg1 = AbstractDisruptorTest.toInteger(req.arg1);
                int arg2 = AbstractDisruptorTest.toInteger(req.arg2);
                int result = -1;
                switch (req.getOperationType()) {
                    case ADD: {
                        result = arg1 + arg2;
                        break;
                    }
                    case SUB: {
                        result = arg1 - arg2;
                        break;
                    }
                    case MUL: {
                        result = arg1 * arg2;
                        break;
                    }
                    case DIV: {
                        result = arg1 / arg2;
                    }
                }
                return new Response().setId(req.id).setResType(ArgType.INT).setResult(AbstractDisruptorTest.toByteBuffer(result));
            }
            return new Response();
        }

        @Override
        public void ping() throws TException {
        }
    }

    protected static class CustomTDisruptorServer
    extends TDisruptorServer {
        public CustomTDisruptorServer(TDisruptorServer.Args args) {
            super(args);
        }

        @Override
        protected void beforeInvoke(Message message) {
        }
    }
}

