/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.cache.ehcache;

import java.io.File;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.components.cache.CacheException;
import org.apache.archiva.redback.components.cache.CacheHints;
import org.apache.archiva.redback.components.cache.ehcache.EhcacheCache;
import org.apache.archiva.redback.components.cache.factory.CacheCreator;
import org.apache.commons.lang.SystemUtils;

public class EhcacheCreator
implements CacheCreator {
    public Cache createCache(CacheHints hints) throws CacheException {
        EhcacheCache cache = new EhcacheCache();
        cache.setName(hints.getName());
        cache.setDiskPersistent(hints.isOverflowToDisk());
        if (hints.isOverflowToDisk()) {
            File overflowPath = null;
            if (hints.getDiskOverflowPath() != null) {
                overflowPath = hints.getDiskOverflowPath();
            } else {
                File tmpDir = SystemUtils.getJavaIoTmpDir();
                overflowPath = new File(tmpDir, "ehcache/" + hints.getName());
            }
            cache.setDiskStorePath(overflowPath.getAbsolutePath());
        }
        cache.setMaxElementsInMemory(hints.getMaxElements());
        cache.setTimeToLiveSeconds(hints.getMaxSecondsInCache());
        cache.setTimeToIdleSeconds(hints.getIdleExpirationSeconds());
        cache.initialize();
        return cache;
    }
}

