/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.cache.ehcache;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.MemoryUnit;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.components.cache.CacheStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheCache<V, T>
implements Cache<V, T> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private long diskExpiryThreadIntervalSeconds = 600L;
    private boolean diskPersistent = true;
    private String diskStorePath = System.getProperty("java.io.tmpdir") + "/ehcache";
    private boolean eternal = false;
    private int maxElementsInMemory = 0;
    private String memoryEvictionPolicy = "LRU";
    private String name = "cache";
    private boolean overflowToDisk = false;
    private int timeToIdleSeconds = 600;
    private int timeToLiveSeconds = 300;
    private boolean overflowToOffHeap = false;
    private long maxBytesLocalHeap;
    private long maxBytesLocalOffHeap;
    private boolean failOnDuplicateCache = false;
    private int maxElementsOnDisk;
    private boolean statisticsEnabled = true;
    private CacheManager cacheManager = null;
    private net.sf.ehcache.Cache ehcache;
    private Stats stats;

    public void clear() {
        this.ehcache.removeAll();
        this.stats.clear();
    }

    @PostConstruct
    public void initialize() {
        boolean cacheManagerExists;
        this.stats = new Stats();
        boolean bl = cacheManagerExists = CacheManager.getCacheManager((String)this.getName()) != null;
        if (cacheManagerExists) {
            if (this.failOnDuplicateCache) {
                throw new RuntimeException("A previous cacheManager with name [" + this.getName() + "] exists.");
            }
            this.log.warn("skip duplicate cache {}", (Object)this.getName());
            this.cacheManager = CacheManager.getCacheManager((String)this.getName());
        } else {
            this.cacheManager = new CacheManager(new Configuration().name(this.getName()).diskStore(new DiskStoreConfiguration().path(this.getDiskStorePath())));
        }
        boolean cacheExists = this.cacheManager.cacheExists(this.getName());
        if (cacheExists) {
            if (this.failOnDuplicateCache) {
                throw new RuntimeException("A previous cache with name [" + this.getName() + "] exists.");
            }
            this.log.warn("skip duplicate cache {}", (Object)this.getName());
            this.ehcache = this.cacheManager.getCache(this.getName());
        }
        if (!cacheExists) {
            CacheConfiguration cacheConfiguration = new CacheConfiguration().name(this.getName()).memoryStoreEvictionPolicy(this.getMemoryStoreEvictionPolicy()).eternal(this.isEternal()).timeToLiveSeconds((long)this.getTimeToLiveSeconds()).timeToIdleSeconds((long)this.getTimeToIdleSeconds()).diskExpiryThreadIntervalSeconds(this.getDiskExpiryThreadIntervalSeconds()).overflowToOffHeap(this.isOverflowToOffHeap()).maxEntriesLocalDisk(this.getMaxElementsOnDisk()).diskPersistent(this.isDiskPersistent()).overflowToDisk(this.overflowToDisk);
            if (this.getMaxElementsInMemory() > 0) {
                cacheConfiguration = cacheConfiguration.maxEntriesLocalHeap(this.getMaxElementsInMemory());
            }
            if (this.getMaxBytesLocalHeap() > 0L) {
                cacheConfiguration = cacheConfiguration.maxBytesLocalHeap(this.getMaxBytesLocalHeap(), MemoryUnit.BYTES);
            }
            if (this.getMaxBytesLocalOffHeap() > 0L) {
                cacheConfiguration = cacheConfiguration.maxBytesLocalOffHeap(this.getMaxBytesLocalOffHeap(), MemoryUnit.BYTES);
            }
            this.ehcache = new net.sf.ehcache.Cache(cacheConfiguration);
            this.cacheManager.addCache(this.ehcache);
        }
    }

    @PreDestroy
    public void dispose() {
        if (this.cacheManager.getStatus().equals(Status.STATUS_ALIVE)) {
            this.log.info("Disposing cache: {}", (Object)this.ehcache);
            if (this.ehcache != null) {
                this.cacheManager.removeCache(this.ehcache.getName());
                this.ehcache = null;
            }
        } else {
            this.log.debug("Not disposing cache, because cacheManager is not alive: {}", (Object)this.ehcache);
        }
    }

    public T get(V key) {
        if (key == null) {
            return null;
        }
        Element elem = this.ehcache.get(key);
        if (elem == null) {
            return null;
        }
        return (T)elem.getObjectValue();
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public String getDiskStorePath() {
        return this.diskStorePath;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public String getMemoryEvictionPolicy() {
        return this.memoryEvictionPolicy;
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return MemoryStoreEvictionPolicy.fromString((String)this.memoryEvictionPolicy);
    }

    public String getName() {
        return this.name;
    }

    public CacheStatistics getStatistics() {
        return this.stats;
    }

    public int getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public boolean hasKey(V key) {
        return this.ehcache.isKeyInCache(key);
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public void register(V key, T value) {
        this.ehcache.put(new Element(key, value));
    }

    public T put(V key, T value) {
        Element elem = null;
        Object previous = null;
        elem = this.ehcache.get(key);
        if (elem != null) {
            previous = elem.getObjectValue();
        }
        elem = new Element(key, value);
        this.ehcache.put(elem);
        return (T)previous;
    }

    public T remove(V key) {
        Element elem = null;
        Object previous = null;
        elem = this.ehcache.get(key);
        if (elem != null) {
            previous = elem.getObjectValue();
            this.ehcache.remove(key);
        }
        return (T)previous;
    }

    public void setDiskExpiryThreadIntervalSeconds(long diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public void setDiskStorePath(String diskStorePath) {
        this.diskStorePath = diskStorePath;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
        if (this.ehcache != null) {
            this.ehcache.getCacheConfiguration().setMaxElementsInMemory(this.maxElementsInMemory);
            this.ehcache.getCacheConfiguration().setMaxEntriesLocalHeap((long)this.maxElementsInMemory);
        }
    }

    public void setMemoryEvictionPolicy(String memoryEvictionPolicy) {
        this.memoryEvictionPolicy = memoryEvictionPolicy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public void setTimeToIdleSeconds(int timeToIdleSeconds) {
        if (this.ehcache != null) {
            this.ehcache.getCacheConfiguration().setTimeToIdleSeconds((long)timeToIdleSeconds);
        }
        this.timeToIdleSeconds = timeToIdleSeconds;
    }

    public void setTimeToLiveSeconds(int timeToLiveSeconds) {
        if (this.ehcache != null) {
            this.ehcache.getCacheConfiguration().setTimeToLiveSeconds((long)this.timeToIdleSeconds);
        }
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public boolean isFailOnDuplicateCache() {
        return this.failOnDuplicateCache;
    }

    public void setFailOnDuplicateCache(boolean failOnDuplicateCache) {
        this.failOnDuplicateCache = failOnDuplicateCache;
    }

    public boolean isOverflowToOffHeap() {
        return this.overflowToOffHeap;
    }

    public void setOverflowToOffHeap(boolean overflowToOffHeap) {
        this.overflowToOffHeap = overflowToOffHeap;
    }

    public long getMaxBytesLocalHeap() {
        return this.maxBytesLocalHeap;
    }

    public void setMaxBytesLocalHeap(long maxBytesLocalHeap) {
        this.maxBytesLocalHeap = maxBytesLocalHeap;
    }

    public long getMaxBytesLocalOffHeap() {
        return this.maxBytesLocalOffHeap;
    }

    public void setMaxBytesLocalOffHeap(long maxBytesLocalOffHeap) {
        this.maxBytesLocalOffHeap = maxBytesLocalOffHeap;
    }

    public int getMaxElementsOnDisk() {
        return this.maxElementsOnDisk;
    }

    public void setMaxElementsOnDisk(int maxElementsOnDisk) {
        this.maxElementsOnDisk = maxElementsOnDisk;
        if (this.ehcache != null) {
            this.ehcache.getCacheConfiguration().setMaxElementsOnDisk(this.maxElementsOnDisk);
            this.ehcache.getCacheConfiguration().maxEntriesLocalDisk(this.maxElementsOnDisk);
        }
    }

    class Stats
    implements CacheStatistics {
        Stats() {
        }

        public void clear() {
        }

        public double getCacheHitRate() {
            double hits = this.getCacheHits();
            double miss = this.getCacheMiss();
            if (hits == 0.0 && hits == 0.0) {
                return 0.0;
            }
            return hits / (hits + miss);
        }

        public long getCacheHits() {
            return EhcacheCache.this.ehcache.getStatistics().cacheHitCount();
        }

        public long getCacheMiss() {
            return EhcacheCache.this.ehcache.getStatistics().cacheMissCount();
        }

        public long getSize() {
            return EhcacheCache.this.ehcache.getStatistics().getSize();
        }

        public long getInMemorySize() {
            return EhcacheCache.this.ehcache.getStatistics().getLocalHeapSizeInBytes();
        }
    }
}

