/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.authentication.ldap;

import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.archiva.redback.authentication.AbstractAuthenticator;
import org.apache.archiva.redback.authentication.AuthenticationDataSource;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authentication.Authenticator;
import org.apache.archiva.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.apache.archiva.redback.common.ldap.LdapUtils;
import org.apache.archiva.redback.common.ldap.connection.LdapConnection;
import org.apache.archiva.redback.common.ldap.connection.LdapConnectionFactory;
import org.apache.archiva.redback.common.ldap.connection.LdapException;
import org.apache.archiva.redback.common.ldap.user.UserMapper;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.users.ldap.service.LdapCacheService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="authenticator#ldap")
public class LdapBindAuthenticator
extends AbstractAuthenticator
implements Authenticator {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    @Named(value="userMapper#ldap")
    private UserMapper mapper;
    @Inject
    @Named(value="ldapConnectionFactory#configurable")
    private LdapConnectionFactory connectionFactory;
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration config;
    @Inject
    private LdapCacheService ldapCacheService;

    public String getId() {
        return "LdapBindAuthenticator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult authenticate(AuthenticationDataSource s) throws AuthenticationException {
        AuthenticationResult authenticationResult;
        PasswordBasedAuthenticationDataSource source = (PasswordBasedAuthenticationDataSource)s;
        if (!this.config.getBoolean("ldap.bind.authenticator.enabled") || !this.config.getBoolean("ldap.bind.authenticator.allowEmptyPasswords", false) && StringUtils.isEmpty((String)source.getPassword())) {
            return new AuthenticationResult(false, source.getUsername(), null);
        }
        SearchControls ctls = new SearchControls();
        ctls.setCountLimit(1L);
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        String filter = "(&(objectClass=" + this.mapper.getUserObjectClass() + ")" + (this.mapper.getUserFilter() != null ? this.mapper.getUserFilter() : "") + "(" + this.mapper.getUserIdAttribute() + "=" + LdapUtils.encodeFilterValue((String)source.getUsername()) + "))";
        this.log.debug("Searching for users with filter: '{}' from base dn: {}", (Object)filter, (Object)this.mapper.getUserBaseDn());
        LdapConnection ldapConnection = null;
        LdapConnection authLdapConnection = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            ldapConnection = this.getLdapConnection();
            String userDn = this.ldapCacheService.getLdapUserDn(source.getUsername());
            if (userDn == null) {
                this.log.debug("userDn for user {} not found in cache. Retrieving from ldap server..", (Object)source.getUsername());
                DirContext context = ldapConnection.getDirContext();
                results = context.search(this.mapper.getUserBaseDn(), filter, ctls);
                boolean moreElements = results.hasMoreElements();
                this.log.debug("Found user '{}': {}", (Object)source.getUsername(), (Object)moreElements);
                if (moreElements) {
                    try {
                        SearchResult result = (SearchResult)results.nextElement();
                        userDn = result.getNameInNamespace();
                        this.log.debug("Adding userDn {} for user {} to the cache..", (Object)userDn, (Object)source.getUsername());
                        this.ldapCacheService.addLdapUserDn(source.getUsername(), userDn);
                    }
                    catch (Exception e) {
                        this.log.error("Error occured on LDAP result retrieval: {}, {}", (Object)userDn, (Object)e.getMessage());
                        AuthenticationResult authenticationResult2 = new AuthenticationResult(false, source.getUsername(), e);
                        this.closeNamingEnumeration(results);
                        this.closeLdapConnection(ldapConnection);
                        if (authLdapConnection != null) {
                            this.closeLdapConnection(authLdapConnection);
                        }
                        return authenticationResult2;
                    }
                } else {
                    AuthenticationResult authenticationResult3 = new AuthenticationResult(false, source.getUsername(), null);
                    this.closeNamingEnumeration(results);
                    this.closeLdapConnection(ldapConnection);
                    if (authLdapConnection != null) {
                        this.closeLdapConnection(authLdapConnection);
                    }
                    return authenticationResult3;
                }
            }
            this.log.debug("Attempting Authenication: {}", (Object)userDn);
            authLdapConnection = this.connectionFactory.getConnection(userDn, source.getPassword());
            this.log.info("user '{}' authenticated", (Object)source.getUsername());
            authenticationResult = new AuthenticationResult(true, source.getUsername(), null);
            this.closeNamingEnumeration(results);
        }
        catch (LdapException e) {
            authenticationResult = new AuthenticationResult(false, source.getUsername(), (Exception)((Object)e));
            return authenticationResult;
        }
        catch (NamingException e) {
            authenticationResult = new AuthenticationResult(false, source.getUsername(), (Exception)e);
            return authenticationResult;
        }
        finally {
            this.closeNamingEnumeration(results);
            this.closeLdapConnection(ldapConnection);
            if (authLdapConnection != null) {
                this.closeLdapConnection(authLdapConnection);
            }
        }
        this.closeLdapConnection(ldapConnection);
        if (authLdapConnection != null) {
            this.closeLdapConnection(authLdapConnection);
        }
        return authenticationResult;
    }

    public boolean supportsDataSource(AuthenticationDataSource source) {
        return source instanceof PasswordBasedAuthenticationDataSource;
    }

    private LdapConnection getLdapConnection() throws LdapException {
        return this.connectionFactory.getConnection();
    }

    private void closeLdapConnection(LdapConnection ldapConnection) {
        if (ldapConnection != null) {
            ldapConnection.close();
        }
    }

    private void closeNamingEnumeration(NamingEnumeration<SearchResult> results) {
        try {
            if (results != null) {
                results.close();
            }
        }
        catch (NamingException e) {
            this.log.warn("skip exception closing naming search result {}", (Object)e.getMessage());
        }
    }

    public boolean isValid() {
        return this.connectionFactory.isValid();
    }
}

