/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.keys;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import org.apache.archiva.redback.keys.AuthenticationKey;
import org.apache.archiva.redback.keys.KeyManager;
import org.apache.archiva.redback.keys.KeyManagerException;
import org.apache.archiva.redback.keys.KeyNotFoundException;
import org.codehaus.plexus.digest.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyManager
implements KeyManager {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int KEY_LENGTH = 16;
    private static final boolean SECURE = true;
    private boolean randomMode = true;
    private SecureRandom secureRandom;
    private Random random;

    protected String generateUUID() throws KeyManagerException {
        byte[] vfour = new byte[16];
        if (this.isRandomMode()) {
            if (this.secureRandom == null) {
                try {
                    this.secureRandom = SecureRandom.getInstance("SHA1PRNG");
                }
                catch (NoSuchAlgorithmException e) {
                    this.setRandomMode(false);
                    this.log.warn("Unable to use SecureRandom", (Throwable)e);
                }
            }
            if (this.isRandomMode()) {
                this.secureRandom.nextBytes(vfour);
            }
        }
        if (!this.isRandomMode()) {
            if (this.random == null) {
                this.random = new Random();
            }
            this.random.nextBytes(vfour);
        }
        vfour[6] = (byte)(vfour[6] & 0xF);
        vfour[6] = (byte)(vfour[6] | 0x40);
        vfour[8] = (byte)(vfour[8] & 0x3F);
        vfour[8] = (byte)(vfour[8] | 0x80);
        return Hex.encode((byte[])vfour);
    }

    protected void assertNotExpired(AuthenticationKey authkey) throws KeyNotFoundException, KeyManagerException {
        if (authkey.getDateExpires() == null) {
            return;
        }
        Calendar now = this.getNowGMT();
        Calendar expiration = this.getNowGMT();
        expiration.setTime(authkey.getDateExpires());
        if (now.after(expiration)) {
            this.deleteKey(authkey);
            throw new KeyNotFoundException("Key [" + authkey.getKey() + "] has expired.");
        }
    }

    protected Calendar getNowGMT() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    public void setRandomMode(boolean randomMode) {
        this.randomMode = randomMode;
    }

    public boolean isRandomMode() {
        return this.randomMode;
    }

    @Override
    public void removeExpiredKeys() throws KeyManagerException {
        List<AuthenticationKey> allKeys = this.getAllKeys();
        Calendar now = this.getNowGMT();
        Calendar expiration = this.getNowGMT();
        this.log.info("Removing expired keys.");
        for (AuthenticationKey authkey : allKeys) {
            if (authkey.getDateExpires() == null) continue;
            expiration.setTime(authkey.getDateExpires());
            if (!now.after(expiration)) continue;
            this.deleteKey(authkey);
        }
        this.log.info("Expired keys removed.");
    }
}

