/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hector.api.ddl;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class ComparatorType {
    public static final ComparatorType ASCIITYPE = new ComparatorType("org.apache.cassandra.db.marshal.AsciiType");
    public static final ComparatorType BOOLEANTYPE = new ComparatorType("org.apache.cassandra.db.marshal.BooleanType");
    public static final ComparatorType BYTESTYPE = new ComparatorType("org.apache.cassandra.db.marshal.BytesType");
    public static final ComparatorType DATETYPE = new ComparatorType("org.apache.cassandra.db.marshal.DateType");
    public static final ComparatorType DECIMALTYPE = new ComparatorType("org.apache.cassandra.db.marshal.DecimalType");
    public static final ComparatorType FLOATTYPE = new ComparatorType("org.apache.cassandra.db.marshal.FloatType");
    public static final ComparatorType INTEGERTYPE = new ComparatorType("org.apache.cassandra.db.marshal.IntegerType");
    public static final ComparatorType INT32TYPE = new ComparatorType("org.apache.cassandra.db.marshal.Int32Type");
    public static final ComparatorType LEXICALUUIDTYPE = new ComparatorType("org.apache.cassandra.db.marshal.LexicalUUIDType");
    public static final ComparatorType LOCALBYPARTITIONERTYPE = new ComparatorType("org.apache.cassandra.db.marshal.LocalByPartionerType");
    public static final ComparatorType LONGTYPE = new ComparatorType("org.apache.cassandra.db.marshal.LongType");
    public static final ComparatorType TIMEUUIDTYPE = new ComparatorType("org.apache.cassandra.db.marshal.TimeUUIDType");
    public static final ComparatorType UTF8TYPE = new ComparatorType("org.apache.cassandra.db.marshal.UTF8Type");
    public static final ComparatorType COMPOSITETYPE = new ComparatorType("org.apache.cassandra.db.marshal.CompositeType");
    public static final ComparatorType DYNAMICCOMPOSITETYPE = new ComparatorType("org.apache.cassandra.db.marshal.DynamicCompositeType");
    public static final ComparatorType UUIDTYPE = new ComparatorType("org.apache.cassandra.db.marshal.UUIDType");
    public static final ComparatorType COUNTERTYPE = new ComparatorType("org.apache.cassandra.db.marshal.CounterColumnType");
    public static final ComparatorType REVERSEDTYPE = new ComparatorType("org.apache.cassandra.db.marshal.ReversedType");
    private static final Map<String, ComparatorType> valuesMap;
    private final String className;
    private final String typeName;

    private ComparatorType(String className) {
        this.className = className;
        this.typeName = className.startsWith("org.apache.cassandra.db.marshal.") ? className.substring("org.apache.cassandra.db.marshal.".length()) : className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static ComparatorType getByClassName(String className) {
        if (className == null) {
            return null;
        }
        ComparatorType type = valuesMap.get(className);
        if (type == null) {
            return new ComparatorType(className);
        }
        return type;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparatorType other = (ComparatorType)obj;
        return this.className.equals(other.className);
    }

    static {
        ComparatorType[] types = new ComparatorType[]{ASCIITYPE, BOOLEANTYPE, BYTESTYPE, DATETYPE, DECIMALTYPE, FLOATTYPE, INTEGERTYPE, INT32TYPE, LEXICALUUIDTYPE, LOCALBYPARTITIONERTYPE, LONGTYPE, TIMEUUIDTYPE, UTF8TYPE, COMPOSITETYPE, DYNAMICCOMPOSITETYPE, UUIDTYPE, COUNTERTYPE, REVERSEDTYPE};
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ComparatorType type : types) {
            builder.put((Object)type.getClassName(), (Object)type).put((Object)type.getTypeName(), (Object)type);
        }
        valuesMap = builder.build();
    }
}

