/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service.template;

import java.util.Collection;
import java.util.List;
import me.prettyprint.cassandra.model.HSlicePredicate;
import me.prettyprint.cassandra.serializers.SerializerTypeInferer;
import me.prettyprint.cassandra.service.template.AbstractColumnFamilyTemplate;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ColumnFamilyRowMapper;
import me.prettyprint.cassandra.service.template.ColumnFamilyUpdater;
import me.prettyprint.cassandra.service.template.IndexedSlicesPredicate;
import me.prettyprint.cassandra.service.template.MappedColumnFamilyResult;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.ColumnQuery;
import me.prettyprint.hector.api.query.CountQuery;
import me.prettyprint.hector.api.query.QueryResult;

public abstract class ColumnFamilyTemplate<K, N>
extends AbstractColumnFamilyTemplate<K, N> {
    public ColumnFamilyTemplate(Keyspace keyspace, String columnFamily, Serializer<K> keySerializer, Serializer<N> topSerializer) {
        super(keyspace, columnFamily, keySerializer, topSerializer);
    }

    @Override
    public ColumnFamilyTemplate<K, N> setBatched(boolean batched) {
        super.setBatched(batched);
        return this;
    }

    public ColumnFamilyUpdater<K, N> createUpdater() {
        ColumnFamilyUpdater updater = new ColumnFamilyUpdater(this, this.columnFactory);
        return updater;
    }

    public ColumnFamilyUpdater<K, N> createUpdater(K key) {
        ColumnFamilyUpdater updater = new ColumnFamilyUpdater(this, this.columnFactory);
        updater.addKey(key);
        return updater;
    }

    public ColumnFamilyUpdater<K, N> createUpdater(K key, Mutator<K> mutator) {
        ColumnFamilyUpdater updater = new ColumnFamilyUpdater(this, this.columnFactory, mutator);
        updater.addKey(key);
        return updater;
    }

    public void update(ColumnFamilyUpdater<K, N> updater) {
        updater.update();
        this.executeIfNotBatched(updater);
    }

    public boolean isColumnsExist(K key) {
        return this.countColumns(key) > 0;
    }

    public int countColumns(K key) {
        return this.countColumns(key, ALL_COLUMNS_START, ALL_COLUMNS_END, Integer.MAX_VALUE);
    }

    public int countColumns(K key, N start, N end, int max) {
        CountQuery<K, N> query = HFactory.createCountQuery(this.keyspace, this.keySerializer, this.topSerializer);
        query.setKey(key);
        query.setColumnFamily(this.columnFamily);
        query.setRange(start, end, max);
        return (Integer)query.execute().get();
    }

    public ColumnFamilyResult<K, N> queryColumns(K key) {
        return this.doExecuteSlice(key, this.activeSlicePredicate);
    }

    public ColumnFamilyResult<K, N> queryColumns(Iterable<K> keys) {
        return this.doExecuteMultigetSlice(keys, this.activeSlicePredicate);
    }

    public <T> T queryColumns(K key, ColumnFamilyRowMapper<K, N, T> mapper) {
        return this.queryColumns(key, this.activeSlicePredicate, mapper);
    }

    public <T> T queryColumns(K key, HSlicePredicate<N> predicate, ColumnFamilyRowMapper<K, N, T> mapper) {
        return this.doExecuteSlice(key, predicate, mapper);
    }

    public <T> T queryColumns(K key, List<N> columns, ColumnFamilyRowMapper<K, N, T> mapper) {
        HSlicePredicate<N> predicate = new HSlicePredicate<N>(this.topSerializer);
        predicate.setColumnNames((Collection<N>)columns);
        return this.doExecuteSlice(key, predicate, mapper);
    }

    public ColumnFamilyResult<K, N> queryColumns(K key, List<N> columns) {
        HSlicePredicate<N> predicate = new HSlicePredicate<N>(this.topSerializer);
        predicate.setColumnNames((Collection<N>)columns);
        return this.doExecuteSlice(key, predicate);
    }

    public ColumnFamilyResult<K, N> queryColumns(Iterable<K> keys, List<N> columns) {
        HSlicePredicate<N> predicate = new HSlicePredicate<N>(this.topSerializer);
        predicate.setColumnNames((Collection<N>)columns);
        return this.doExecuteMultigetSlice(keys, predicate);
    }

    public ColumnFamilyResult<K, N> queryColumns(K key, HSlicePredicate<N> predicate) {
        return this.doExecuteSlice(key, predicate);
    }

    public <V> MappedColumnFamilyResult<K, N, V> queryColumns(Iterable<K> keys, ColumnFamilyRowMapper<K, N, V> mapper) {
        return this.doExecuteMultigetSlice(keys, this.activeSlicePredicate, mapper);
    }

    public <V> MappedColumnFamilyResult<K, N, V> queryColumns(Iterable<K> keys, HSlicePredicate<N> predicate, ColumnFamilyRowMapper<K, N, V> mapper) {
        return this.doExecuteMultigetSlice(keys, predicate, mapper);
    }

    public <V> MappedColumnFamilyResult<K, N, V> queryColumns(Iterable<K> keys, List<N> columns, ColumnFamilyRowMapper<K, N, V> mapper) {
        HSlicePredicate<N> predicate = new HSlicePredicate<N>(this.topSerializer);
        predicate.setColumnNames((Collection<N>)columns);
        return this.doExecuteMultigetSlice(keys, predicate, mapper);
    }

    public <V> ColumnFamilyResult<K, N> queryColumns(IndexedSlicesPredicate<K, N, V> predicate) {
        return this.doExecuteIndexedSlices(predicate);
    }

    public <V> ColumnFamilyResult<K, N> queryColumns(IndexedSlicesPredicate<K, N, V> predicate, HSlicePredicate<N> slicePredicate) {
        return this.doExecuteIndexedSlices(predicate, slicePredicate);
    }

    public <V> ColumnFamilyResult<K, N> queryColumns(IndexedSlicesPredicate<K, N, V> predicate, List<N> columns) {
        HSlicePredicate<N> slicePredicate = new HSlicePredicate<N>(this.topSerializer);
        slicePredicate.setColumnNames((Collection<N>)columns);
        return this.doExecuteIndexedSlices(predicate, slicePredicate);
    }

    public <R, V> MappedColumnFamilyResult<K, N, R> queryColumns(IndexedSlicesPredicate<K, N, V> predicate, ColumnFamilyRowMapper<K, N, R> mapper) {
        return this.doExecuteIndexedSlices(predicate, mapper);
    }

    public <R, V> MappedColumnFamilyResult<K, N, R> queryColumns(IndexedSlicesPredicate<K, N, V> predicate, HSlicePredicate<N> slicePredicate, ColumnFamilyRowMapper<K, N, R> mapper) {
        return this.doExecuteIndexedSlices(predicate, slicePredicate, mapper);
    }

    public <R, V> MappedColumnFamilyResult<K, N, R> queryColumns(IndexedSlicesPredicate<K, N, V> predicate, List<N> columns, ColumnFamilyRowMapper<K, N, R> mapper) {
        HSlicePredicate<N> slicePredicate = new HSlicePredicate<N>(this.topSerializer);
        slicePredicate.setColumnNames((Collection<N>)columns);
        return this.doExecuteIndexedSlices(predicate, slicePredicate, mapper);
    }

    public <V> HColumn<N, V> querySingleColumn(K key, N columnName, Class<V> valueClass) {
        return this.querySingleColumn(key, columnName, SerializerTypeInferer.getSerializer(valueClass));
    }

    public <V> HColumn<N, V> querySingleColumn(K key, N columnName, Serializer<V> valueSerializer) {
        ColumnQuery<K, N, V> query = HFactory.createColumnQuery(this.keyspace, this.keySerializer, this.topSerializer, valueSerializer);
        query.setColumnFamily(this.columnFamily);
        query.setKey(key);
        query.setName(columnName);
        QueryResult result = query.execute();
        return result != null ? (HColumn)result.get() : null;
    }

    protected abstract <T> T doExecuteSlice(K var1, HSlicePredicate<N> var2, ColumnFamilyRowMapper<K, N, T> var3);

    protected abstract ColumnFamilyResult<K, N> doExecuteSlice(K var1, HSlicePredicate<N> var2);

    protected abstract ColumnFamilyResult<K, N> doExecuteMultigetSlice(Iterable<K> var1, HSlicePredicate<N> var2);

    protected abstract <V> MappedColumnFamilyResult<K, N, V> doExecuteMultigetSlice(Iterable<K> var1, HSlicePredicate<N> var2, ColumnFamilyRowMapper<K, N, V> var3);

    protected abstract <V> ColumnFamilyResult<K, N> doExecuteIndexedSlices(IndexedSlicesPredicate<K, N, V> var1);

    protected abstract <V> ColumnFamilyResult<K, N> doExecuteIndexedSlices(IndexedSlicesPredicate<K, N, V> var1, HSlicePredicate<N> var2);

    protected abstract <R, V> MappedColumnFamilyResult<K, N, R> doExecuteIndexedSlices(IndexedSlicesPredicate<K, N, V> var1, ColumnFamilyRowMapper<K, N, R> var2);

    protected abstract <R, V> MappedColumnFamilyResult<K, N, R> doExecuteIndexedSlices(IndexedSlicesPredicate<K, N, V> var1, HSlicePredicate<N> var2, ColumnFamilyRowMapper<K, N, R> var3);
}

