/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Iterator;
import java.util.List;
import me.prettyprint.cassandra.service.template.SliceFilter;
import me.prettyprint.hector.api.beans.CounterSlice;
import me.prettyprint.hector.api.beans.HCounterColumn;
import me.prettyprint.hector.api.query.SliceCounterQuery;

public class SliceCounterIterator<K, N>
implements Iterator<HCounterColumn<N>> {
    private static final int DEFAULT_COUNT = 100;
    private SliceCounterQuery<K, N> query;
    private PeekingIterator<HCounterColumn<N>> iterator;
    private N start;
    private SliceCounterFinish<N> finish;
    private SliceFilter<HCounterColumn<N>> filter = null;
    private boolean reversed;
    private int count = 100;
    private int columns = 0;

    public SliceCounterIterator(SliceCounterQuery<K, N> query, N start, N finish, boolean reversed) {
        this(query, start, finish, reversed, 100);
    }

    public SliceCounterIterator(SliceCounterQuery<K, N> query, N start, final N finish, boolean reversed, int count) {
        this(query, start, new SliceCounterFinish<N>(){

            @Override
            public N function() {
                return finish;
            }
        }, reversed, count);
    }

    public SliceCounterIterator(SliceCounterQuery<K, N> query, N start, SliceCounterFinish<N> finish, boolean reversed) {
        this(query, start, finish, reversed, 100);
    }

    public SliceCounterIterator(SliceCounterQuery<K, N> query, N start, SliceCounterFinish<N> finish, boolean reversed, int count) {
        this.query = query;
        this.start = start;
        this.finish = finish;
        this.reversed = reversed;
        this.count = count;
        this.query.setRange(this.start, this.finish.function(), this.reversed, this.count);
    }

    public SliceCounterIterator setFilter(SliceFilter<HCounterColumn<N>> filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = Iterators.peekingIterator(((CounterSlice)this.query.execute().get()).getColumns().iterator());
        } else if (!this.iterator.hasNext() && this.columns == this.count) {
            this.refresh();
        }
        while (this.filter != null && this.iterator != null && this.iterator.hasNext() && !this.filter.accept((HCounterColumn<N>)this.iterator.peek())) {
            this.next();
            if (this.iterator.hasNext() || this.columns != this.count) continue;
            this.refresh();
        }
        return this.iterator.hasNext();
    }

    @Override
    public HCounterColumn<N> next() {
        HCounterColumn column = (HCounterColumn)this.iterator.next();
        this.start = column.getName();
        ++this.columns;
        return column;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    private void refresh() {
        Object first;
        this.query.setRange(this.start, this.finish.function(), this.reversed, this.count);
        this.columns = 0;
        List list = ((CounterSlice)this.query.execute().get()).getColumns();
        this.iterator = Iterators.peekingIterator(list.iterator());
        if (this.iterator.hasNext() && (first = list.get(0).getName()).equals(this.start)) {
            this.next();
        }
    }

    public static interface SliceCounterFinish<N> {
        public N function();
    }
}

