/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Iterator;
import me.prettyprint.cassandra.service.template.SliceFilter;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.query.RangeSlicesQuery;

public class RangeSlicesIterator<K, N, V>
implements Iterator<Row<K, N, V>> {
    private RangeSlicesQuery<K, N, V> query;
    private K startKey;
    private K endKey;
    private PeekingIterator<Row<K, N, V>> iterator;
    private SliceFilter<Row<K, N, V>> filter = null;
    private int rows = 0;

    public RangeSlicesIterator(RangeSlicesQuery<K, N, V> query, K startKey, K endKey) {
        this.query = query;
        this.startKey = startKey;
        this.endKey = endKey;
        this.query.setKeys(startKey, endKey);
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = Iterators.peekingIterator(((OrderedRows)this.query.execute().get()).getList().iterator());
        } else if (!this.iterator.hasNext() && this.rows == this.query.getRowCount()) {
            this.query.setKeys(this.startKey, this.endKey);
            this.iterator = Iterators.peekingIterator(((OrderedRows)this.query.execute().get()).getList().iterator());
            this.rows = 0;
            if (this.iterator.hasNext()) {
                this.next();
            }
        }
        while (this.filter != null && this.iterator != null && this.iterator.hasNext() && !this.filter.accept((Row<K, N, V>)this.iterator.peek())) {
            this.next();
            if (this.iterator.hasNext() || this.rows != this.query.getRowCount()) continue;
            this.refresh();
        }
        return this.iterator.hasNext();
    }

    @Override
    public Row<K, N, V> next() {
        Row row = (Row)this.iterator.next();
        this.startKey = row.getKey();
        ++this.rows;
        return row;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public RangeSlicesIterator<K, N, V> setFilter(SliceFilter<Row<K, N, V>> filter) {
        this.filter = filter;
        return this;
    }

    private void refresh() {
        this.query.setKeys(this.startKey, this.endKey);
        this.iterator = Iterators.peekingIterator(((OrderedRows)this.query.execute().get()).getList().iterator());
        this.rows = 0;
        if (this.iterator.hasNext()) {
            this.next();
        }
    }
}

