/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.beans.Rows;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.MultigetSliceQuery;
import me.prettyprint.hector.api.query.QueryResult;

public class MultigetSliceIterator<K, N, V>
implements Iterator<Row<K, N, V>> {
    private static final int DEFAULT_MAXCOL_COUNT = 100;
    private static final int DEFAULT_MAXROW_COUNT_PERQUERY = 0;
    private static final int DEFAULT_MAX_THREAD_COUNT = 0;
    private Iterator<Row<K, N, V>> iterator;
    private N start;
    private N finish;
    private boolean reversed;
    private int rowKeysIndex = 0;
    private List<List<K>> rowKeysList = new LinkedList<List<K>>();
    private List<K> rowKeys = new LinkedList<K>();
    private int maxRowCountPerQuery = 0;
    private Keyspace keyspace;
    private Serializer<K> keySerializer;
    private Serializer<N> nameSerializer;
    private Serializer<V> valueSerializer;
    private String columnFamily;
    private AtomicLong totalExecutionTimeMicro = new AtomicLong(0L);
    private AtomicLong totalExecutionTimeNano = new AtomicLong(0L);
    private int maxThreads = 0;
    private int maxColumnCount = 100;
    private int threadCount = 0;
    private int numKeysPerThread;
    private Map<String, CassandraHost> m_hostsUsed = Collections.synchronizedMap(new HashMap());
    private List<Rows<K, N, V>> queryResult = Collections.synchronizedList(new LinkedList());

    public MultigetSliceIterator(boolean reversed, Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer, String columnFamily, List<K> rowKeys, N start, N finish) {
        this(reversed, keyspace, keySerializer, nameSerializer, valueSerializer, columnFamily, rowKeys, start, finish, 0, 0, 100);
    }

    public MultigetSliceIterator(boolean reversed, Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer, String columnFamily, List<K> rowKeys, N start, N finish, int maxColumnCountPerRow) {
        this(reversed, keyspace, keySerializer, nameSerializer, valueSerializer, columnFamily, rowKeys, start, finish, 0, 0, maxColumnCountPerRow);
    }

    public MultigetSliceIterator(boolean reversed, int maxRowCountPerQuery, Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer, String columnFamily, List<K> rowKeys, N start, N finish, int maxColumnCountPerRow) {
        this(reversed, keyspace, keySerializer, nameSerializer, valueSerializer, columnFamily, rowKeys, start, finish, 0, maxRowCountPerQuery, maxColumnCountPerRow);
    }

    public MultigetSliceIterator(boolean reversed, int maxRowCountPerQuery, Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer, String columnFamily, List<K> rowKeys, N start, N finish) {
        this(reversed, keyspace, keySerializer, nameSerializer, valueSerializer, columnFamily, rowKeys, start, finish, 0, maxRowCountPerQuery, 100);
    }

    public MultigetSliceIterator(boolean reversed, Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer, String columnFamily, List<K> rowKeys, N start, N finish, int maxThreadCount, int maxRowCountPerQuery, int maxColumnCountPerRow) {
        this.reversed = reversed;
        this.maxRowCountPerQuery = maxRowCountPerQuery;
        this.keyspace = keyspace;
        this.keySerializer = keySerializer;
        this.nameSerializer = nameSerializer;
        this.valueSerializer = valueSerializer;
        this.columnFamily = columnFamily;
        this.start = start;
        this.finish = finish;
        this.rowKeys = rowKeys;
        this.maxColumnCount = maxColumnCountPerRow;
        this.maxThreads = maxThreadCount;
        this.rowKeysList = this.prepareKeysForParallelism();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuery() {
        if (this.rowKeysList != null && this.rowKeysList.size() > 0) {
            if (this.threadCount > 1) {
                ExecutorService executor = Executors.newFixedThreadPool(this.threadCount);
                LinkedList futures = new LinkedList();
                for (final List<K> list : this.rowKeysList) {
                    Future<?> future = executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            MultigetSliceIterator.this.runMultigetSliceQuery(list);
                        }
                    });
                    futures.add(future);
                }
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException e) {
                        throw new HectorException("Failed to retrieve rows from Cassandra.", e);
                    }
                    catch (ExecutionException e) {
                        throw new HectorException("Failed to retrieve rows from Cassandra.", e);
                    }
                }
                executor.shutdown();
                this.rowKeysIndex = this.rowKeysList.size();
            } else {
                this.runMultigetSliceQuery(this.rowKeysList.get(this.rowKeysIndex));
                ++this.rowKeysIndex;
            }
        }
        ArrayList<Row> resultList = new ArrayList<Row>(this.queryResult.size());
        List<Rows<K, N, V>> list = this.queryResult;
        synchronized (list) {
            if (this.queryResult != null && this.queryResult.size() > 0) {
                for (Rows rows : this.queryResult) {
                    if (rows == null || rows.getCount() <= 0) continue;
                    for (Row row : rows) {
                        resultList.add(row);
                    }
                }
            }
        }
        this.iterator = resultList.iterator();
    }

    private void runMultigetSliceQuery(List<K> param) {
        MultigetSliceQuery<K, N, V> multigetSliceQuery = HFactory.createMultigetSliceQuery(this.keyspace, this.keySerializer, this.nameSerializer, this.valueSerializer);
        multigetSliceQuery.setColumnFamily(this.columnFamily);
        multigetSliceQuery.setKeys((Iterable<K>)param);
        multigetSliceQuery.setRange(this.start, this.finish, this.reversed, this.maxColumnCount);
        QueryResult result = multigetSliceQuery.execute();
        this.queryResult.add((Rows<K, N, V>)result.get());
        this.totalExecutionTimeMicro.addAndGet(result.getExecutionTimeMicro());
        this.totalExecutionTimeNano.addAndGet(result.getExecutionTimeNano());
        this.m_hostsUsed.put(result.getHostUsed().getIp(), result.getHostUsed());
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.runQuery();
        } else if (!this.iterator.hasNext() && this.rowKeysIndex < this.rowKeysList.size()) {
            this.runQuery();
        }
        return this.iterator.hasNext();
    }

    @Override
    public Row<K, N, V> next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public long getTotalExecutionTimeMicro() {
        return this.totalExecutionTimeMicro.get();
    }

    public long getTotalExecutionTimeNano() {
        return this.totalExecutionTimeNano.get();
    }

    public String getHostsUsed() {
        String hostsUsed = new String();
        StringBuilder strBldr = new StringBuilder();
        Set<Map.Entry<String, CassandraHost>> se = this.m_hostsUsed.entrySet();
        for (Map.Entry<String, CassandraHost> entry : se) {
            strBldr.append(entry.getValue().toString());
            strBldr.append(';');
        }
        if (se.size() > 0 && strBldr.length() > 0) {
            hostsUsed = strBldr.substring(0, strBldr.length() - 1);
        }
        return hostsUsed;
    }

    public int getThreadCountUsed() {
        return this.threadCount;
    }

    public int getRowCountPerQueryUsed() {
        return this.numKeysPerThread;
    }

    private List<List<K>> prepareKeysForParallelism() {
        List<List<Object>> returnKeys = new LinkedList<List<K>>();
        int numKeys = this.rowKeys.size();
        int numThreads = 1;
        if (this.maxRowCountPerQuery > 0) {
            numThreads = (int)Math.ceil((double)numKeys / (double)this.maxRowCountPerQuery);
            numThreads = Math.max(numThreads, 1);
        }
        this.threadCount = Math.min(numThreads, this.maxThreads);
        this.numKeysPerThread = (int)Math.ceil((double)numKeys / (double)numThreads);
        this.numKeysPerThread = Math.max(this.numKeysPerThread, 1);
        if (this.rowKeys != null && this.rowKeys.size() > 0) {
            returnKeys = Lists.partition(this.rowKeys, (int)this.numKeysPerThread);
        }
        return returnKeys;
    }
}

