/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class FailoverPolicy<E extends Throwable> {
    public static FailoverPolicy FAIL_FAST = new FailoverPolicy(0, 0);
    public static FailoverPolicy ON_FAIL_TRY_ONE_NEXT_AVAILABLE = new FailoverPolicy(1, 0);
    public static FailoverPolicy ON_FAIL_TRY_ALL_AVAILABLE = new FailoverPolicy(0x7FFFFFFE, 0);
    public final int numRetries;
    public final int sleepBetweenHostsMilli;
    public final Set<Class<E>> dontRetry;

    public FailoverPolicy(int numRetries, int sleepBwHostsMilli) {
        this.numRetries = numRetries;
        this.sleepBetweenHostsMilli = sleepBwHostsMilli;
        this.dontRetry = ImmutableSet.of();
    }

    public FailoverPolicy(int numRetries, int sleepBwHostsMilli, Class<E> dontRetryForType) {
        this.numRetries = numRetries;
        this.sleepBetweenHostsMilli = sleepBwHostsMilli;
        this.dontRetry = ImmutableSet.of(dontRetryForType);
    }

    public FailoverPolicy(int numRetries, int sleepBwHostsMilli, Set<Class<E>> dontRetryForTypes) {
        this.numRetries = numRetries;
        this.sleepBetweenHostsMilli = sleepBwHostsMilli;
        this.dontRetry = dontRetryForTypes;
    }

    public boolean shouldRetryFor(Class<E> candidate) {
        Preconditions.checkNotNull(candidate, (Object)"Requires a non-null candidate class");
        if (this.dontRetry != null) {
            return !this.dontRetry.contains(candidate);
        }
        return true;
    }
}

