/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import me.prettyprint.cassandra.service.BatchSizeHint;
import me.prettyprint.cassandra.service.SliceCounterIterator;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.SliceCounterQuery;

public class ClearCounterRow<K, N> {
    private Keyspace keyspace;
    private Serializer<K> keySerializer;
    private Serializer<N> nameSerializer;
    private K rowKey;
    private String cf;
    private int mutateInterval = 100;
    private int count = 100;

    public ClearCounterRow(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        this.keyspace = keyspace;
        this.keySerializer = keySerializer;
        this.nameSerializer = nameSerializer;
    }

    public ClearCounterRow<K, N> setColumnFamily(String cf) {
        this.cf = cf;
        return this;
    }

    public ClearCounterRow<K, N> setRowKey(K rowKey) {
        this.rowKey = rowKey;
        return this;
    }

    public ClearCounterRow<K, N> setMutateInterval(int interval) {
        this.mutateInterval = interval;
        return this;
    }

    public ClearCounterRow<K, N> setCount(int count) {
        this.count = count;
        return this;
    }

    public void clear() {
        Mutator<K> mutator = HFactory.createMutator(this.keyspace, this.keySerializer, new BatchSizeHint(1, this.mutateInterval));
        SliceCounterQuery<K, N> query = HFactory.createCounterSliceQuery(this.keyspace, this.keySerializer, this.nameSerializer).setColumnFamily(this.cf).setKey(this.rowKey);
        SliceCounterIterator<K, Object> iterator = new SliceCounterIterator<K, Object>(query, null, (Object)null, false, this.count);
        while (iterator.hasNext()) {
            Object column = iterator.next();
            mutator.incrementCounter(this.rowKey, this.cf, column.getName(), column.getValue() * -1L);
        }
        mutator.execute();
    }
}

