/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import me.prettyprint.cassandra.connection.HClientPool;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.service.CassandraClientMonitorMBean;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.hector.api.exceptions.HectorTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraClientMonitor
implements CassandraClientMonitorMBean {
    private static final Logger log = LoggerFactory.getLogger(CassandraClientMonitor.class);
    private final Map<Counter, AtomicLong> counters;
    private final HConnectionManager connectionManager;

    public CassandraClientMonitor(HConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.counters = new EnumMap<Counter, AtomicLong>(Counter.class);
        for (Counter counter : Counter.values()) {
            this.counters.put(counter, new AtomicLong(0L));
        }
    }

    public void incCounter(Counter counterType) {
        this.counters.get((Object)counterType).incrementAndGet();
    }

    public long getWriteSuccess() {
        return this.counters.get((Object)Counter.WRITE_SUCCESS).longValue();
    }

    @Override
    public long getReadFail() {
        return this.counters.get((Object)Counter.READ_FAIL).longValue();
    }

    public long getReadSuccess() {
        return this.counters.get((Object)Counter.READ_SUCCESS).longValue();
    }

    @Override
    public long getSkipHostSuccess() {
        return this.counters.get((Object)Counter.SKIP_HOST_SUCCESS).longValue();
    }

    @Override
    public long getRecoverableTimedOutCount() {
        return this.counters.get((Object)Counter.RECOVERABLE_TIMED_OUT_EXCEPTIONS).longValue();
    }

    @Override
    public long getRecoverableUnavailableCount() {
        return this.counters.get((Object)Counter.RECOVERABLE_UNAVAILABLE_EXCEPTIONS).longValue();
    }

    @Override
    public long getWriteFail() {
        return this.counters.get((Object)Counter.WRITE_FAIL).longValue();
    }

    @Override
    public void updateKnownHosts() throws HectorTransportException {
        log.info("Updating all known cassandra hosts on all clients");
        this.connectionManager.doAddNodes();
    }

    @Override
    public long getNumPoolExhaustedEventCount() {
        return this.counters.get((Object)Counter.POOL_EXHAUSTED).longValue();
    }

    @Override
    public Set<String> getExhaustedPoolNames() {
        HashSet<String> ret = new HashSet<String>();
        for (CassandraHost host : this.connectionManager.getDownedHosts()) {
            ret.add(host.toString());
        }
        return ret;
    }

    @Override
    public int getNumActive() {
        int ret = 0;
        Collection<HClientPool> pools = this.connectionManager.getActivePools();
        for (HClientPool concurrentHClientPool : pools) {
            ret += concurrentHClientPool.getNumActive();
        }
        return ret;
    }

    @Override
    public int getNumBlockedThreads() {
        int ret = 0;
        Collection<HClientPool> pools = this.connectionManager.getActivePools();
        for (HClientPool concurrentHClientPool : pools) {
            ret += concurrentHClientPool.getNumBlockedThreads();
        }
        return ret;
    }

    @Override
    public int getNumExhaustedPools() {
        return this.connectionManager.getDownedHosts().size();
    }

    @Override
    public int getNumIdleConnections() {
        int ret = 0;
        Collection<HClientPool> pools = this.connectionManager.getActivePools();
        for (HClientPool concurrentHClientPool : pools) {
            ret += concurrentHClientPool.getNumIdle();
        }
        return ret;
    }

    @Override
    public int getNumPools() {
        return this.connectionManager.getHosts().size();
    }

    @Override
    public List<String> getKnownHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        for (CassandraHost cassandraHost : this.connectionManager.getHosts()) {
            hosts.add(cassandraHost.toString());
        }
        return hosts;
    }

    @Override
    public List<String> getStatisticsPerPool() {
        return this.connectionManager.getStatusPerPool();
    }

    @Override
    public long getRecoverableTransportExceptionCount() {
        return this.counters.get((Object)Counter.RECOVERABLE_TRANSPORT_EXCEPTIONS).longValue();
    }

    @Override
    public long getRecoverableErrorCount() {
        return this.getRecoverableTimedOutCount() + this.getRecoverableTransportExceptionCount() + this.getRecoverableUnavailableCount() + this.getRecoverableLoadBalancedConnectErrors();
    }

    @Override
    public long getRecoverableLoadBalancedConnectErrors() {
        return this.counters.get((Object)Counter.RECOVERABLE_LB_CONNECT_ERRORS).longValue();
    }

    @Override
    public long getNumConnectionErrors() {
        return this.counters.get((Object)Counter.CONNECT_ERROR).longValue();
    }

    @Override
    public boolean addCassandraHost(String hostStr) {
        return this.connectionManager.addCassandraHost(new CassandraHost(hostStr));
    }

    @Override
    public boolean removeCassandraHost(String hostStr) {
        return this.connectionManager.removeCassandraHost(new CassandraHost(hostStr));
    }

    @Override
    public Set<String> getSuspendedCassandraHosts() {
        Set<CassandraHost> hosts = this.connectionManager.getSuspendedCassandraHosts();
        HashSet<String> hostsStr = new HashSet<String>();
        for (CassandraHost host : hosts) {
            hostsStr.add(host.getName());
        }
        return hostsStr;
    }

    @Override
    public boolean suspendCassandraHost(String hostStr) {
        return this.connectionManager.suspendCassandraHost(new CassandraHost(hostStr));
    }

    @Override
    public boolean unsuspendCassandraHost(String hostStr) {
        return this.connectionManager.unsuspendCassandraHost(new CassandraHost(hostStr));
    }

    @Override
    public boolean setCassandraHostRetryDelay(String retryDelay) {
        try {
            int delay = Integer.parseInt(retryDelay);
            if (delay > 0) {
                this.connectionManager.setCassandraHostRetryDelay(delay);
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            log.error("Invalid number entered: " + retryDelay);
            return false;
        }
    }

    @Override
    public int getNumRenewedIdleConnections() {
        return this.counters.get((Object)Counter.RENEWED_IDLE_CONNECTIONS).intValue();
    }

    @Override
    public int getNumRenewedTooLongConnections() {
        return this.counters.get((Object)Counter.RENEWED_TOO_LONG_CONNECTIONS).intValue();
    }

    public static enum Counter {
        RECOVERABLE_TIMED_OUT_EXCEPTIONS,
        RECOVERABLE_UNAVAILABLE_EXCEPTIONS,
        RECOVERABLE_TRANSPORT_EXCEPTIONS,
        SKIP_HOST_SUCCESS,
        WRITE_SUCCESS,
        WRITE_FAIL,
        READ_SUCCESS,
        READ_FAIL,
        POOL_EXHAUSTED,
        RECOVERABLE_LB_CONNECT_ERRORS,
        CONNECT_ERROR,
        RENEWED_IDLE_CONNECTIONS,
        RENEWED_TOO_LONG_CONNECTIONS;

    }
}

