/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.nio.ByteBuffer;
import java.util.Date;
import me.prettyprint.cassandra.serializers.AbstractSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;

public final class DateSerializer
extends AbstractSerializer<Date> {
    private static final LongSerializer LONG_SERIALIZER = LongSerializer.get();
    private static final DateSerializer instance = new DateSerializer();

    public static DateSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Date obj) {
        if (obj == null) {
            return null;
        }
        return LONG_SERIALIZER.toByteBuffer(obj.getTime());
    }

    @Override
    public Date fromByteBuffer(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        return new Date(LONG_SERIALIZER.fromByteBuffer(bytes));
    }
}

