/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model.thrift;

import java.util.LinkedHashMap;
import java.util.Map;
import me.prettyprint.cassandra.model.AbstractSliceQuery;
import me.prettyprint.cassandra.model.HKeyRange;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.model.OrderedCounterRowsImpl;
import me.prettyprint.cassandra.model.QueryResultImpl;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.service.KeyspaceService;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.OrderedCounterRows;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSlicesCounterQuery;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftRangeSlicesCounterQuery<K, N>
extends AbstractSliceQuery<K, N, Long, OrderedCounterRows<K, N>>
implements RangeSlicesCounterQuery<K, N> {
    private final HKeyRange<K> keyRange;

    public ThriftRangeSlicesCounterQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        super(keyspace, keySerializer, nameSerializer, LongSerializer.get());
        this.keyRange = new HKeyRange<K>(keySerializer);
    }

    @Override
    public RangeSlicesCounterQuery<K, N> setKeys(K start, K end) {
        this.keyRange.setKeys(start, end);
        return this;
    }

    @Override
    public RangeSlicesCounterQuery<K, N> setTokens(K startKey, String startToken, String endToken) {
        this.keyRange.setTokens(startKey, startToken, endToken);
        return this;
    }

    @Override
    public RangeSlicesCounterQuery<K, N> setRowCount(int rowCount) {
        this.keyRange.setRowCount(rowCount);
        return this;
    }

    @Override
    public QueryResult<OrderedCounterRows<K, N>> execute() {
        Assert.notNull(this.columnFamilyName, "columnFamilyName can't be null");
        return new QueryResultImpl<OrderedCounterRows<K, N>>(this.keyspace.doExecute(new KeyspaceOperationCallback<OrderedCounterRows<K, N>>(){

            @Override
            public OrderedCounterRows<K, N> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(ThriftRangeSlicesCounterQuery.this.columnFamilyName);
                Map thriftRet = ThriftRangeSlicesCounterQuery.this.keySerializer.fromBytesMap(ks.getRangeCounterSlices(columnParent, ThriftRangeSlicesCounterQuery.this.getPredicate(), ThriftRangeSlicesCounterQuery.this.keyRange.toThrift()));
                return new OrderedCounterRowsImpl((LinkedHashMap)thriftRet, ThriftRangeSlicesCounterQuery.this.columnNameSerializer);
            }
        }), this);
    }

    public String toString() {
        return "RangeSlicesQuery(" + this.keyRange + super.toStringInternal() + ")";
    }

    @Override
    public RangeSlicesCounterQuery<K, N> setRange(N start, N finish, boolean reversed, int count) {
        return (RangeSlicesCounterQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public RangeSlicesCounterQuery<K, N> setColumnFamily(String cf) {
        return (RangeSlicesCounterQuery)super.setColumnFamily(cf);
    }

    @Override
    public RangeSlicesCounterQuery<K, N> setColumnNames(N ... columnNames) {
        return (RangeSlicesCounterQuery)super.setColumnNames(columnNames);
    }

    @Override
    public ThriftRangeSlicesCounterQuery<K, N> setReturnKeysOnly() {
        super.setReturnKeysOnly();
        return this;
    }
}

