/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.KeyRange;

public final class HKeyRange<K> {
    private K startKey;
    private K endKey;
    private String startToken;
    private String endToken;
    private List<IndexExpression> rowFilters;
    private int rowCount = 100;
    private final Serializer<K> keySerializer;

    public HKeyRange(Serializer<K> keySerializer) {
        Assert.notNull(keySerializer, "keySerializer is null");
        this.keySerializer = keySerializer;
    }

    public HKeyRange<K> setKeys(K start, K end) {
        this.startKey = start;
        this.endKey = end;
        this.startToken = null;
        this.endToken = null;
        return this;
    }

    public HKeyRange<K> setTokens(K startKey, String startToken, String endToken) {
        this.startKey = startKey;
        this.endKey = null;
        this.startToken = startToken;
        this.endToken = endToken;
        return this;
    }

    public HKeyRange<K> setRowCount(int rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void addToExpressions(IndexExpression elem) {
        if (this.rowFilters == null) {
            this.rowFilters = new ArrayList<IndexExpression>();
        }
        this.rowFilters.add(elem);
    }

    public KeyRange toThrift() {
        KeyRange keyRange = new KeyRange(this.rowCount);
        if (this.startToken != null) {
            keyRange.setStart_token(this.startToken);
        } else {
            keyRange.setStart_key(this.startKey == null ? ByteBuffer.wrap(new byte[0]) : this.keySerializer.toByteBuffer(this.startKey));
        }
        if (this.endToken != null) {
            keyRange.setEnd_token(this.endToken);
        } else {
            keyRange.setEnd_key(this.endKey == null ? ByteBuffer.wrap(new byte[0]) : this.keySerializer.toByteBuffer(this.endKey));
        }
        if (this.rowFilters != null) {
            for (IndexExpression filter : this.rowFilters) {
                keyRange.addToRow_filter(filter);
            }
        }
        return keyRange;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HKeyRange(start:");
        sb.append(this.startKey);
        sb.append(",end:");
        sb.append(this.endKey);
        sb.append(",indexed expressions:");
        if (this.rowFilters == null || this.rowFilters.isEmpty()) {
            sb.append("[]");
        } else {
            sb.append(Arrays.toString(this.rowFilters.toArray()));
        }
        sb.append(")");
        return sb.toString();
    }
}

