/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection.factory;

import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.connection.client.HSaslThriftClient;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.connection.security.SSLHelper;
import me.prettyprint.cassandra.service.CassandraHost;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HKerberosSaslThriftClientFactoryImpl
implements HClientFactory {
    private static final Logger log = LoggerFactory.getLogger(HKerberosSaslThriftClientFactoryImpl.class);
    public static final String JAAS_CONFIG = "jaas.conf";
    public static final String KRB5_CONFIG = "krb5.conf";
    private String krbServicePrincipalName;
    private TSSLTransportFactory.TSSLTransportParameters params = SSLHelper.getTSSLTransportParameters();

    public HKerberosSaslThriftClientFactoryImpl() {
        if (this.params != null) {
            log.debug("SSL properties:");
            log.debug("  ssl.truststore = {}", (Object)System.getProperty("ssl.truststore"));
            log.debug("  ssl.protocol = {}", (Object)System.getProperty("ssl.protocol"));
            log.debug("  ssl.store.type = {}", (Object)System.getProperty("ssl.store.type"));
            log.debug("  ssl.cipher.suites = {}", (Object)System.getProperty("ssl.cipher.suites"));
        }
        this.krbServicePrincipalName = System.getProperty("kerberos.service.principal.name");
        if (this.krbServicePrincipalName != null) {
            log.debug("Kerberos service principal name = {}", (Object)this.krbServicePrincipalName);
        }
    }

    @Override
    public HClient createClient(CassandraHost ch) {
        if (log.isDebugEnabled()) {
            log.debug("Creation of new client");
        }
        if (this.params == null) {
            return new HSaslThriftClient(ch, this.krbServicePrincipalName);
        }
        return new HSaslThriftClient(ch, this.krbServicePrincipalName, this.params);
    }
}

