/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection.client;

import com.sun.security.auth.module.Krb5LoginModule;
import java.io.IOException;
import java.net.SocketException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.connection.client.HThriftClient;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.hector.api.exceptions.HectorTransportException;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSaslThriftClient
extends HThriftClient
implements HClient {
    private static Logger log = LoggerFactory.getLogger(HSaslThriftClient.class);
    private String servicePrincipalName;
    private TSSLTransportFactory.TSSLTransportParameters params;
    public static final Map<String, String> SASL_PROPS = new TreeMap<String, String>(){
        {
            this.put("javax.security.sasl.qop", "auth");
            this.put("javax.security.sasl.server.authentication", "true");
        }
    };

    public HSaslThriftClient(CassandraHost cassandraHost, String servicePrincipalName) {
        super(cassandraHost);
        this.servicePrincipalName = servicePrincipalName;
    }

    public HSaslThriftClient(CassandraHost cassandraHost, String servicePrincipalName, TSSLTransportFactory.TSSLTransportParameters params) {
        super(cassandraHost);
        this.servicePrincipalName = servicePrincipalName;
        this.params = params;
    }

    @Override
    public HSaslThriftClient open() {
        TSocket socket;
        if (this.isOpen()) {
            throw new IllegalStateException("Open called on already open SASL connection. You should not have gotten here.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating a new SASL thrift connection to {}", (Object)this.cassandraHost);
        }
        try {
            socket = this.params == null ? new TSocket(this.cassandraHost.getHost(), this.cassandraHost.getPort(), this.timeout) : TSSLTransportFactory.getClientSocket((String)this.cassandraHost.getHost(), (int)this.cassandraHost.getPort(), (int)this.timeout, (TSSLTransportFactory.TSSLTransportParameters)this.params);
        }
        catch (TTransportException e) {
            throw new HectorTransportException("Could not get client socket: ", e);
        }
        if (this.cassandraHost.getUseSocketKeepalive()) {
            try {
                socket.getSocket().setKeepAlive(true);
            }
            catch (SocketException se) {
                throw new HectorTransportException("Could not set SO_KEEPALIVE on socket: ", se);
            }
        }
        try {
            this.transport = HSaslThriftClient.openKerberosTransport((TTransport)socket, this.servicePrincipalName);
        }
        catch (LoginException e) {
            log.error("Kerberos login failed: ", (Throwable)e);
            this.close();
            throw new HectorTransportException("Kerberos context couldn't be established with client: ", e);
        }
        catch (TTransportException e) {
            log.error("Failed to open Kerberos transport.", (Throwable)e);
            this.close();
            throw new HectorTransportException("Kerberos context couldn't be established with client: ", e);
        }
        this.transport = this.maybeWrapWithTFramedTransport(this.transport);
        return this;
    }

    public static TTransport openKerberosTransport(TTransport socket, String kerberosServicePrincipal) throws LoginException, TTransportException {
        try {
            log.debug("Opening kerberos transport...");
            Subject kerberosTicket = new Subject();
            KerberosUserConfiguration kerberosConfig = new KerberosUserConfiguration();
            LoginContext login = new LoginContext("Client", kerberosTicket, null, kerberosConfig);
            login.login();
            String nonDomainName = kerberosServicePrincipal.split("@")[0];
            String[] names = nonDomainName.split("[/]");
            if (names.length != 2) {
                throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + kerberosServicePrincipal);
            }
            final TSaslClientTransport transport = new TSaslClientTransport("GSSAPI", null, names[0], names[1], SASL_PROPS, null, socket);
            Subject.doAs(kerberosTicket, new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        transport.open();
                    }
                    catch (TTransportException e) {
                        throw new RuntimeException("Unable to connect to dse server:", e);
                    }
                    return null;
                }
            });
            log.debug("Kerberos transport opened successfully");
            return transport;
        }
        catch (IOException e) {
            throw new TTransportException("Failed to open secure transport using KERBEROS", (Throwable)e);
        }
    }

    public static class KerberosUserConfiguration
    extends Configuration {
        private static final HashMap<String, String> DEFAULT_KERBEROS_OPTIONS = new HashMap();
        private static final String[] recognizedOptions;
        private HashMap<String, String> options = new HashMap<String, String>(DEFAULT_KERBEROS_OPTIONS);

        public KerberosUserConfiguration() {
            log.debug("Setting Kerberos options:");
            for (int i = 0; i < recognizedOptions.length; ++i) {
                String option = recognizedOptions[i];
                String value = System.getProperty("kerberos." + option);
                if (value == null) continue;
                log.debug("  " + option + ": " + value);
                this.options.put(option, value);
            }
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String arg0) {
            AppConfigurationEntry kerberosLogin = new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, this.options);
            return new AppConfigurationEntry[]{kerberosLogin};
        }

        static {
            DEFAULT_KERBEROS_OPTIONS.put("doNotPrompt", "true");
            DEFAULT_KERBEROS_OPTIONS.put("useTicketCache", "true");
            DEFAULT_KERBEROS_OPTIONS.put("renewTGT", "true");
            DEFAULT_KERBEROS_OPTIONS.put("useKeyTab", "true");
            recognizedOptions = new String[]{"debug", "useTicketCache", "ticketCache", "renewTGT", "useKeyTab", "keyTab", "principal"};
        }
    }
}

