/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import me.prettyprint.cassandra.connection.ConcurrentHClientPool;
import me.prettyprint.cassandra.connection.HClientPool;
import me.prettyprint.cassandra.connection.LoadBalancingPolicy;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraHost;

public class RoundRobinBalancingPolicy
implements LoadBalancingPolicy {
    private static final long serialVersionUID = 1107204068032227079L;
    private int counter = 0;

    @Override
    public HClientPool getPool(Collection<HClientPool> pools, Set<CassandraHost> excludeHosts) {
        HClientPool pool = this.getPoolSafely(pools);
        if (excludeHosts != null && excludeHosts.size() > 0) {
            while (excludeHosts.contains(pool.getCassandraHost())) {
                pool = this.getPoolSafely(pools);
                if (excludeHosts.size() < pools.size()) continue;
                break;
            }
        }
        return pool;
    }

    private HClientPool getPoolSafely(Collection<HClientPool> pools) {
        try {
            return (HClientPool)Iterables.get(pools, (int)this.getAndIncrement(pools.size()));
        }
        catch (IndexOutOfBoundsException e) {
            return pools.iterator().next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAndIncrement(int size) {
        int counterToReturn;
        RoundRobinBalancingPolicy roundRobinBalancingPolicy = this;
        synchronized (roundRobinBalancingPolicy) {
            if (this.counter >= 16384) {
                this.counter = 0;
            }
            counterToReturn = this.counter++;
        }
        return counterToReturn % size;
    }

    @Override
    public HClientPool createConnection(HClientFactory clientFactory, CassandraHost host, CassandraClientMonitor monitor) {
        return new ConcurrentHClientPool(clientFactory, host, monitor);
    }
}

