/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCluster;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.cassandra.thrift.EndpointDetails;
import org.apache.cassandra.thrift.TokenRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDiscovery {
    private static final Logger log = LoggerFactory.getLogger(NodeDiscovery.class);
    private CassandraHostConfigurator cassandraHostConfigurator;
    private HConnectionManager connectionManager;
    private DataCenterValidator dataCenterValidator;
    private ThriftCluster cluster;

    public NodeDiscovery(CassandraHostConfigurator cassandraHostConfigurator, HConnectionManager connectionManager) {
        this((ThriftCluster)HFactory.getCluster(connectionManager.getClusterName()), cassandraHostConfigurator, connectionManager);
    }

    @VisibleForTesting
    NodeDiscovery(ThriftCluster cluster, CassandraHostConfigurator cassandraHostConfigurator, HConnectionManager connectionManager) {
        this.cassandraHostConfigurator = cassandraHostConfigurator;
        this.connectionManager = connectionManager;
        this.dataCenterValidator = new DataCenterValidator(cassandraHostConfigurator.getAutoDiscoveryDataCenters());
        this.cluster = cluster;
    }

    public void doAddNodes() {
        Set<CassandraHost> foundHosts;
        if (log.isDebugEnabled()) {
            log.debug("Node discovery running...");
        }
        if ((foundHosts = this.discoverNodes()) != null && foundHosts.size() > 0) {
            log.info("Found {} new host(s) in Ring", (Object)foundHosts.size());
            for (CassandraHost cassandraHost : foundHosts) {
                log.info("Addding found host {} to pool", (Object)cassandraHost);
                this.cassandraHostConfigurator.applyConfig(cassandraHost);
                this.connectionManager.addCassandraHost(cassandraHost);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Node discovery run complete.");
        }
    }

    public Set<CassandraHost> discoverNodes() {
        Set<CassandraHost> existingHosts = this.connectionManager.getHosts();
        HashSet<CassandraHost> foundHosts = new HashSet<CassandraHost>();
        if (log.isDebugEnabled()) {
            log.debug("using existing hosts {}", existingHosts);
        }
        try {
            for (KeyspaceDefinition keyspaceDefinition : this.cluster.describeKeyspaces()) {
                if (keyspaceDefinition.getName().equals("system")) continue;
                List<TokenRange> tokenRanges = this.cluster.describeRing(keyspaceDefinition.getName());
                for (TokenRange tokenRange : tokenRanges) {
                    for (EndpointDetails endPointDetail : tokenRange.getEndpoint_details()) {
                        CassandraHost foundHost;
                        if (this.dataCenterValidator != null && !this.dataCenterValidator.validate(endPointDetail.getDatacenter()) || existingHosts.contains(foundHost = new CassandraHost(endPointDetail.getHost(), this.cassandraHostConfigurator.getPort()))) continue;
                        log.info("Found a node we don't know about {} for TokenRange {}", (Object)foundHost, (Object)tokenRange);
                        foundHosts.add(foundHost);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("Discovery Service failed attempt to connect CassandraHost", (Throwable)e);
        }
        return foundHosts;
    }

    class DataCenterValidator {
        Set<String> dataCenters;

        public DataCenterValidator(List<String> dataCenters) {
            if (dataCenters != null) {
                this.dataCenters = new HashSet<String>(dataCenters);
            }
        }

        public boolean validate(String dcName) {
            if (this.dataCenters == null || dcName == null) {
                return true;
            }
            return this.dataCenters.contains(dcName);
        }
    }
}

