/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.concurrent.TimeUnit;
import me.prettyprint.cassandra.connection.BackgroundCassandraHostService;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.connection.NodeDiscovery;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAutoDiscoverService
extends BackgroundCassandraHostService {
    private static final Logger log = LoggerFactory.getLogger(NodeAutoDiscoverService.class);
    public static final int DEF_AUTO_DISCOVERY_DELAY = 30;
    private NodeDiscovery newNodeSearch;

    public NodeAutoDiscoverService(HConnectionManager connectionManager, CassandraHostConfigurator cassandraHostConfigurator) {
        super(connectionManager, cassandraHostConfigurator);
        this.retryDelayInSeconds = cassandraHostConfigurator.getAutoDiscoveryDelayInSeconds();
        this.newNodeSearch = new NodeDiscovery(cassandraHostConfigurator, connectionManager);
        this.sf = this.executor.scheduleWithFixedDelay(new QueryRing(), this.retryDelayInSeconds, this.retryDelayInSeconds, TimeUnit.SECONDS);
    }

    @Override
    void shutdown() {
        log.error("Auto Discovery retry shutdown hook called");
        if (this.sf != null) {
            this.sf.cancel(true);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        log.error("AutoDiscovery retry shutdown complete");
    }

    @Override
    public void applyRetryDelay() {
    }

    public void doAddNodes() {
        this.newNodeSearch.doAddNodes();
    }

    class QueryRing
    implements Runnable {
        QueryRing() {
        }

        @Override
        public void run() {
            NodeAutoDiscoverService.this.doAddNodes();
        }
    }
}

