/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.util.concurrent.TimeUnit;
import me.prettyprint.cassandra.connection.HOpTimer;

public class MetricsOpTimer
implements HOpTimer {
    private static final String TIMER_TYPE = "hector";
    private final MetricsRegistry metricsRegistry;
    private final TimeUnit durationUnit;
    private final TimeUnit rateUnit;
    private final String clusterName;

    public MetricsOpTimer(MetricsRegistry metricsRegistry, String clusterName, TimeUnit durationUnit, TimeUnit rateUnit) {
        this.metricsRegistry = metricsRegistry;
        this.clusterName = clusterName;
        this.durationUnit = durationUnit;
        this.rateUnit = rateUnit;
    }

    public MetricsOpTimer(String clusterName) {
        this.metricsRegistry = new MetricsRegistry();
        this.clusterName = clusterName;
        this.durationUnit = TimeUnit.NANOSECONDS;
        this.rateUnit = TimeUnit.SECONDS;
    }

    @Override
    public Object start(String tagName) {
        Timer timer = this.metricsRegistry.newTimer(new MetricName(this.clusterName, TIMER_TYPE, tagName), this.durationUnit, this.rateUnit);
        return timer.time();
    }

    @Override
    public void stop(Object token, String tagName, boolean success) {
        TimerContext timerContext = (TimerContext)token;
        timerContext.stop();
    }
}

