/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import me.prettyprint.cassandra.connection.ConcurrentHClientPool;
import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.hector.api.exceptions.HectorException;

public class LatencyAwareHClientPool
extends ConcurrentHClientPool {
    private static final AtomicInteger intervalupdates = new AtomicInteger(0);
    private static final int UPDATES_PER_INTERVAL = 1000;
    private static final int WINDOW_QUEUE_SIZE = 100;
    private static final double SENTINEL_COMPARE = 0.768;
    private final LinkedBlockingDeque<Double> latencies = new LinkedBlockingDeque(100);

    public LatencyAwareHClientPool(HClientFactory clientFactory, CassandraHost host, CassandraClientMonitor monitor) {
        super(clientFactory, host, monitor);
    }

    @Override
    public HClient borrowClient() throws HectorException {
        HClient client = super.borrowClient();
        client.startToUse();
        return client;
    }

    @Override
    public void releaseClient(HClient client) throws HectorException {
        this.add(client.getSinceLastUsed());
        super.releaseClient(client);
    }

    void add(double i) {
        if (intervalupdates.intValue() >= 1000) {
            return;
        }
        if (!this.latencies.offer(i)) {
            this.latencies.remove();
            this.latencies.offer(i);
        }
        intervalupdates.getAndIncrement();
    }

    double score() {
        double log = 0.0;
        if (this.latencies.size() > 0) {
            double probability = this.p(0.768);
            log = -1.0 * Math.log10(probability);
        }
        return log;
    }

    double p(double t) {
        double mean = this.mean();
        double exponent = -1.0 * t / mean;
        return 1.0 - Math.pow(Math.E, exponent);
    }

    private double mean() {
        double total = 0.0;
        for (double d : this.latencies) {
            total += d;
        }
        return total / (double)this.latencies.size();
    }

    public void resetIntervel() {
        intervalupdates.set(0);
    }

    public void clear() {
        this.latencies.clear();
        intervalupdates.set(0);
    }

    public boolean equals(Object obj) {
        return ((LatencyAwareHClientPool)obj).getCassandraHost().equals(this.getCassandraHost());
    }
}

