/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import me.prettyprint.cassandra.connection.HClientPool;
import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.hector.api.exceptions.HInactivePoolException;
import me.prettyprint.hector.api.exceptions.HPoolExhaustedException;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.exceptions.HectorTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentHClientPool
implements HClientPool {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentHClientPool.class);
    private final ArrayBlockingQueue<HClient> availableClientQueue;
    private final AtomicInteger activeClientsCount;
    private final AtomicInteger realActiveClientsCount;
    private final CassandraHost cassandraHost;
    private final AtomicInteger numBlocked;
    private final AtomicBoolean active;
    private final long maxWaitTimeWhenExhausted;
    private final HClientFactory clientFactory;
    private final CassandraClientMonitor monitor;

    public ConcurrentHClientPool(HClientFactory clientFactory, CassandraHost host, CassandraClientMonitor monitor) {
        this.clientFactory = clientFactory;
        this.cassandraHost = host;
        this.monitor = monitor;
        this.availableClientQueue = new ArrayBlockingQueue(this.cassandraHost.getMaxActive(), true);
        this.activeClientsCount = new AtomicInteger(0);
        this.realActiveClientsCount = new AtomicInteger(0);
        this.numBlocked = new AtomicInteger();
        this.active = new AtomicBoolean(true);
        this.maxWaitTimeWhenExhausted = this.cassandraHost.getMaxWaitTimeWhenExhausted() < 0L ? 0L : this.cassandraHost.getMaxWaitTimeWhenExhausted();
        for (int i = 0; i < this.cassandraHost.getMaxActive() / 3; ++i) {
            this.availableClientQueue.add(this.createClient());
        }
        if (log.isDebugEnabled()) {
            log.debug("Concurrent Host pool started with {} active clients; max: {} exhausted wait: {}", new Object[]{this.getNumIdle(), this.cassandraHost.getMaxActive(), this.maxWaitTimeWhenExhausted});
        }
    }

    @Override
    public HClient borrowClient() throws HectorException {
        if (!this.active.get()) {
            throw new HInactivePoolException("Attempt to borrow on in-active pool: " + this.getName());
        }
        HClient cassandraClient = this.availableClientQueue.poll();
        int currentActiveClients = this.activeClientsCount.incrementAndGet();
        try {
            if (cassandraClient != null && cassandraClient.getCassandraHost().getMaxLastSuccessTimeMillis() > 0L && cassandraClient.getLastSuccessTime() > 0L && System.currentTimeMillis() - cassandraClient.getLastSuccessTime() > cassandraClient.getCassandraHost().getMaxLastSuccessTimeMillis()) {
                log.info("Closing connection to {} due to too long idle time of {} ms", (Object)cassandraClient.getCassandraHost().getHost(), (Object)(System.currentTimeMillis() - cassandraClient.getLastSuccessTime()));
                cassandraClient.close();
                cassandraClient = null;
                this.monitor.incCounter(CassandraClientMonitor.Counter.RENEWED_IDLE_CONNECTIONS);
            }
            if (cassandraClient != null && cassandraClient.getCassandraHost().getMaxConnectTimeMillis() > 0L && System.currentTimeMillis() - cassandraClient.getCreatedTime() > cassandraClient.getCassandraHost().getMaxConnectTimeMillis()) {
                log.info("Closing connection to {} due to too long existence time of {} ms", (Object)cassandraClient.getCassandraHost().getHost(), (Object)(System.currentTimeMillis() - cassandraClient.getCreatedTime()));
                cassandraClient.close();
                cassandraClient = null;
                this.monitor.incCounter(CassandraClientMonitor.Counter.RENEWED_TOO_LONG_CONNECTIONS);
            }
            if (cassandraClient == null) {
                cassandraClient = currentActiveClients <= this.cassandraHost.getMaxActive() ? this.createClient() : this.waitForConnection();
            }
            if (cassandraClient == null) {
                throw new HectorException("HConnectionManager returned a null client after aquisition - are we shutting down?");
            }
        }
        catch (RuntimeException e) {
            this.activeClientsCount.decrementAndGet();
            throw e;
        }
        this.realActiveClientsCount.incrementAndGet();
        return cassandraClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HClient waitForConnection() {
        HClient cassandraClient;
        block11: {
            cassandraClient = null;
            this.numBlocked.incrementAndGet();
            if (log.isDebugEnabled()) {
                log.debug("blocking on queue - current block count {}", (Object)this.numBlocked.get());
            }
            try {
                if (this.maxWaitTimeWhenExhausted == 0L) {
                    while (cassandraClient == null && this.active.get()) {
                        try {
                            cassandraClient = this.availableClientQueue.poll(100L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException ie) {
                            log.error("InterruptedException poll operation on retry forever", (Throwable)ie);
                            break block11;
                        }
                    }
                    break block11;
                }
                try {
                    cassandraClient = this.availableClientQueue.poll(this.maxWaitTimeWhenExhausted, TimeUnit.MILLISECONDS);
                    if (cassandraClient == null) {
                        throw new HPoolExhaustedException(String.format("maxWaitTimeWhenExhausted exceeded for thread %s on host %s", Thread.currentThread().getName(), this.cassandraHost.getName()));
                    }
                }
                catch (InterruptedException ie) {
                    log.error("Cassandra client acquisition interrupted", (Throwable)ie);
                }
            }
            finally {
                this.numBlocked.decrementAndGet();
            }
        }
        return cassandraClient;
    }

    private HClient createClient() {
        return this.clientFactory.createClient(this.cassandraHost).open();
    }

    @Override
    public void shutdown() {
        if (!this.active.compareAndSet(true, false)) {
            throw new IllegalArgumentException("shutdown() called for inactive pool: " + this.getName());
        }
        log.info("Shutdown triggered on {}", (Object)this.getName());
        HashSet clients = new HashSet();
        this.availableClientQueue.drainTo(clients);
        if (clients.size() > 0) {
            for (HClient hClient : clients) {
                hClient.close();
            }
        }
        log.info("Shutdown complete on {}", (Object)this.getName());
    }

    @Override
    public CassandraHost getCassandraHost() {
        return this.cassandraHost;
    }

    @Override
    public String getName() {
        return String.format("<ConcurrentCassandraClientPoolByHost>:{%s}", this.cassandraHost.getName());
    }

    @Override
    public int getNumActive() {
        return this.realActiveClientsCount.get();
    }

    @Override
    public int getNumBeforeExhausted() {
        return this.cassandraHost.getMaxActive() - this.realActiveClientsCount.get();
    }

    @Override
    public int getNumBlockedThreads() {
        return this.numBlocked.intValue();
    }

    @Override
    public int getNumIdle() {
        return this.availableClientQueue.size();
    }

    @Override
    public boolean isExhausted() {
        return this.getNumBeforeExhausted() == 0;
    }

    @Override
    public int getMaxActive() {
        return this.cassandraHost.getMaxActive();
    }

    @Override
    public boolean getIsActive() {
        return this.active.get();
    }

    @Override
    public String getStatusAsString() {
        return String.format("%s; IsActive?: %s; Active: %d; Blocked: %d; Idle: %d; NumBeforeExhausted: %d", this.getName(), this.getIsActive(), this.getNumActive(), this.getNumBlockedThreads(), this.getNumIdle(), this.getNumBeforeExhausted());
    }

    @Override
    public void releaseClient(HClient client) throws HectorException {
        boolean open;
        if (this.cassandraHost.getMaxActive() == 0) {
            client.close();
        }
        if (open = client.isOpen()) {
            if (this.active.get()) {
                this.addClientToPoolGently(client);
            } else {
                log.info("Open client {} released to in-active pool for host {}. Closing.", (Object)client, (Object)this.cassandraHost);
                client.close();
            }
        } else {
            try {
                this.addClientToPoolGently(this.createClient());
            }
            catch (HectorTransportException e) {
                log.error("Transport exception in re-opening client in release on {}", (Object)this.getName());
            }
        }
        this.realActiveClientsCount.decrementAndGet();
        this.activeClientsCount.decrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Status of releaseClient {} to queue: {}", (Object)client.toString(), (Object)open);
        }
    }

    private void addClientToPoolGently(HClient client) {
        try {
            this.availableClientQueue.add(client);
        }
        catch (IllegalStateException ise) {
            log.warn("Capacity hit adding client back to queue. Closing extra");
            client.close();
        }
    }
}

