/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import me.prettyprint.cassandra.connection.BackgroundCassandraHostService;
import me.prettyprint.cassandra.connection.ConnectionManagerListenersHandler;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCluster;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.exceptions.HectorTransportException;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.cassandra.thrift.TokenRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraHostRetryService
extends BackgroundCassandraHostService {
    private static Logger log = LoggerFactory.getLogger(CassandraHostRetryService.class);
    public static final int DEF_QUEUE_SIZE = -1;
    public static final int DEF_RETRY_DELAY = 10;
    private final HClientFactory clientFactory;
    private final LinkedBlockingQueue<CassandraHost> downedHostQueue;
    private ConnectionManagerListenersHandler listenerHandler;

    public CassandraHostRetryService(HConnectionManager connectionManager, HClientFactory clientFactory, CassandraHostConfigurator cassandraHostConfigurator, ConnectionManagerListenersHandler listenerHandler) {
        super(connectionManager, cassandraHostConfigurator);
        this.clientFactory = clientFactory;
        this.listenerHandler = listenerHandler;
        this.retryDelayInSeconds = cassandraHostConfigurator.getRetryDownedHostsDelayInSeconds();
        this.downedHostQueue = new LinkedBlockingQueue(cassandraHostConfigurator.getRetryDownedHostsQueueSize() < 1 ? Integer.MAX_VALUE : cassandraHostConfigurator.getRetryDownedHostsQueueSize());
        this.sf = this.executor.scheduleWithFixedDelay(new RetryRunner(), this.retryDelayInSeconds, this.retryDelayInSeconds, TimeUnit.SECONDS);
        log.info("Downed Host Retry service started with queue size {} and retry delay {}s", (Object)cassandraHostConfigurator.getRetryDownedHostsQueueSize(), (Object)this.retryDelayInSeconds);
    }

    @Override
    void shutdown() {
        log.info("Downed Host retry shutdown hook called");
        if (this.sf != null) {
            this.sf.cancel(true);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        log.info("Downed Host retry shutdown complete");
    }

    public void add(final CassandraHost cassandraHost) {
        this.downedHostQueue.add(cassandraHost);
        if (log.isInfoEnabled()) {
            log.info("Host detected as down was added to retry queue: {}", (Object)cassandraHost.getName());
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (CassandraHostRetryService.this.downedHostQueue.contains(cassandraHost) && CassandraHostRetryService.this.verifyConnection(cassandraHost)) {
                    if (CassandraHostRetryService.this.connectionManager.addCassandraHost(cassandraHost)) {
                        CassandraHostRetryService.this.listenerHandler.fireOnHostRestored(cassandraHost);
                        CassandraHostRetryService.this.downedHostQueue.remove(cassandraHost);
                    }
                    return;
                }
            }
        });
    }

    public boolean remove(CassandraHost cassandraHost) {
        return this.downedHostQueue.remove(cassandraHost);
    }

    public boolean contains(CassandraHost cassandraHost) {
        return this.downedHostQueue.contains(cassandraHost);
    }

    public Set<CassandraHost> getDownedHosts() {
        return Collections.unmodifiableSet(new HashSet<CassandraHost>(this.downedHostQueue));
    }

    @Override
    public void applyRetryDelay() {
        this.sf.cancel(false);
        this.executor.schedule(new RetryRunner(), (long)this.retryDelayInSeconds, TimeUnit.SECONDS);
    }

    public void flushQueue() {
        this.downedHostQueue.clear();
        log.info("Downed Host retry queue flushed.");
    }

    private boolean verifyConnection(CassandraHost cassandraHost) {
        if (cassandraHost == null) {
            return false;
        }
        boolean found = false;
        HClient client = this.clientFactory.createClient(cassandraHost);
        try {
            client.open();
            found = client.getCassandra().describe_cluster_name() != null;
            client.close();
        }
        catch (HectorTransportException he) {
            log.warn("Downed {} host still appears to be down: {}", (Object)cassandraHost, (Object)he.getMessage());
        }
        catch (Throwable t) {
            log.error("Downed Host retry failed attempt to verify CassandraHost", t);
        }
        return found;
    }

    class RetryRunner
    implements Runnable {
        RetryRunner() {
        }

        @Override
        public void run() {
            if (!CassandraHostRetryService.this.downedHostQueue.isEmpty()) {
                log.debug("Retry service fired, checking {} downed hosts.", (Object)CassandraHostRetryService.this.downedHostQueue.size());
                try {
                    this.retryDownedHosts();
                }
                catch (Throwable t) {
                    log.error("An error occurred while retrying one or more downed hosts", t);
                }
            } else {
                log.debug("Retry service fired... nothing to do.");
            }
        }

        private void retryDownedHosts() {
            boolean checkRing = CassandraHostRetryService.this.connectionManager.getHosts().size() > 0;
            Set<CassandraHost> ringInfo = null;
            if (checkRing && (ringInfo = this.buildRingInfo()) != null && ringInfo.isEmpty()) {
                ringInfo = null;
                log.warn("Got an empty ring info, maybe not enough permission");
            }
            Iterator iter = CassandraHostRetryService.this.downedHostQueue.iterator();
            while (iter.hasNext()) {
                CassandraHost cassandraHost = (CassandraHost)iter.next();
                if (cassandraHost == null) continue;
                if (!checkRing) {
                    CassandraHostRetryService.this.listenerHandler.fireOnAllHostsDown();
                    log.info("Not checking that {} is a member of the ring since there are no live hosts", (Object)cassandraHost);
                }
                if (checkRing && ringInfo != null && !ringInfo.contains(cassandraHost)) {
                    log.info("Removing host " + cassandraHost.getName() + " - It does no longer exist in the ring.");
                    iter.remove();
                    continue;
                }
                boolean reconnected = CassandraHostRetryService.this.verifyConnection(cassandraHost);
                log.info("Downed Host retry status {} with host: {}", (Object)reconnected, (Object)cassandraHost.getName());
                if (!reconnected) continue;
                CassandraHostRetryService.this.connectionManager.addCassandraHost(cassandraHost);
                if (!CassandraHostRetryService.this.connectionManager.getHosts().contains(cassandraHost)) continue;
                CassandraHostRetryService.this.listenerHandler.fireOnHostRestored(cassandraHost);
                iter.remove();
            }
        }

        private Set<CassandraHost> buildRingInfo() {
            ThriftCluster cluster = (ThriftCluster)HFactory.getCluster(CassandraHostRetryService.this.connectionManager.getClusterName());
            if (cluster != null) {
                HashSet<CassandraHost> ringInfo = new HashSet<CassandraHost>();
                for (KeyspaceDefinition keyspaceDefinition : cluster.describeKeyspaces()) {
                    if (keyspaceDefinition.getName().equals("system")) continue;
                    List<TokenRange> tokenRanges = cluster.describeRing(keyspaceDefinition.getName());
                    for (TokenRange tokenRange : tokenRanges) {
                        for (String host : tokenRange.getRpc_endpoints()) {
                            CassandraHost aHost = new CassandraHost(host, CassandraHostRetryService.this.cassandraHostConfigurator.getPort());
                            if (ringInfo.contains(aHost)) continue;
                            ringInfo.add(aHost);
                        }
                    }
                }
                return ringInfo;
            }
            return null;
        }
    }
}

