/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.api.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.archiva.redback.integration.util.DateUtils;

@XmlRootElement(name="user")
public class User
implements Serializable {
    private String username;
    private String fullName;
    private String email;
    private boolean validated;
    private boolean locked;
    private String password;
    private boolean passwordChangeRequired;
    private boolean permanent;
    private String confirmPassword;
    private String timestampAccountCreation;
    private String timestampLastLogin;
    private String timestampLastPasswordChange;
    private String previousPassword;
    private List<String> assignedRoles;
    private boolean readOnly;
    private String userManagerId;
    private String validationToken;

    public User() {
    }

    public User(String username, String fullName, String email, boolean validated, boolean locked) {
        this.username = username;
        this.fullName = fullName;
        this.email = email;
        this.validated = validated;
        this.locked = locked;
    }

    public User(org.apache.archiva.redback.users.User user) {
        this.setUsername(user.getUsername());
        this.setEmail(user.getEmail());
        this.setFullName(user.getFullName());
        this.setLocked(user.isLocked());
        this.setPassword(user.getPassword());
        this.setValidated(user.isValidated());
        this.setPasswordChangeRequired(user.isPasswordChangeRequired());
        this.setPermanent(user.isPermanent());
        this.setUserManagerId(user.getUserManagerId());
        this.setTimestampAccountCreation(DateUtils.formatWithAge((Date)user.getAccountCreationDate(), (String)"ago"));
        this.setTimestampLastLogin(DateUtils.formatWithAge((Date)user.getLastLoginDate(), (String)"ago"));
        this.setTimestampLastPasswordChange(DateUtils.formatWithAge((Date)user.getLastPasswordChange(), (String)"ago"));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean isLocked) {
        this.locked = isLocked;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isPasswordChangeRequired() {
        return this.passwordChangeRequired;
    }

    public void setPasswordChangeRequired(boolean passwordChangeRequired) {
        this.passwordChangeRequired = passwordChangeRequired;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public String getTimestampAccountCreation() {
        return this.timestampAccountCreation;
    }

    public void setTimestampAccountCreation(String timestampAccountCreation) {
        this.timestampAccountCreation = timestampAccountCreation;
    }

    public String getTimestampLastLogin() {
        return this.timestampLastLogin;
    }

    public void setTimestampLastLogin(String timestampLastLogin) {
        this.timestampLastLogin = timestampLastLogin;
    }

    public String getTimestampLastPasswordChange() {
        return this.timestampLastPasswordChange;
    }

    public void setTimestampLastPasswordChange(String timestampLastPasswordChange) {
        this.timestampLastPasswordChange = timestampLastPasswordChange;
    }

    public String getPreviousPassword() {
        return this.previousPassword;
    }

    public void setPreviousPassword(String previousPassword) {
        this.previousPassword = previousPassword;
    }

    public List<String> getAssignedRoles() {
        return this.assignedRoles;
    }

    public void setAssignedRoles(List<String> assignedRoles) {
        this.assignedRoles = assignedRoles;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getUserManagerId() {
        return this.userManagerId;
    }

    public void setUserManagerId(String userManagerId) {
        this.userManagerId = userManagerId;
    }

    public String getValidationToken() {
        return this.validationToken;
    }

    public void setValidationToken(String validationToken) {
        this.validationToken = validationToken;
    }

    public String toString() {
        return "User{username='" + this.username + '\'' + ", fullName='" + this.fullName + '\'' + ", email='" + this.email + '\'' + ", validated=" + this.validated + ", locked=" + this.locked + ", passwordChangeRequired=" + this.passwordChangeRequired + ", permanent=" + this.permanent + ", confirmPassword='" + this.confirmPassword + '\'' + ", timestampAccountCreation='" + this.timestampAccountCreation + '\'' + ", timestampLastLogin='" + this.timestampLastLogin + '\'' + ", timestampLastPasswordChange='" + this.timestampLastPasswordChange + '\'' + ", previousPassword='" + this.previousPassword + '\'' + ", assignedRoles=" + this.assignedRoles + ", readOnly=" + this.readOnly + ", userManagerId='" + this.userManagerId + '\'' + ", validationToken='" + this.validationToken + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        return this.username.equals(user.username);
    }

    public int hashCode() {
        return this.username.hashCode();
    }
}

