/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.common.ldap;

import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.archiva.redback.common.ldap.MappingException;

public final class LdapUtils {
    private static String[] FILTER_ESCAPE_TABLE = new String[93];

    private LdapUtils() {
    }

    public static String getLabeledUriValue(Attributes attributes, String attrName, String label, String attributeDescription) throws MappingException {
        if (attrName == null) {
            return null;
        }
        Attribute attribute = attributes.get(attrName);
        if (attribute != null) {
            NamingEnumeration<?> attrs;
            try {
                attrs = attribute.getAll();
            }
            catch (NamingException e) {
                throw new MappingException("Failed to retrieve " + attributeDescription + " (attribute: '" + attrName + "').", e);
            }
            while (attrs.hasMoreElements()) {
                Object value = attrs.nextElement();
                String val = String.valueOf(value);
                if (!val.endsWith(" " + label)) continue;
                return val.substring(0, val.length() - (label.length() + 1));
            }
        }
        return null;
    }

    public static String getAttributeValue(Attributes attributes, String attrName, String attributeDescription) throws MappingException {
        if (attrName == null) {
            return null;
        }
        Attribute attribute = attributes.get(attrName);
        if (attribute != null) {
            try {
                Object value = attribute.get();
                return String.valueOf(value);
            }
            catch (NamingException e) {
                throw new MappingException("Failed to retrieve " + attributeDescription + " (attribute: '" + attrName + "').", e);
            }
        }
        return null;
    }

    public static String getAttributeValueFromByteArray(Attributes attributes, String attrName, String attributeDescription) throws MappingException {
        if (attrName == null) {
            return null;
        }
        Attribute attribute = attributes.get(attrName);
        if (attribute != null) {
            try {
                byte[] value = (byte[])attribute.get();
                return new String(value);
            }
            catch (NamingException e) {
                throw new MappingException("Failed to retrieve " + attributeDescription + " (attribute: '" + attrName + "').", e);
            }
        }
        return null;
    }

    public static LdapName getLdapNameFromString(String name) throws InvalidNameException {
        CompositeName coName = new CompositeName(name);
        LdapName ldapName = new LdapName("");
        ldapName.addAll(coName);
        return ldapName;
    }

    public static String findFirstRdnValue(LdapName name, String type) {
        for (Rdn rdn : name.getRdns()) {
            if (!rdn.getType().equals(type)) continue;
            Object val = rdn.getValue();
            if (val != null) {
                return val.toString();
            }
            return "";
        }
        return "";
    }

    public static String encodeFilterValue(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder encodedValue = new StringBuilder(value.length() * 2);
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c < FILTER_ESCAPE_TABLE.length) {
                encodedValue.append(FILTER_ESCAPE_TABLE[c]);
                continue;
            }
            encodedValue.append(c);
        }
        return encodedValue.toString();
    }

    static {
        for (char c = '\u0000'; c < FILTER_ESCAPE_TABLE.length; c = (char)(c + '\u0001')) {
            LdapUtils.FILTER_ESCAPE_TABLE[c] = String.valueOf(c);
        }
        LdapUtils.FILTER_ESCAPE_TABLE[42] = "\\2a";
        LdapUtils.FILTER_ESCAPE_TABLE[40] = "\\28";
        LdapUtils.FILTER_ESCAPE_TABLE[41] = "\\29";
        LdapUtils.FILTER_ESCAPE_TABLE[92] = "\\5c";
        LdapUtils.FILTER_ESCAPE_TABLE[0] = "\\00";
    }
}

