/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.functors;

import java.util.List;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.utils.BaseFile;
import org.apache.archiva.consumers.RepositoryContentConsumer;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerWantsFilePredicate
implements Predicate {
    private BaseFile basefile;
    private boolean isCaseSensitive = true;
    private int wantedFileCount = 0;
    private long changesSince = 0L;
    private ManagedRepository managedRepository;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ConsumerWantsFilePredicate() {
    }

    public ConsumerWantsFilePredicate(ManagedRepository managedRepository) {
        this.managedRepository = managedRepository;
    }

    public boolean evaluate(Object object) {
        RepositoryContentConsumer consumer;
        boolean satisfies = false;
        if (object instanceof RepositoryContentConsumer && this.wantsFile(consumer = (RepositoryContentConsumer)object, FilenameUtils.separatorsToUnix((String)this.basefile.getRelativePath()))) {
            satisfies = true;
            ++this.wantedFileCount;
            if (!consumer.isProcessUnmodified() && this.basefile.lastModified() < this.changesSince) {
                satisfies = false;
            }
        }
        return satisfies;
    }

    public BaseFile getBasefile() {
        return this.basefile;
    }

    public int getWantedFileCount() {
        return this.wantedFileCount;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setBasefile(BaseFile basefile) {
        this.basefile = basefile;
        this.wantedFileCount = 0;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    private boolean wantsFile(RepositoryContentConsumer consumer, String relativePath) {
        String indexDirectory;
        List<String> excludes = consumer.getExcludes();
        if (excludes != null) {
            for (String pattern : excludes) {
                if (!SelectorUtils.matchPath((String)pattern, (String)relativePath, (boolean)this.isCaseSensitive)) continue;
                return false;
            }
        }
        if (this.managedRepository != null && StringUtils.startsWith((String)relativePath, (String)(indexDirectory = this.managedRepository.getIndexDirectory()))) {
            this.logger.debug("ignore file {} part of the index directory {}", (Object)relativePath, (Object)indexDirectory);
            return false;
        }
        for (String pattern : consumer.getIncludes()) {
            if (!SelectorUtils.matchPath((String)pattern, (String)relativePath, (boolean)this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public void setChangesSince(long changesSince) {
        this.changesSince = changesSince;
    }
}

