/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.archiva.common.FileTypeUtils;
import org.apache.archiva.consumers.Consumer;
import org.apache.archiva.consumers.ConsumerMonitor;

public abstract class AbstractMonitoredConsumer
implements Consumer {
    private final Set<ConsumerMonitor> monitors = new HashSet<ConsumerMonitor>();

    @Override
    public void addConsumerMonitor(ConsumerMonitor monitor) {
        this.monitors.add(monitor);
    }

    @Override
    public void removeConsumerMonitor(ConsumerMonitor monitor) {
        this.monitors.remove(monitor);
    }

    protected void triggerConsumerError(String type, String message) {
        for (ConsumerMonitor monitor : this.monitors) {
            try {
                monitor.consumerError(this, type, message);
            }
            catch (Throwable throwable) {}
        }
    }

    protected void triggerConsumerWarning(String type, String message) {
        for (ConsumerMonitor monitor : this.monitors) {
            try {
                monitor.consumerWarning(this, type, message);
            }
            catch (Throwable throwable) {}
        }
    }

    protected void triggerConsumerInfo(String message) {
        for (ConsumerMonitor monitor : this.monitors) {
            try {
                monitor.consumerInfo(this, message);
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean isProcessUnmodified() {
        return false;
    }

    protected List<String> getDefaultArtifactExclusions() {
        return FileTypeUtils.DEFAULT_EXCLUSIONS;
    }
}

